/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import tech.bitey.bufferstuff.SmallDoubleBuffer;
import tech.bitey.bufferstuff.SmallIntBuffer;
import tech.bitey.bufferstuff.SmallLongBuffer;

public class BufferSpliterators {

    public static final class SmallDoubleBufferSpliterator
    implements Spliterator.OfDouble {
        private final SmallDoubleBuffer buffer;
        private int index;
        private final int fence;
        private final int characteristics;

        public SmallDoubleBufferSpliterator(SmallDoubleBuffer buffer, int additionalCharacteristics) {
            this(buffer, 0, buffer.capacity(), additionalCharacteristics);
        }

        public SmallDoubleBufferSpliterator(SmallDoubleBuffer buffer, int origin, int fence, int additionalCharacteristics) {
            this.buffer = buffer;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            SmallDoubleBufferSpliterator smallDoubleBufferSpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                smallDoubleBufferSpliterator = null;
            } else {
                this.index = mid;
                SmallDoubleBufferSpliterator smallDoubleBufferSpliterator2 = new SmallDoubleBufferSpliterator(this.buffer, lo, this.index, this.characteristics);
                smallDoubleBufferSpliterator = smallDoubleBufferSpliterator2;
            }
            return smallDoubleBufferSpliterator;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            SmallDoubleBuffer b = this.buffer;
            int hi = this.fence;
            if (b.capacity() >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(b.get(i));
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.buffer.get(this.index++));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Double> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    public static final class SmallLongBufferSpliterator
    implements Spliterator.OfLong {
        private final SmallLongBuffer buffer;
        private int index;
        private final int fence;
        private final int characteristics;

        public SmallLongBufferSpliterator(SmallLongBuffer buffer, int additionalCharacteristics) {
            this(buffer, 0, buffer.capacity(), additionalCharacteristics);
        }

        public SmallLongBufferSpliterator(SmallLongBuffer buffer, int origin, int fence, int additionalCharacteristics) {
            this.buffer = buffer;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            SmallLongBufferSpliterator smallLongBufferSpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                smallLongBufferSpliterator = null;
            } else {
                this.index = mid;
                SmallLongBufferSpliterator smallLongBufferSpliterator2 = new SmallLongBufferSpliterator(this.buffer, lo, this.index, this.characteristics);
                smallLongBufferSpliterator = smallLongBufferSpliterator2;
            }
            return smallLongBufferSpliterator;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            SmallLongBuffer b = this.buffer;
            int hi = this.fence;
            if (b.capacity() >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(b.get(i));
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.buffer.get(this.index++));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    public static final class SmallIntBufferSpliterator
    implements Spliterator.OfInt {
        private final SmallIntBuffer buffer;
        private int index;
        private final int fence;
        private final int characteristics;

        public SmallIntBufferSpliterator(SmallIntBuffer buffer, int additionalCharacteristics) {
            this(buffer, 0, buffer.capacity(), additionalCharacteristics);
        }

        public SmallIntBufferSpliterator(SmallIntBuffer buffer, int origin, int fence, int additionalCharacteristics) {
            this.buffer = buffer;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            SmallIntBufferSpliterator smallIntBufferSpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                smallIntBufferSpliterator = null;
            } else {
                this.index = mid;
                SmallIntBufferSpliterator smallIntBufferSpliterator2 = new SmallIntBufferSpliterator(this.buffer, lo, this.index, this.characteristics);
                smallIntBufferSpliterator = smallIntBufferSpliterator2;
            }
            return smallIntBufferSpliterator;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            SmallIntBuffer b = this.buffer;
            int hi = this.fence;
            if (b.capacity() >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(b.get(i));
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.buffer.get(this.index++));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    public static final class DoubleBufferSpliterator
    implements Spliterator.OfDouble {
        private final DoubleBuffer buffer;
        private int index;
        private final int fence;
        private final int characteristics;

        public DoubleBufferSpliterator(DoubleBuffer buffer, int additionalCharacteristics) {
            this(buffer, 0, buffer.capacity(), additionalCharacteristics);
        }

        public DoubleBufferSpliterator(DoubleBuffer buffer, int origin, int fence, int additionalCharacteristics) {
            this.buffer = buffer;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            DoubleBufferSpliterator doubleBufferSpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                doubleBufferSpliterator = null;
            } else {
                this.index = mid;
                DoubleBufferSpliterator doubleBufferSpliterator2 = new DoubleBufferSpliterator(this.buffer, lo, this.index, this.characteristics);
                doubleBufferSpliterator = doubleBufferSpliterator2;
            }
            return doubleBufferSpliterator;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            DoubleBuffer b = this.buffer;
            int hi = this.fence;
            if (b.capacity() >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(b.get(i));
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.buffer.get(this.index++));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Double> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    public static final class LongBufferSpliterator
    implements Spliterator.OfLong {
        private final LongBuffer buffer;
        private int index;
        private final int fence;
        private final int characteristics;

        public LongBufferSpliterator(LongBuffer buffer, int additionalCharacteristics) {
            this(buffer, 0, buffer.capacity(), additionalCharacteristics);
        }

        public LongBufferSpliterator(LongBuffer buffer, int origin, int fence, int additionalCharacteristics) {
            this.buffer = buffer;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            LongBufferSpliterator longBufferSpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                longBufferSpliterator = null;
            } else {
                this.index = mid;
                LongBufferSpliterator longBufferSpliterator2 = new LongBufferSpliterator(this.buffer, lo, this.index, this.characteristics);
                longBufferSpliterator = longBufferSpliterator2;
            }
            return longBufferSpliterator;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            LongBuffer b = this.buffer;
            int hi = this.fence;
            if (b.capacity() >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(b.get(i));
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.buffer.get(this.index++));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Long> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }

    public static final class IntBufferSpliterator
    implements Spliterator.OfInt {
        private final IntBuffer buffer;
        private int index;
        private final int fence;
        private final int characteristics;

        public IntBufferSpliterator(IntBuffer buffer, int additionalCharacteristics) {
            this(buffer, 0, buffer.capacity(), additionalCharacteristics);
        }

        public IntBufferSpliterator(IntBuffer buffer, int origin, int fence, int additionalCharacteristics) {
            this.buffer = buffer;
            this.index = origin;
            this.fence = fence;
            this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            IntBufferSpliterator intBufferSpliterator;
            int lo = this.index;
            int mid = lo + this.fence >>> 1;
            if (lo >= mid) {
                intBufferSpliterator = null;
            } else {
                this.index = mid;
                IntBufferSpliterator intBufferSpliterator2 = new IntBufferSpliterator(this.buffer, lo, this.index, this.characteristics);
                intBufferSpliterator = intBufferSpliterator2;
            }
            return intBufferSpliterator;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            int i;
            if (action == null) {
                throw new NullPointerException();
            }
            IntBuffer b = this.buffer;
            int hi = this.fence;
            if (b.capacity() >= hi && (i = this.index) >= 0 && i < (this.index = hi)) {
                do {
                    action.accept(b.get(i));
                } while (++i < hi);
            }
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.index >= 0 && this.index < this.fence) {
                action.accept(this.buffer.get(this.index++));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.characteristics;
        }

        @Override
        public Comparator<? super Integer> getComparator() {
            if (this.hasCharacteristics(4)) {
                return null;
            }
            throw new IllegalStateException();
        }
    }
}

