/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import tech.bitey.bufferstuff.BigByteBuffer;
import tech.bitey.bufferstuff.BufferSpliterators;
import tech.bitey.bufferstuff.CompoundBigByteBuffer;
import tech.bitey.bufferstuff.SimpleBigByteBuffer;
import tech.bitey.bufferstuff.SmallByteBuffer;
import tech.bitey.bufferstuff.SmallDoubleBuffer;
import tech.bitey.bufferstuff.SmallFloatBuffer;
import tech.bitey.bufferstuff.SmallIntBuffer;
import tech.bitey.bufferstuff.SmallLongBuffer;
import tech.bitey.bufferstuff.SmallShortBuffer;

public final class BufferUtils
extends Enum<BufferUtils> {
    private static final boolean DIRECT;
    public static final ByteBuffer EMPTY_BUFFER;
    public static final BigByteBuffer EMPTY_BIG_BUFFER;
    private static final /* synthetic */ BufferUtils[] $VALUES;

    public static BufferUtils[] values() {
        return (BufferUtils[])$VALUES.clone();
    }

    public static BufferUtils valueOf(String name) {
        return Enum.valueOf(BufferUtils.class, name);
    }

    public static ByteBuffer allocate(int capacity) {
        return BufferUtils.allocate(capacity, ByteOrder.nativeOrder());
    }

    public static ByteBuffer allocate(int capacity, ByteOrder order) {
        return (DIRECT ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity)).order(order);
    }

    public static BigByteBuffer allocateBig(long capacity) {
        return BufferUtils.allocateBig(capacity, ByteOrder.nativeOrder());
    }

    public static BigByteBuffer allocateBig(long capacity, ByteOrder order) {
        if (capacity <= 0x40000000L) {
            return new SimpleBigByteBuffer(BufferUtils.allocate(Math.toIntExact(capacity), order));
        }
        int chunks = (int)(capacity >> 30);
        int remainder = (int)(capacity & 0x3FFFFFFFL);
        ByteBuffer[] buffers = new ByteBuffer[chunks + (remainder > 0 ? 1 : 0)];
        for (int i = 0; i < chunks; ++i) {
            buffers[i] = BufferUtils.allocate(0x40000000, order);
        }
        if (remainder > 0) {
            buffers[i] = BufferUtils.allocate(remainder, order);
        }
        return new CompoundBigByteBuffer(buffers);
    }

    public static BigByteBuffer wrap(ByteBuffer[] buffers) {
        if (buffers.length == 1) {
            return new SimpleBigByteBuffer(buffers[0]);
        }
        return new CompoundBigByteBuffer(buffers);
    }

    public static ByteBuffer duplicate(ByteBuffer b) {
        return b.duplicate().order(b.order());
    }

    public static ByteBuffer slice(ByteBuffer b) {
        return b.slice().order(b.order());
    }

    public static ByteBuffer asReadOnlyBuffer(ByteBuffer b) {
        return b.asReadOnlyBuffer().order(b.order());
    }

    public static ByteBuffer slice(ByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        return b.slice(fromIndex, toIndex - fromIndex).order(b.order());
    }

    public static boolean isSorted(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        int prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        int prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        long prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        long prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(ByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        byte prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            byte value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(ByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        byte prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            byte value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(ShortBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        short prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            short value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(ShortBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        short prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            short value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        float prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float value = b.get(i);
            if (Float.compare(prev, value) > 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        float prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float value = b.get(i);
            if (Float.compare(prev, value) >= 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        double prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double value = b.get(i);
            if (Double.compare(prev, value) > 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        double prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double value = b.get(i);
            if (Double.compare(prev, value) >= 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static ByteBuffer copy(ByteBuffer b, int fromIndex, int toIndex) {
        ByteBuffer slice = BufferUtils.slice(b, fromIndex, toIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(slice.capacity()) : ByteBuffer.allocate(slice.capacity());
        copy.order(b.order());
        copy.put(slice);
        copy.flip();
        return copy;
    }

    public static IntBuffer copy(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        IntBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 4) : ByteBuffer.allocate(dup.remaining() * 4);
        copy.order(b.order());
        IntBuffer view = copy.asIntBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    public static LongBuffer copy(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        LongBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 8) : ByteBuffer.allocate(dup.remaining() * 8);
        copy.order(b.order());
        LongBuffer view = copy.asLongBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    public static ShortBuffer copy(ShortBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        ShortBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 2) : ByteBuffer.allocate(dup.remaining() * 2);
        copy.order(b.order());
        ShortBuffer view = copy.asShortBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    public static FloatBuffer copy(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        FloatBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 4) : ByteBuffer.allocate(dup.remaining() * 4);
        copy.order(b.order());
        FloatBuffer view = copy.asFloatBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    public static DoubleBuffer copy(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        DoubleBuffer dup = b.duplicate();
        dup.limit(toIndex);
        dup.position(fromIndex);
        ByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * 8) : ByteBuffer.allocate(dup.remaining() * 8);
        copy.order(b.order());
        DoubleBuffer view = copy.asDoubleBuffer();
        view.put(dup);
        view.flip();
        return view;
    }

    public static int deduplicate(IntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        int prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int value = b.get(i);
            if (value == prev) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(LongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        long prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long value = b.get(i);
            if (value == prev) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(ShortBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        short prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            short value = b.get(i);
            if (value == prev) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(ByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        byte prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            byte value = b.get(i);
            if (value == prev) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(FloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        float prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float value = b.get(i);
            if (Float.compare(value, prev) == 0) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(DoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        double prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double value = b.get(i);
            if (Double.compare(value, prev) == 0) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static IntStream stream(IntBuffer buffer) {
        return BufferUtils.stream(buffer, 0, buffer.capacity(), 0);
    }

    public static IntStream stream(IntBuffer buffer, int startInclusive, int endExclusive, int characteristics) {
        return StreamSupport.intStream(new BufferSpliterators.IntBufferSpliterator(buffer, startInclusive, endExclusive, characteristics | 0x10 | 0x100 | 0x400), false);
    }

    public static LongStream stream(LongBuffer buffer) {
        return BufferUtils.stream(buffer, 0, buffer.capacity(), 0);
    }

    public static LongStream stream(LongBuffer buffer, int startInclusive, int endExclusive, int characteristics) {
        return StreamSupport.longStream(new BufferSpliterators.LongBufferSpliterator(buffer, startInclusive, endExclusive, characteristics | 0x10 | 0x100 | 0x400), false);
    }

    public static DoubleStream stream(DoubleBuffer buffer) {
        return BufferUtils.stream(buffer, 0, buffer.capacity(), 0);
    }

    public static DoubleStream stream(DoubleBuffer buffer, int startInclusive, int endExclusive, int characteristics) {
        return StreamSupport.doubleStream(new BufferSpliterators.DoubleBufferSpliterator(buffer, startInclusive, endExclusive, characteristics | 0x10 | 0x100 | 0x400), false);
    }

    public static boolean isSorted(SmallIntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        int prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(SmallIntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        int prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(SmallLongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        long prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(SmallLongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        long prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(SmallByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        byte prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            byte value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(SmallByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        byte prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            byte value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(SmallShortBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        short prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            short value = b.get(i);
            if (prev > value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(SmallShortBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        short prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            short value = b.get(i);
            if (prev >= value) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(SmallFloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        float prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float value = b.get(i);
            if (Float.compare(prev, value) > 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(SmallFloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        float prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float value = b.get(i);
            if (Float.compare(prev, value) >= 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSorted(SmallDoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        double prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double value = b.get(i);
            if (Double.compare(prev, value) > 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static boolean isSortedAndDistinct(SmallDoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex <= 1) {
            return true;
        }
        double prev = b.get(fromIndex);
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double value = b.get(i);
            if (Double.compare(prev, value) >= 0) {
                return false;
            }
            prev = value;
        }
        return true;
    }

    public static int deduplicate(SmallIntBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        int prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            int value = b.get(i);
            if (value == prev) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(SmallLongBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        long prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            long value = b.get(i);
            if (value == prev) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(SmallShortBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        short prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            short value = b.get(i);
            if (value == prev) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(SmallByteBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        byte prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            byte value = b.get(i);
            if (value == prev) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(SmallFloatBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        float prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            float value = b.get(i);
            if (Float.compare(value, prev) == 0) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static int deduplicate(SmallDoubleBuffer b, int fromIndex, int toIndex) {
        BufferUtils.rangeCheck(b.capacity(), fromIndex, toIndex);
        if (toIndex - fromIndex < 2) {
            return toIndex;
        }
        double prev = b.get(fromIndex);
        int highest = fromIndex + 1;
        for (int i = fromIndex + 1; i < toIndex; ++i) {
            double value = b.get(i);
            if (Double.compare(value, prev) == 0) continue;
            if (highest < i) {
                b.put(highest, value);
            }
            ++highest;
            prev = value;
        }
        return highest;
    }

    public static IntStream stream(SmallIntBuffer buffer) {
        return BufferUtils.stream(buffer, 0, buffer.capacity(), 0);
    }

    public static IntStream stream(SmallIntBuffer buffer, int startInclusive, int endExclusive, int characteristics) {
        return StreamSupport.intStream(new BufferSpliterators.SmallIntBufferSpliterator(buffer, startInclusive, endExclusive, characteristics | 0x10 | 0x100 | 0x400), false);
    }

    public static LongStream stream(SmallLongBuffer buffer) {
        return BufferUtils.stream(buffer, 0, buffer.capacity(), 0);
    }

    public static LongStream stream(SmallLongBuffer buffer, int startInclusive, int endExclusive, int characteristics) {
        return StreamSupport.longStream(new BufferSpliterators.SmallLongBufferSpliterator(buffer, startInclusive, endExclusive, characteristics | 0x10 | 0x100 | 0x400), false);
    }

    public static DoubleStream stream(SmallDoubleBuffer buffer) {
        return BufferUtils.stream(buffer, 0, buffer.capacity(), 0);
    }

    public static DoubleStream stream(SmallDoubleBuffer buffer, int startInclusive, int endExclusive, int characteristics) {
        return StreamSupport.doubleStream(new BufferSpliterators.SmallDoubleBufferSpliterator(buffer, startInclusive, endExclusive, characteristics | 0x10 | 0x100 | 0x400), false);
    }

    static void rangeCheck(int bufferCapacity, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex(" + fromIndex + ") < 0");
        }
        if (toIndex > bufferCapacity) {
            throw new IndexOutOfBoundsException("toIndex(" + toIndex + ") > " + bufferCapacity);
        }
    }

    static void rangeCheckInclusive(int bufferCapacity, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex(" + fromIndex + ") < 0");
        }
        if (toIndex >= bufferCapacity) {
            throw new IndexOutOfBoundsException("toIndex(" + toIndex + ") >= " + bufferCapacity);
        }
    }

    public static void writeFully(WritableByteChannel channel, ByteBuffer buffer) throws IOException {
        while (buffer.remaining() > 0) {
            channel.write(buffer);
        }
    }

    public static void readFully(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        while (buffer.remaining() > 0) {
            channel.read(buffer);
        }
    }

    private static /* synthetic */ BufferUtils[] $values() {
        return new BufferUtils[0];
    }

    static {
        $VALUES = BufferUtils.$values();
        DIRECT = "true".equalsIgnoreCase(System.getProperty("tech.bitey.allocateDirect"));
        EMPTY_BUFFER = BufferUtils.asReadOnlyBuffer(BufferUtils.allocate(0));
        EMPTY_BIG_BUFFER = new SimpleBigByteBuffer(EMPTY_BUFFER);
    }
}

