/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Objects;
import tech.bitey.bufferstuff.AbstractBigByteBuffer;
import tech.bitey.bufferstuff.BigByteBuffer;
import tech.bitey.bufferstuff.BufferUtils;
import tech.bitey.bufferstuff.SimpleBigByteBuffer;

final class CompoundBigByteBuffer
extends AbstractBigByteBuffer {
    static final int CHUNK_BITS = 30;
    static final int CHUNK_SIZE = 0x40000000;
    static final int CHUNK_MASK = 0x3FFFFFFF;
    private final ByteBuffer[] buffers;
    private long position;
    private long limit;
    private final long capacity;
    private final int capacity0;

    private CompoundBigByteBuffer(ByteBuffer[] buffers, long position, long limit, long capacity) {
        if (position < 0L) {
            throw new IllegalArgumentException("positition cannot be negative");
        }
        if (position > limit) {
            throw new IllegalArgumentException("positition cannot be greater than limit");
        }
        if (limit > capacity) {
            throw new IllegalArgumentException("limit cannot be greater than capacity");
        }
        this.buffers = buffers;
        this.position = position;
        this.limit = limit;
        this.capacity = capacity;
        this.capacity0 = buffers[0].capacity();
    }

    CompoundBigByteBuffer(ByteBuffer[] buffers) {
        long capacity = 0L;
        for (int i = 0; i < buffers.length; ++i) {
            ByteBuffer b = buffers[i];
            if (b.position() != 0) {
                throw new IllegalArgumentException("position must be 0");
            }
            if (b.limit() != b.capacity()) {
                throw new IllegalArgumentException("limit must equal capacity");
            }
            if (i != 0 && i < buffers.length - 1 && b.capacity() != 0x40000000) {
                throw new IllegalArgumentException("internal chunks must have max size");
            }
            capacity += (long)b.capacity();
        }
        this.buffers = buffers;
        this.position = 0L;
        this.limit = capacity;
        this.capacity = capacity;
        this.capacity0 = buffers[0].capacity();
    }

    @Override
    public ByteBuffer[] buffers() {
        return this.buffers;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public BigByteBuffer position(long newPosition) {
        if (newPosition > this.limit || newPosition < 0L) {
            throw this.createPositionException(newPosition);
        }
        this.position = newPosition;
        return this;
    }

    private IllegalArgumentException createPositionException(long newPosition) {
        String msg = null;
        msg = newPosition > this.limit ? "newPosition > limit: (" + newPosition + " > " + this.limit + ")" : "newPosition < 0: (" + newPosition + " < 0)";
        return new IllegalArgumentException(msg);
    }

    @Override
    public BigByteBuffer limit(long newLimit) {
        if (newLimit > this.capacity || newLimit < 0L) {
            throw this.createLimitException(newLimit);
        }
        this.limit = newLimit;
        if (this.position > newLimit) {
            this.position = newLimit;
        }
        return this;
    }

    private IllegalArgumentException createLimitException(long newLimit) {
        String msg = null;
        msg = newLimit > this.capacity ? "newLimit > capacity: (" + newLimit + " > " + this.capacity + ")" : "newLimit < 0: (" + newLimit + " < 0)";
        return new IllegalArgumentException(msg);
    }

    @Override
    public long remaining() {
        return this.limit - this.position;
    }

    @Override
    public boolean hasRemaining() {
        return this.position < this.limit;
    }

    @Override
    public ByteOrder order() {
        return this.buffers[0].order();
    }

    @Override
    public BigByteBuffer order(ByteOrder order) {
        for (ByteBuffer b : this.buffers) {
            b.order(order);
        }
        return this;
    }

    @Override
    public BigByteBuffer duplicate() {
        return new CompoundBigByteBuffer(this.buffers, this.position, this.limit, this.capacity);
    }

    @Override
    public BigByteBuffer slice() {
        return this.slice(this.position, this.limit);
    }

    private void checkRange(long fromIndex, long toIndex) {
        if (fromIndex < 0L) {
            throw new IllegalArgumentException("fromIndex cannot be negative");
        }
        if (toIndex > this.limit) {
            throw new IllegalArgumentException("toIndex cannot be greater than limit");
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex cannot be greater than toIndex");
        }
    }

    @Override
    public BigByteBuffer slice(long fromIndex, long toIndex) {
        ByteBuffer[] buffers;
        this.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return BufferUtils.EMPTY_BIG_BUFFER;
        }
        int fromBuf = this.buf(fromIndex);
        int fromByt = this.byt(fromIndex);
        int toBuf = this.buf(toIndex);
        int toByt = this.byt(toIndex);
        if (toByt == 0) {
            toByt = this.buffers[--toBuf].capacity();
        }
        if (fromBuf == toBuf) {
            buffers = new ByteBuffer[]{BufferUtils.slice(this.buffers[fromBuf], fromByt, toByt)};
        } else {
            buffers = new ByteBuffer[toBuf - fromBuf + 1];
            buffers[0] = BufferUtils.slice(this.buffers[fromBuf], fromByt, this.buffers[fromBuf].capacity());
            for (int i = 1; i < buffers.length - 1; ++i) {
                buffers[i] = BufferUtils.duplicate(this.buffers[fromBuf + i]);
            }
            buffers[buffers.length - 1] = BufferUtils.slice(this.buffers[toBuf], 0, toByt);
        }
        return BufferUtils.wrap(buffers);
    }

    @Override
    public ByteBuffer smallSlice() {
        return this.smallSlice(this.position, this.limit);
    }

    @Override
    public ByteBuffer smallSlice(long fromIndex, long toIndex) {
        this.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return BufferUtils.EMPTY_BUFFER;
        }
        int fromBuf = this.buf(fromIndex);
        int fromByt = this.byt(fromIndex);
        int toBuf = this.buf(toIndex);
        int toByt = this.byt(toIndex);
        if (toByt == 0) {
            toByt = this.buffers[--toBuf].capacity();
        }
        if (fromBuf == toBuf) {
            return BufferUtils.slice(this.buffers[fromBuf], fromByt, toByt);
        }
        ByteBuffer result = BufferUtils.allocate(Math.toIntExact(toIndex - fromIndex), this.order());
        result.put(BufferUtils.slice(this.buffers[fromBuf], fromByt, this.buffers[fromBuf].capacity()));
        for (int i = fromBuf + 1; i < toBuf; ++i) {
            result.put(BufferUtils.duplicate(this.buffers[i]));
        }
        result.put(BufferUtils.slice(this.buffers[toBuf], 0, toByt));
        return result.flip();
    }

    @Override
    public BigByteBuffer copy(long fromIndex, long toIndex) {
        ByteBuffer[] buffers;
        this.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return BufferUtils.EMPTY_BIG_BUFFER;
        }
        int fromBuf = this.buf(fromIndex);
        int fromByt = this.byt(fromIndex);
        int toBuf = this.buf(toIndex);
        int toByt = this.byt(toIndex);
        if (toByt == 0) {
            toByt = this.buffers[--toBuf].capacity();
        }
        if (fromBuf == toBuf) {
            buffers = new ByteBuffer[]{BufferUtils.copy(this.buffers[fromBuf], fromByt, toByt)};
        } else {
            buffers = new ByteBuffer[toBuf - fromBuf + 1];
            buffers[0] = BufferUtils.copy(this.buffers[fromBuf], fromByt, this.buffers[fromBuf].capacity());
            for (int i = 1; i < buffers.length - 1; ++i) {
                buffers[i] = BufferUtils.copy(this.buffers[fromBuf + i], 0, this.buffers[fromBuf + i].capacity());
            }
            buffers[buffers.length - 1] = BufferUtils.copy(this.buffers[toBuf], 0, toByt);
        }
        return BufferUtils.wrap(buffers);
    }

    @Override
    public BigByteBuffer clear() {
        this.position = 0L;
        this.limit = this.capacity;
        return this;
    }

    @Override
    public BigByteBuffer flip() {
        this.limit = this.position;
        this.position = 0L;
        return this;
    }

    private int buf(long index) {
        if (index < (long)this.capacity0) {
            return 0;
        }
        return (int)((index -= (long)this.capacity0) >> 30) + 1;
    }

    private int byt(long index) {
        if (index < (long)this.capacity0) {
            return (int)index;
        }
        return (int)((index -= (long)this.capacity0) & 0x3FFFFFFFL);
    }

    private int rem(int buf, int byt) {
        return this.buffers[buf].capacity() - byt;
    }

    private int rem(long index) {
        return this.rem(this.buf(index), this.byt(index));
    }

    private long nextPutIndex() {
        long p = this.position;
        if (p >= this.limit) {
            throw new BufferOverflowException();
        }
        this.position = p + 1L;
        return p;
    }

    private long nextPutIndex(int nb) {
        long p = this.position;
        if (this.limit - p < (long)nb) {
            throw new BufferOverflowException();
        }
        this.position = p + (long)nb;
        return p;
    }

    private long nextGetIndex() {
        long p = this.position;
        if (p >= this.limit) {
            throw new BufferUnderflowException();
        }
        this.position = p + 1L;
        return p;
    }

    private long nextGetIndex(int nb) {
        long p = this.position;
        if (this.limit - p < (long)nb) {
            throw new BufferUnderflowException();
        }
        this.position = p + (long)nb;
        return p;
    }

    @Override
    public BigByteBuffer put(byte value) {
        return this.put(this.nextPutIndex(), value);
    }

    @Override
    public BigByteBuffer put(long index, byte value) {
        this.buffers[this.buf(index)].put(this.byt(index), value);
        return this;
    }

    @Override
    public BigByteBuffer put(BigByteBuffer src) {
        if (src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (ByteBuffer b : src.slice().buffers()) {
            this.position += (long)this.put0(this.position, b);
        }
        return this;
    }

    @Override
    public BigByteBuffer put(ByteBuffer src) {
        if ((long)src.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        this.position += (long)this.put0(this.position, src);
        return this;
    }

    private int put0(long index, ByteBuffer src) {
        int total = src.remaining();
        int copied = 0;
        while (copied < total) {
            int buf = this.buf(index);
            int byt = this.byt(index);
            int length = Math.min(total - copied, this.rem(buf, byt));
            this.buffers[buf].put(byt, src, copied, length);
            copied += length;
            index += (long)length;
        }
        src.position(src.limit());
        return copied;
    }

    @Override
    public BigByteBuffer put(byte[] src) {
        return this.put(ByteBuffer.wrap(src));
    }

    @Override
    public byte get() {
        return this.get(this.nextGetIndex());
    }

    @Override
    public byte get(long index) {
        return this.buffers[this.buf(index)].get(this.byt(index));
    }

    public boolean equals(Object o) {
        if (o instanceof SimpleBigByteBuffer) {
            SimpleBigByteBuffer rhs = (SimpleBigByteBuffer)o;
            return rhs.equals(this);
        }
        if (o instanceof CompoundBigByteBuffer) {
            int rem;
            CompoundBigByteBuffer rhs = (CompoundBigByteBuffer)o;
            long total = this.remaining();
            if (total != rhs.remaining()) {
                return false;
            }
            for (long progress = 0L; progress < total; progress += (long)rem) {
                long lstart = this.position + progress;
                long rstart = rhs.position + progress;
                rem = Math.min(this.rem(lstart), rhs.rem(rstart));
                if (this.smallSlice(lstart, lstart + (long)rem).equals(rhs.smallSlice(rstart, rstart + (long)rem))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public BigByteBuffer putShort(short value) {
        return this.putShort0(this.nextPutIndex(2), value);
    }

    @Override
    public BigByteBuffer putShort(long index, short value) {
        if (index > this.capacity - 2L) {
            throw new BufferOverflowException();
        }
        return this.putShort0(index, value);
    }

    private BigByteBuffer putShort0(long index, short value) {
        int byt;
        int buf = this.buf(index);
        if (this.rem(buf, byt = this.byt(index)) >= 2) {
            this.buffers[buf].putShort(byt, value);
        } else {
            ByteBuffer b = BufferUtils.allocate(2, this.order());
            b.asShortBuffer().put(0, value);
            this.put0(index, b);
        }
        return this;
    }

    @Override
    public BigByteBuffer putShort(short[] src) {
        return this.putShort(ShortBuffer.wrap(src));
    }

    @Override
    public BigByteBuffer putShort(ShortBuffer src) {
        if ((long)src.remaining() * 2L > this.remaining()) {
            throw new BufferOverflowException();
        }
        while (src.hasRemaining()) {
            this.putShort(src.get());
        }
        return this;
    }

    @Override
    public short getShort() {
        return this.getShort0(this.nextGetIndex(2));
    }

    @Override
    public short getShort(long index) {
        if (index > this.capacity - 2L) {
            throw new BufferUnderflowException();
        }
        return this.getShort0(index);
    }

    private short getShort0(long index) {
        int byt;
        int buf = this.buf(index);
        if (this.rem(buf, byt = this.byt(index)) >= 2) {
            return this.buffers[buf].getShort(byt);
        }
        ByteBuffer b = BufferUtils.allocate(2, this.order());
        b.put(BufferUtils.slice(this.buffers[buf], byt, this.buffers[buf].capacity()));
        b.put(BufferUtils.slice(this.buffers[buf + 1], 0, b.remaining()));
        return b.getShort(0);
    }

    @Override
    public BigByteBuffer putInt(int value) {
        return this.putInt0(this.nextPutIndex(4), value);
    }

    @Override
    public BigByteBuffer putInt(long index, int value) {
        if (index > this.capacity - 4L) {
            throw new BufferOverflowException();
        }
        return this.putInt0(index, value);
    }

    private BigByteBuffer putInt0(long index, int value) {
        int byt;
        int buf = this.buf(index);
        if (this.rem(buf, byt = this.byt(index)) >= 4) {
            this.buffers[buf].putInt(byt, value);
        } else {
            ByteBuffer b = BufferUtils.allocate(4, this.order());
            b.asIntBuffer().put(0, value);
            this.put0(index, b);
        }
        return this;
    }

    @Override
    public BigByteBuffer putInt(int[] src) {
        return this.putInt(IntBuffer.wrap(src));
    }

    @Override
    public BigByteBuffer putInt(IntBuffer src) {
        if ((long)src.remaining() * 4L > this.remaining()) {
            throw new BufferOverflowException();
        }
        while (src.hasRemaining()) {
            this.putInt(src.get());
        }
        return this;
    }

    @Override
    public int getInt() {
        return this.getInt0(this.nextGetIndex(4));
    }

    @Override
    public int getInt(long index) {
        if (index > this.capacity - 4L) {
            throw new BufferUnderflowException();
        }
        return this.getInt0(index);
    }

    private int getInt0(long index) {
        int byt;
        int buf = this.buf(index);
        if (this.rem(buf, byt = this.byt(index)) >= 4) {
            return this.buffers[buf].getInt(byt);
        }
        ByteBuffer b = BufferUtils.allocate(4, this.order());
        b.put(BufferUtils.slice(this.buffers[buf], byt, this.buffers[buf].capacity()));
        b.put(BufferUtils.slice(this.buffers[buf + 1], 0, b.remaining()));
        return b.getInt(0);
    }

    @Override
    public BigByteBuffer putLong(long value) {
        return this.putLong0(this.nextPutIndex(8), value);
    }

    @Override
    public BigByteBuffer putLong(long index, long value) {
        if (index > this.capacity - 8L) {
            throw new BufferOverflowException();
        }
        return this.putLong0(index, value);
    }

    private BigByteBuffer putLong0(long index, long value) {
        int byt;
        int buf = this.buf(index);
        if (this.rem(buf, byt = this.byt(index)) >= 8) {
            this.buffers[buf].putLong(byt, value);
        } else {
            ByteBuffer b = BufferUtils.allocate(8, this.order());
            b.asLongBuffer().put(0, value);
            this.put0(index, b);
        }
        return this;
    }

    @Override
    public BigByteBuffer putLong(long[] src) {
        return this.putLong(LongBuffer.wrap(src));
    }

    @Override
    public BigByteBuffer putLong(LongBuffer src) {
        if ((long)src.remaining() * 8L > this.remaining()) {
            throw new BufferOverflowException();
        }
        while (src.hasRemaining()) {
            this.putLong(src.get());
        }
        return this;
    }

    @Override
    public long getLong() {
        return this.getLong0(this.nextGetIndex(8));
    }

    @Override
    public long getLong(long index) {
        if (index > this.capacity - 8L) {
            throw new BufferUnderflowException();
        }
        return this.getLong0(index);
    }

    private long getLong0(long index) {
        int byt;
        int buf = this.buf(index);
        if (this.rem(buf, byt = this.byt(index)) >= 8) {
            return this.buffers[buf].getLong(byt);
        }
        ByteBuffer b = BufferUtils.allocate(8, this.order());
        b.put(BufferUtils.slice(this.buffers[buf], byt, this.buffers[buf].capacity()));
        b.put(BufferUtils.slice(this.buffers[buf + 1], 0, b.remaining()));
        return b.getLong(0);
    }

    @Override
    public BigByteBuffer putFloat(float value) {
        return this.putFloat0(this.nextPutIndex(4), value);
    }

    @Override
    public BigByteBuffer putFloat(long index, float value) {
        if (index > this.capacity - 4L) {
            throw new BufferOverflowException();
        }
        return this.putFloat0(index, value);
    }

    private BigByteBuffer putFloat0(long index, float value) {
        int byt;
        int buf = this.buf(index);
        if (this.rem(buf, byt = this.byt(index)) >= 4) {
            this.buffers[buf].putFloat(byt, value);
        } else {
            ByteBuffer b = BufferUtils.allocate(4, this.order());
            b.asFloatBuffer().put(0, value);
            this.put0(index, b);
        }
        return this;
    }

    @Override
    public BigByteBuffer putFloat(float[] src) {
        return this.putFloat(FloatBuffer.wrap(src));
    }

    @Override
    public BigByteBuffer putFloat(FloatBuffer src) {
        if ((long)src.remaining() * 4L > this.remaining()) {
            throw new BufferOverflowException();
        }
        while (src.hasRemaining()) {
            this.putFloat(src.get());
        }
        return this;
    }

    @Override
    public float getFloat() {
        return this.getFloat0(this.nextGetIndex(4));
    }

    @Override
    public float getFloat(long index) {
        if (index > this.capacity - 4L) {
            throw new BufferUnderflowException();
        }
        return this.getFloat0(index);
    }

    private float getFloat0(long index) {
        int byt;
        int buf = this.buf(index);
        if (this.rem(buf, byt = this.byt(index)) >= 4) {
            return this.buffers[buf].getFloat(byt);
        }
        ByteBuffer b = BufferUtils.allocate(4, this.order());
        b.put(BufferUtils.slice(this.buffers[buf], byt, this.buffers[buf].capacity()));
        b.put(BufferUtils.slice(this.buffers[buf + 1], 0, b.remaining()));
        return b.getFloat(0);
    }

    @Override
    public BigByteBuffer putDouble(double value) {
        return this.putDouble0(this.nextPutIndex(8), value);
    }

    @Override
    public BigByteBuffer putDouble(long index, double value) {
        if (index > this.capacity - 8L) {
            throw new BufferOverflowException();
        }
        return this.putDouble0(index, value);
    }

    private BigByteBuffer putDouble0(long index, double value) {
        int byt;
        int buf = this.buf(index);
        if (this.rem(buf, byt = this.byt(index)) >= 8) {
            this.buffers[buf].putDouble(byt, value);
        } else {
            ByteBuffer b = BufferUtils.allocate(8, this.order());
            b.asDoubleBuffer().put(0, value);
            this.put0(index, b);
        }
        return this;
    }

    @Override
    public BigByteBuffer putDouble(double[] src) {
        return this.putDouble(DoubleBuffer.wrap(src));
    }

    @Override
    public BigByteBuffer putDouble(DoubleBuffer src) {
        if ((long)src.remaining() * 8L > this.remaining()) {
            throw new BufferOverflowException();
        }
        while (src.hasRemaining()) {
            this.putDouble(src.get());
        }
        return this;
    }

    @Override
    public double getDouble() {
        return this.getDouble0(this.nextGetIndex(8));
    }

    @Override
    public double getDouble(long index) {
        if (index > this.capacity - 8L) {
            throw new BufferUnderflowException();
        }
        return this.getDouble0(index);
    }

    private double getDouble0(long index) {
        int byt;
        int buf = this.buf(index);
        if (this.rem(buf, byt = this.byt(index)) >= 8) {
            return this.buffers[buf].getDouble(byt);
        }
        ByteBuffer b = BufferUtils.allocate(8, this.order());
        b.put(BufferUtils.slice(this.buffers[buf], byt, this.buffers[buf].capacity()));
        b.put(BufferUtils.slice(this.buffers[buf + 1], 0, b.remaining()));
        return b.getDouble(0);
    }

    @Override
    public InputStream toInputStream() {
        return new InputStream(){
            final BigByteBuffer buf;
            {
                this.buf = CompoundBigByteBuffer.this.slice();
            }

            @Override
            public int available() throws IOException {
                return this.buf.remaining() <= Integer.MAX_VALUE ? (int)this.buf.remaining() : Integer.MAX_VALUE;
            }

            @Override
            public int read() throws IOException {
                return this.buf.hasRemaining() ? this.buf.get() & 0xFF : -1;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                len = (int)Math.min((long)len, this.buf.remaining());
                this.buf.get(bytes, off, len);
                return len;
            }

            public String toString() {
                return CompoundBigByteBuffer.this.toString();
            }
        };
    }

    @Override
    public BigByteBuffer get(byte[] dst, int offset, int length) {
        Objects.checkFromIndexSize(offset, length, dst.length);
        if ((long)length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        while (length > 0) {
            ByteBuffer buf = this.buffers[this.buf(this.position)];
            int byt = this.byt(this.position);
            int read = Math.min(buf.capacity() - byt, length);
            buf.get(byt, dst, offset, read);
            offset += read;
            this.position += (long)read;
            length -= read;
        }
        return this;
    }
}

