/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.ByteOrder;
import tech.bitey.bufferstuff.BigByteBuffer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class SmallBuffer {
    final BigByteBuffer buffer;

    SmallBuffer(BigByteBuffer buffer) {
        this.buffer = buffer;
    }

    abstract int shift();

    public BigByteBuffer unwrap() {
        return this.buffer;
    }

    public int position() {
        return (int)(this.buffer.position() >> this.shift());
    }

    public int limit() {
        return (int)(this.buffer.limit() >> this.shift());
    }

    public int capacity() {
        return (int)(this.buffer.capacity() >> this.shift());
    }

    public SmallBuffer position(int newPosition) {
        this.buffer.position((long)newPosition << this.shift());
        return this;
    }

    public SmallBuffer limit(int newLimit) {
        this.buffer.limit((long)newLimit << this.shift());
        return this;
    }

    public int remaining() {
        return (int)(this.buffer.remaining() >> this.shift());
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public abstract SmallBuffer duplicate();

    public abstract SmallBuffer slice();

    public SmallBuffer clear() {
        this.buffer.clear();
        return this;
    }

    public SmallBuffer flip() {
        this.buffer.flip();
        return this;
    }
}

