/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.ByteBuffer;
import tech.bitey.bufferstuff.BigByteBuffer;
import tech.bitey.bufferstuff.SmallBuffer;

public final class SmallByteBuffer
extends SmallBuffer {
    private static final int SHIFT = 0;

    SmallByteBuffer(BigByteBuffer buffer) {
        super(buffer);
    }

    public SmallByteBuffer put(byte value) {
        this.buffer.put(value);
        return this;
    }

    public SmallByteBuffer put(int index, byte value) {
        this.buffer.put((long)index << 0, value);
        return this;
    }

    public final SmallByteBuffer put(byte[] src) {
        this.buffer.put(src);
        return this;
    }

    public SmallByteBuffer put(ByteBuffer src) {
        this.buffer.put(src);
        return this;
    }

    public SmallByteBuffer put(SmallByteBuffer src) {
        this.buffer.put(src.buffer);
        return this;
    }

    public byte get() {
        return this.buffer.get();
    }

    public byte get(int index) {
        return this.buffer.get((long)index << 0);
    }

    @Override
    int shift() {
        return 0;
    }

    @Override
    public SmallByteBuffer duplicate() {
        return new SmallByteBuffer(this.buffer.duplicate());
    }

    @Override
    public SmallByteBuffer slice() {
        return new SmallByteBuffer(this.buffer.slice());
    }

    public String toString() {
        return "[pos=%d lim=%d cap=%d]".formatted(this.buffer.position(), this.buffer.limit(), this.buffer.capacity());
    }
}

