/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.DoubleBuffer;
import tech.bitey.bufferstuff.BigByteBuffer;
import tech.bitey.bufferstuff.SmallBuffer;

public final class SmallDoubleBuffer
extends SmallBuffer {
    private static final int SHIFT = 3;

    SmallDoubleBuffer(BigByteBuffer buffer) {
        super(buffer);
    }

    public SmallDoubleBuffer put(double value) {
        this.buffer.putDouble(value);
        return this;
    }

    public SmallDoubleBuffer put(int index, double value) {
        this.buffer.putDouble((long)index << 3, value);
        return this;
    }

    public final SmallDoubleBuffer put(double[] src) {
        this.buffer.putDouble(src);
        return this;
    }

    public SmallDoubleBuffer put(DoubleBuffer src) {
        this.buffer.putDouble(src);
        return this;
    }

    public SmallDoubleBuffer put(SmallDoubleBuffer src) {
        this.buffer.put(src.buffer);
        return this;
    }

    public double get() {
        return this.buffer.getDouble();
    }

    public double get(int index) {
        return this.buffer.getDouble((long)index << 3);
    }

    @Override
    int shift() {
        return 3;
    }

    @Override
    public SmallDoubleBuffer duplicate() {
        return new SmallDoubleBuffer(this.buffer.duplicate());
    }

    @Override
    public SmallDoubleBuffer slice() {
        return new SmallDoubleBuffer(this.buffer.slice());
    }

    public String toString() {
        return "[pos=%d lim=%d cap=%d]".formatted(this.buffer.position(), this.buffer.limit(), this.buffer.capacity());
    }
}

