/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.FloatBuffer;
import tech.bitey.bufferstuff.BigByteBuffer;
import tech.bitey.bufferstuff.SmallBuffer;

public final class SmallFloatBuffer
extends SmallBuffer {
    private static final int SHIFT = 2;

    SmallFloatBuffer(BigByteBuffer buffer) {
        super(buffer);
    }

    public SmallFloatBuffer put(float value) {
        this.buffer.putFloat(value);
        return this;
    }

    public SmallFloatBuffer put(int index, float value) {
        this.buffer.putFloat((long)index << 2, value);
        return this;
    }

    public final SmallFloatBuffer put(float[] src) {
        this.buffer.putFloat(src);
        return this;
    }

    public SmallFloatBuffer put(FloatBuffer src) {
        this.buffer.putFloat(src);
        return this;
    }

    public SmallFloatBuffer put(SmallFloatBuffer src) {
        this.buffer.put(src.buffer);
        return this;
    }

    public float get() {
        return this.buffer.getFloat();
    }

    public float get(int index) {
        return this.buffer.getFloat((long)index << 2);
    }

    @Override
    int shift() {
        return 2;
    }

    @Override
    public SmallFloatBuffer duplicate() {
        return new SmallFloatBuffer(this.buffer.duplicate());
    }

    @Override
    public SmallFloatBuffer slice() {
        return new SmallFloatBuffer(this.buffer.slice());
    }

    public String toString() {
        return "[pos=%d lim=%d cap=%d]".formatted(this.buffer.position(), this.buffer.limit(), this.buffer.capacity());
    }
}

