/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.IntBuffer;
import tech.bitey.bufferstuff.BigByteBuffer;
import tech.bitey.bufferstuff.SmallBuffer;

public final class SmallIntBuffer
extends SmallBuffer {
    private static final int SHIFT = 2;

    SmallIntBuffer(BigByteBuffer buffer) {
        super(buffer);
    }

    public SmallIntBuffer put(int value) {
        this.buffer.putInt(value);
        return this;
    }

    public SmallIntBuffer put(int index, int value) {
        this.buffer.putInt((long)index << 2, value);
        return this;
    }

    public final SmallIntBuffer put(int[] src) {
        this.buffer.putInt(src);
        return this;
    }

    public SmallIntBuffer put(IntBuffer src) {
        this.buffer.putInt(src);
        return this;
    }

    public SmallIntBuffer put(SmallIntBuffer src) {
        this.buffer.put(src.buffer);
        return this;
    }

    public int get() {
        return this.buffer.getInt();
    }

    public int get(int index) {
        return this.buffer.getInt((long)index << 2);
    }

    @Override
    int shift() {
        return 2;
    }

    @Override
    public SmallIntBuffer duplicate() {
        return new SmallIntBuffer(this.buffer.duplicate());
    }

    @Override
    public SmallIntBuffer slice() {
        return new SmallIntBuffer(this.buffer.slice());
    }

    public String toString() {
        return "[pos=%d lim=%d cap=%d]".formatted(this.buffer.position(), this.buffer.limit(), this.buffer.capacity());
    }
}

