/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.ShortBuffer;
import tech.bitey.bufferstuff.BigByteBuffer;
import tech.bitey.bufferstuff.SmallBuffer;

public final class SmallShortBuffer
extends SmallBuffer {
    private static final int SHIFT = 1;

    SmallShortBuffer(BigByteBuffer buffer) {
        super(buffer);
    }

    public SmallShortBuffer put(short value) {
        this.buffer.putShort(value);
        return this;
    }

    public SmallShortBuffer put(int index, short value) {
        this.buffer.putShort((long)index << 1, value);
        return this;
    }

    public final SmallShortBuffer put(short[] src) {
        this.buffer.putShort(src);
        return this;
    }

    public SmallShortBuffer put(ShortBuffer src) {
        this.buffer.putShort(src);
        return this;
    }

    public SmallShortBuffer put(SmallShortBuffer src) {
        this.buffer.put(src.buffer);
        return this;
    }

    public short get() {
        return this.buffer.getShort();
    }

    public short get(int index) {
        return this.buffer.getShort((long)index << 1);
    }

    @Override
    int shift() {
        return 1;
    }

    @Override
    public SmallShortBuffer duplicate() {
        return new SmallShortBuffer(this.buffer.duplicate());
    }

    @Override
    public SmallShortBuffer slice() {
        return new SmallShortBuffer(this.buffer.slice());
    }

    public String toString() {
        return "[pos=%d lim=%d cap=%d]".formatted(this.buffer.position(), this.buffer.limit(), this.buffer.capacity());
    }
}

