/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff.codegen;

import java.io.BufferedWriter;
import tech.bitey.bufferstuff.codegen.GenBufferCode;

public class GenBufferSearch
implements GenBufferCode {
    private static final String INT_RANGE_INDEX = "b.get(rangeIndex) == key";
    private static final String FLOAT_RANGE_INDEX = "BOX_TYPE.compare(b.get(rangeIndex), key) == 0";
    private static final String BINARY_SEARCH_COMPARE = "BINARY_SEARCH_COMPARE";
    private static final String BUFFER_TYPE = "BUFFER_TYPE";
    private static final String KEY_TYPE = "KEY_TYPE";
    private static final String BOX_TYPE = "BOX_TYPE";
    private static final String BITS_TYPE = "BITS_TYPE";
    private static final String BOX_BITS_TYPE = "BOX_BITS_TYPE";
    private static final String NAN_COMMENT = "NAN_COMMENT";
    private static final String COMPARE_FROM_INDEX = "COMPARE_FROM_INDEX";
    private static final String COMPARE_RANGE_INDEX = "COMPARE_RANGE_INDEX";
    private static final String PREFIX = "package tech.bitey.bufferstuff;\n\nimport static tech.bitey.bufferstuff.BufferUtils.rangeCheck;\nimport static tech.bitey.bufferstuff.BufferUtils.rangeCheckInclusive;\n\nimport java.nio.ByteBuffer;\nimport java.nio.DoubleBuffer;\nimport java.nio.FloatBuffer;\nimport java.nio.IntBuffer;\nimport java.nio.LongBuffer;\nimport java.nio.ShortBuffer;\n\n/**\n * Provides the primitive array binary search implementations from\n * {@code java.util.Arrays}, modified with minimal changes to support nio\n * buffers.\n * <p>\n * Also provides methods for finding the first or last index of a sequence of\n * duplicate values.\n *\n * @author biteytech@protonmail.com, adapted from java.util.Arrays\n */\npublic enum BufferSearch {\n\t; // static methods only, enum prevents instantiation\n";
    private static final String BINARY_SEARCH = "\t/**\n\t * Searches a range of the specified {@link BUFFER_TYPE} for the specified value\n\t * using the binary search algorithm. The range must be sorted in ascending\n\t * order prior to making this call. If it is not sorted, the results are\n\t * undefined. If the range contains multiple elements with the specified value,\n\t * there is no guarantee which one will be found.NAN_COMMENT\n\t *\n\t * @param b         the buffer to be searched\n\t * @param fromIndex the index of the first element (inclusive) to be searched\n\t * @param toIndex   the index of the last element (exclusive) to be searched\n\t * @param key       the value to be searched for\n\t *\n\t * @return index of the search key, if it is contained in the buffer within the\n\t *         specified range; otherwise, {@code (-(<i>insertion point</i>) - 1)}.\n\t *         The <i>insertion point</i> is defined as the point at which the key\n\t *         would be inserted into the buffer: the index of the first element in\n\t *         the range greater than the key, or {@code toIndex} if all elements in\n\t *         the range are less than the specified key. Note that this guarantees\n\t *         that the return value will be &gt;= 0 if and only if the key is\n\t *         found.\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static int binarySearch(BUFFER_TYPE b, int fromIndex, int toIndex, KEY_TYPE key) {\n\t\trangeCheck(b.capacity(), fromIndex, toIndex);\n\t\treturn binarySearch0(b, fromIndex, toIndex, key);\n\t}\n\n\tprivate static int binarySearch0(BUFFER_TYPE b, int fromIndex, int toIndex, KEY_TYPE key) {\n\t\tint low = fromIndex;\n\t\tint high = toIndex - 1;\n\n\t\twhile (low <= high) {\n\t\t\tint mid = (low + high) >>> 1;\n\t\t\tKEY_TYPE midVal = b.get(mid);\n\n\t\t\tBINARY_SEARCH_COMPARE\n\t\t}\n\t\treturn -(low + 1); // key not found.\n\t}\n";
    private static final String FLOAT_NAN_COMMENT = " This method considers all NaN values to be equivalent and equal.";
    private static final String BINARY_SEARCH_INT_COMPARE = "if (midVal < key)\n\tlow = mid + 1;\nelse if (midVal > key)\n\thigh = mid - 1;\nelse\n\treturn mid; // key found\n";
    private static final String BINARY_SEARCH_FLOAT_COMPARE = "if (midVal < key)\n\tlow = mid + 1; // Neither val is NaN, thisVal is smaller\nelse if (midVal > key)\n\thigh = mid - 1; // Neither val is NaN, thisVal is larger\nelse {\n\tBITS_TYPE midBits = BOX_TYPE.KEY_TYPEToBOX_BITS_TYPEBits(midVal);\n\tBITS_TYPE keyBits = BOX_TYPE.KEY_TYPEToBOX_BITS_TYPEBits(key);\n\tif (midBits == keyBits) // Values are equal\n\t\treturn mid; // Key found\n\telse if (midBits < keyBits) // (-0.0, 0.0) or (!NaN, NaN)\n\t\tlow = mid + 1;\n\telse // (0.0, -0.0) or (NaN, !NaN)\n\t\thigh = mid - 1;\n}\n";
    private static final String BINARY_FIND_FIRST = "\t/**\n\t * Searches a range of the specified {@link BUFFER_TYPE} for the first occurrence\n\t * of the value at the given {@code keyIndex}. The range must be sorted in\n\t * ascending order prior to making this call. If it is not sorted, the results\n\t * are undefined.NAN_COMMENT\n\t * <p>\n\t * This method is useful as a post-processing step after a binary search on a\n\t * buffer which contains duplicate elements.\n\t *\n\t * @param b        the buffer to be searched\n\t * @param minIndex the lowest index to be searched\n\t * @param keyIndex an index of the value for which to find the first occurrence\n\t *                 (inclusive)\n\t *\n\t * @return index of the first occurrence of the value at {@code keyIndex}\n\t *\n\t * @throws IllegalArgumentException  if {@code minIndex > keyIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code minIndex < 0 or keyIndex >= b.capacity()}\n\t */\n\tpublic static int binaryFindFirst(BUFFER_TYPE b, int minIndex, int keyIndex) {\n\t\trangeCheckInclusive(b.capacity(), minIndex, keyIndex);\n\t\treturn binaryFindFirst(b, minIndex, keyIndex, b.get(keyIndex));\n\t}\n\n\tprivate static int binaryFindFirst(BUFFER_TYPE b, int minIndex, int fromIndex, KEY_TYPE key) {\n\n\t\twhile (minIndex != fromIndex && COMPARE_FROM_INDEX) {\n\n\t\t\tint range = 1, rangeIndex;\n\t\t\tdo {\n\t\t\t\trange <<= 1;\n\t\t\t\trangeIndex = fromIndex - range;\n\t\t\t} while (minIndex <= rangeIndex && COMPARE_RANGE_INDEX);\n\n\t\t\tfromIndex -= range >> 1;\n\t\t}\n\n\t\treturn fromIndex;\n\t}\n";
    private static final String BINARY_FIND_LAST = "\t/**\n\t * Searches a range of the specified {@link BUFFER_TYPE} for the last occurrence\n\t * of the value at the given {@code keyIndex}. The range must be sorted in\n\t * ascending order prior to making this call. If it is not sorted, the results\n\t * are undefined.NAN_COMMENT\n\t * <p>\n\t * This method is useful as a post-processing step after a binary search on a\n\t * buffer which contains duplicate elements.\n\t *\n\t * @param b        the buffer to be searched\n\t * @param maxIndex the highest index to be searched (exclusive)\n\t * @param keyIndex an index of the value for which to find the first occurrence\n\t *                 (inclusive)\n\t *\n\t * @return index of the last occurrence of the value at {@code keyIndex}\n\t *\n\t * @throws IllegalArgumentException  if {@code maxIndex < keyIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code keyIndex < 0 or maxIndex > b.capacity()}\n\t */\n\tpublic static int binaryFindLast(BUFFER_TYPE b, int maxIndex, int keyIndex) {\n\t\trangeCheck(b.capacity(), keyIndex, maxIndex);\n\t\tif (keyIndex == maxIndex)\n\t\t\treturn keyIndex;\n\t\telse\n\t\t\treturn binaryFindLast(b, keyIndex, maxIndex - 1, b.get(keyIndex));\n\t}\n\n\tprivate static int binaryFindLast(BUFFER_TYPE b, int fromIndex, int maxIndex, KEY_TYPE key) {\n\n\t\twhile (fromIndex != maxIndex && COMPARE_FROM_INDEX) {\n\n\t\t\tint range = 1, rangeIndex;\n\t\t\tdo {\n\t\t\t\trange <<= 1;\n\t\t\t\trangeIndex = fromIndex + range;\n\t\t\t} while (rangeIndex <= maxIndex && COMPARE_RANGE_INDEX);\n\n\t\t\tfromIndex += range >> 1;\n\t\t}\n\n\t\treturn fromIndex;\n\t}\n";

    @Override
    public void run() throws Exception {
        try (BufferedWriter out = this.open("BufferSearch.java");){
            this.section(out, PREFIX);
            this.sections(out, false);
            this.sections(out, true);
            out.write("}\n");
        }
    }

    private void sections(BufferedWriter out, boolean small) throws Exception {
        String s = small ? "Small" : "";
        this.section(out, GenBufferSearch.intBinarySearch(s + "IntBuffer", "int"));
        this.section(out, GenBufferSearch.intBinarySearch(s + "LongBuffer", "long"));
        this.section(out, GenBufferSearch.intBinarySearch(s + "ShortBuffer", "short"));
        this.section(out, GenBufferSearch.intBinarySearch(s + "ByteBuffer", "byte"));
        this.section(out, GenBufferSearch.floatBinarySearch(s + "FloatBuffer", "float", "Float", "int", "Int"));
        this.section(out, GenBufferSearch.floatBinarySearch(s + "DoubleBuffer", "double", "Double", "long", "Long"));
        this.section(out, GenBufferSearch.intBinaryFindFirst(s + "IntBuffer", "int"));
        this.section(out, GenBufferSearch.intBinaryFindLast(s + "IntBuffer", "int"));
        this.section(out, GenBufferSearch.intBinaryFindFirst(s + "LongBuffer", "long"));
        this.section(out, GenBufferSearch.intBinaryFindLast(s + "LongBuffer", "long"));
        this.section(out, GenBufferSearch.intBinaryFindFirst(s + "ShortBuffer", "short"));
        this.section(out, GenBufferSearch.intBinaryFindLast(s + "ShortBuffer", "short"));
        this.section(out, GenBufferSearch.intBinaryFindFirst(s + "ByteBuffer", "byte"));
        this.section(out, GenBufferSearch.intBinaryFindLast(s + "ByteBuffer", "byte"));
        this.section(out, GenBufferSearch.floatBinaryFindFirst(s + "FloatBuffer", "float", "Float"));
        this.section(out, GenBufferSearch.floatBinaryFindLast(s + "FloatBuffer", "float", "Float"));
        this.section(out, GenBufferSearch.floatBinaryFindFirst(s + "DoubleBuffer", "double", "Double"));
        this.section(out, GenBufferSearch.floatBinaryFindLast(s + "DoubleBuffer", "double", "Double"));
    }

    private static String intBinarySearch(String bufferType, String keyType) {
        return BINARY_SEARCH.replace(BINARY_SEARCH_COMPARE, BINARY_SEARCH_INT_COMPARE).replace(BUFFER_TYPE, bufferType).replace(KEY_TYPE, keyType).replace(NAN_COMMENT, "");
    }

    private static String floatBinarySearch(String bufferType, String keyType, String boxType, String bitsType, String boxBitsType) {
        return BINARY_SEARCH.replace(BINARY_SEARCH_COMPARE, BINARY_SEARCH_FLOAT_COMPARE).replace(BUFFER_TYPE, bufferType).replace(KEY_TYPE, keyType).replace(BOX_TYPE, boxType).replace(BOX_BITS_TYPE, boxBitsType).replace(BITS_TYPE, bitsType).replace(NAN_COMMENT, FLOAT_NAN_COMMENT);
    }

    private static String intBinaryFindFirst(String bufferType, String keyType) {
        return BINARY_FIND_FIRST.replace(BUFFER_TYPE, bufferType).replace(KEY_TYPE, keyType).replace(NAN_COMMENT, "").replace(COMPARE_FROM_INDEX, "b.get(fromIndex - 1) == key").replace(COMPARE_RANGE_INDEX, INT_RANGE_INDEX);
    }

    private static String floatBinaryFindFirst(String bufferType, String keyType, String boxType) {
        return BINARY_FIND_FIRST.replace(COMPARE_FROM_INDEX, "BOX_TYPE.compare(b.get(fromIndex - 1), key) == 0").replace(COMPARE_RANGE_INDEX, FLOAT_RANGE_INDEX).replace(BUFFER_TYPE, bufferType).replace(KEY_TYPE, keyType).replace(NAN_COMMENT, FLOAT_NAN_COMMENT).replace(BOX_TYPE, boxType);
    }

    private static String intBinaryFindLast(String bufferType, String keyType) {
        return BINARY_FIND_LAST.replace(BUFFER_TYPE, bufferType).replace(KEY_TYPE, keyType).replace(NAN_COMMENT, "").replace(COMPARE_FROM_INDEX, "b.get(fromIndex + 1) == key").replace(COMPARE_RANGE_INDEX, INT_RANGE_INDEX);
    }

    private static String floatBinaryFindLast(String bufferType, String keyType, String boxType) {
        return BINARY_FIND_LAST.replace(COMPARE_FROM_INDEX, "BOX_TYPE.compare(b.get(fromIndex + 1), key) == 0").replace(COMPARE_RANGE_INDEX, FLOAT_RANGE_INDEX).replace(BUFFER_TYPE, bufferType).replace(KEY_TYPE, keyType).replace(NAN_COMMENT, FLOAT_NAN_COMMENT).replace(BOX_TYPE, boxType);
    }
}

