/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff.codegen;

import java.io.BufferedWriter;
import tech.bitey.bufferstuff.codegen.GenBufferCode;

public class GenBufferSpliterators
implements GenBufferCode {
    private static final String SHORT_BOX_TYPE = "SHORT_BOX_TYPE";
    private static final String LONG_BOX_TYPE = "LONG_BOX_TYPE";
    private static final String BUFFER_TYPE = "BUFFER_TYPE";
    private static final String SPLITERATOR = "\t/**\n\t * A Spliterator.OfSHORT_BOX_TYPE designed for use by sources that traverse and split\n\t * elements maintained in an unmodifiable {@link BUFFER_TYPE}.\n\t * <p>\n\t * Based on {@code Spliterators.SHORT_BOX_TYPEArraySpliterator}\n\t */\n\tpublic static final class BUFFER_TYPESpliterator implements Spliterator.OfSHORT_BOX_TYPE {\n\t\tprivate final BUFFER_TYPE buffer;\n\t\tprivate int index; // current index, modified on advance/split\n\t\tprivate final int fence; // one past last index\n\t\tprivate final int characteristics;\n\n\t\t/**\n\t\t * Creates a spliterator covering all of the given {@link BUFFER_TYPE}.\n\t\t * <p>\n\t\t * <b>Note:</b> ignores {@link BUFFER_TYPE#position() position} and\n\t\t * {@link BUFFER_TYPE#limit() limit}, can pass a {@link BUFFER_TYPE#slice() slice}\n\t\t * instead.\n\t\t *\n\t\t * @param buffer                    the buffer, assumed to be unmodified during\n\t\t *                                  use\n\t\t * @param additionalCharacteristics Additional spliterator characteristics of\n\t\t *                                  this spliterator's source or elements beyond\n\t\t *                                  {@code SIZED} and {@code SUBSIZED} which are\n\t\t *                                  are always reported\n\t\t */\n\t\tpublic BUFFER_TYPESpliterator(BUFFER_TYPE buffer, int additionalCharacteristics) {\n\t\t\tthis(buffer, 0, buffer.capacity(), additionalCharacteristics);\n\t\t}\n\n\t\t/**\n\t\t * Creates a spliterator covering the given {@link BUFFER_TYPE} and range.\n\t\t *\n\t\t * @param buffer                    the buffer, assumed to be unmodified during\n\t\t *                                  use\n\t\t * @param origin                    the least index (inclusive) to cover\n\t\t * @param fence                     one past the greatest index to cover\n\t\t * @param additionalCharacteristics Additional spliterator characteristics of\n\t\t *                                  this spliterator's source or elements beyond\n\t\t *                                  {@code SIZED} and {@code SUBSIZED} which are\n\t\t *                                  are always reported\n\t\t */\n\t\tpublic BUFFER_TYPESpliterator(BUFFER_TYPE buffer, int origin, int fence, int additionalCharacteristics) {\n\t\t\tthis.buffer = buffer;\n\t\t\tthis.index = origin;\n\t\t\tthis.fence = fence;\n\t\t\tthis.characteristics = additionalCharacteristics | Spliterator.SIZED | Spliterator.SUBSIZED;\n\t\t}\n\n\t\t@Override\n\t\tpublic OfSHORT_BOX_TYPE trySplit() {\n\t\t\tint lo = index, mid = (lo + fence) >>> 1;\n\t\t\treturn (lo >= mid) ? null : new BUFFER_TYPESpliterator(buffer, lo, index = mid, characteristics);\n\t\t}\n\n\t\t@Override\n\t\tpublic void forEachRemaining(SHORT_BOX_TYPEConsumer action) {\n\t\t\tBUFFER_TYPE b;\n\t\t\tint i, hi; // hoist accesses and checks from loop\n\t\t\tif (action == null)\n\t\t\t\tthrow new NullPointerException();\n\t\t\tif ((b = buffer).capacity() >= (hi = fence) && (i = index) >= 0 && i < (index = hi)) {\n\t\t\t\tdo {\n\t\t\t\t\taction.accept(b.get(i));\n\t\t\t\t} while (++i < hi);\n\t\t\t}\n\t\t}\n\n\t\t@Override\n\t\tpublic boolean tryAdvance(SHORT_BOX_TYPEConsumer action) {\n\t\t\tif (action == null)\n\t\t\t\tthrow new NullPointerException();\n\t\t\tif (index >= 0 && index < fence) {\n\t\t\t\taction.accept(buffer.get(index++));\n\t\t\t\treturn true;\n\t\t\t}\n\t\t\treturn false;\n\t\t}\n\n\t\t@Override\n\t\tpublic long estimateSize() {\n\t\t\treturn fence - index;\n\t\t}\n\n\t\t@Override\n\t\tpublic int characteristics() {\n\t\t\treturn characteristics;\n\t\t}\n\n\t\t@Override\n\t\tpublic Comparator<? super LONG_BOX_TYPE> getComparator() {\n\t\t\tif (hasCharacteristics(Spliterator.SORTED))\n\t\t\t\treturn null;\n\t\t\tthrow new IllegalStateException();\n\t\t}\n\t}\n";
    private static final String PREFIX = "package tech.bitey.bufferstuff;\n\nimport java.nio.DoubleBuffer;\nimport java.nio.IntBuffer;\nimport java.nio.LongBuffer;\nimport java.util.Comparator;\nimport java.util.Spliterator;\nimport java.util.function.DoubleConsumer;\nimport java.util.function.IntConsumer;\nimport java.util.function.LongConsumer;\n\npublic class BufferSpliterators {\n";

    @Override
    public void run() throws Exception {
        try (BufferedWriter out = this.open("BufferSpliterators.java");){
            this.section(out, PREFIX);
            this.sections(out, false);
            this.sections(out, true);
            out.write("}\n");
        }
    }

    private void sections(BufferedWriter out, boolean small) throws Exception {
        String s = small ? "Small" : "";
        this.section(out, GenBufferSpliterators.spliterator("Int", "Integer", s + "IntBuffer"));
        this.section(out, GenBufferSpliterators.spliterator("Long", "Long", s + "LongBuffer"));
        this.section(out, GenBufferSpliterators.spliterator("Double", "Double", s + "DoubleBuffer"));
    }

    private static String spliterator(String shortBoxType, String longBoxType, String bufferType) {
        return SPLITERATOR.replace(SHORT_BOX_TYPE, shortBoxType).replace(LONG_BOX_TYPE, longBoxType).replace(BUFFER_TYPE, bufferType);
    }
}

