/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff.codegen;

import java.io.BufferedWriter;
import tech.bitey.bufferstuff.codegen.GenBufferCode;

public class GenSmallBuffers
implements GenBufferCode {
    private static final String BUFFER_TYPE = "BUFFER_TYPE";
    private static final String VAL_TYPE = "VAL_TYPE";
    private static final String SHIFT_BITS = "SHIFT_BITS";
    private static final String FILE = "package tech.bitey.bufferstuff;\n\nimport java.nio.BufferOverflowException;\nimport java.nio.BufferUnderflowException;\nimport java.nio.BUFFER_TYPEBuffer;\n\n/**\n * This class has an API similar to {@link BUFFER_TYPEBuffer}. All implementations are\n * backed by a {@link BigByteBuffer}. \"Small\" refers to the fact that these\n * buffers are indexed by ints rather than longs.\n * <p>\n * Differences from {@code BUFFER_TYPEBuffer} include:\n * <ul>\n * <li>mark and reset are not supported\n * <li>read-only is not supported\n * <li>byte order is preserved in {@link #duplicate()} and {@link #slice()}.\n * </ul>\n */\npublic final class SmallBUFFER_TYPEBuffer extends SmallBuffer {\n\n\tprivate static final int SHIFT = SHIFT_BITS;\n\n\tSmallBUFFER_TYPEBuffer(BigByteBuffer buffer) {\n\t\tsuper(buffer);\n\t}\n\n\t/**\n\t * Relative <i>put</i> method\n\t * <p>\n\t * Writes the given VAL_TYPE into this buffer at the current position, and then\n\t * increments the position.\n\t *\n\t * @param value The VAL_TYPE to be written\n\t *\n\t * @return This buffer\n\t *\n\t * @throws BufferOverflowException If this buffer's current position is not\n\t *                                 smaller than its limit\n\t */\n\tpublic SmallBUFFER_TYPEBuffer put(VAL_TYPE value) {\n\t\tbuffer.putBUFFER_TYPE(value);\n\t\treturn this;\n\t}\n\n\t/**\n\t * Absolute <i>put</i> method\n\t * <p>\n\t * Writes the given VAL_TYPE into this buffer at the given index.\n\t *\n\t * @param index The index at which the VAL_TYPE will be written\n\t *\n\t * @param value The VAL_TYPE value to be written\n\t *\n\t * @return This buffer\n\t *\n\t * @throws IndexOutOfBoundsException If {@code index} is negative or not smaller\n\t *                                   than the buffer's limit\n\t */\n\tpublic SmallBUFFER_TYPEBuffer put(int index, VAL_TYPE value) {\n\t\tbuffer.putBUFFER_TYPE((long) index << SHIFT, value);\n\t\treturn this;\n\t}\n\n\t/**\n\t * Relative bulk <i>put</i> method\n\t * <p>\n\t * This method transfers the entire content of the given source BUFFER_TYPE array into\n\t * this buffer.\n\t *\n\t * @param src The source array\n\t *\n\t * @return This buffer\n\t *\n\t * @throws BufferOverflowException If there is insufficient space in this buffer\n\t */\n\tpublic final SmallBUFFER_TYPEBuffer put(VAL_TYPE[] src) {\n\t\tbuffer.putBUFFER_TYPE(src);\n\t\treturn this;\n\t}\n\n\t/**\n\t * Relative bulk <i>put</i> method\n\t * <p>\n\t * This method transfers the VAL_TYPEs remaining in the given source buffer into\n\t * this buffer. If there are more VAL_TYPEs remaining in the source buffer than in\n\t * this buffer, that is, if\n\t * {@code src.remaining()}&nbsp;{@code >}&nbsp;{@code remaining()}, then no\n\t * shorts are transferred and a {@link BufferOverflowException} is thrown.\n\t * <p>\n\t * Otherwise, this method copies <i>n</i>&nbsp;=&nbsp;{@code src.remaining()}\n\t * VAL_TYPEs from the given buffer into this buffer, starting at each buffer's\n\t * current position. The positions of both buffers are then incremented by\n\t * <i>n</i>.\n\t *\n\t * <p>\n\t * In other words, an invocation of this method of the form {@code dst.put(src)}\n\t * has exactly the same effect as the loop\n\t *\n\t * <pre>\n\t * while (src.hasRemaining())\n\t * \tdst.put(src.get());\n\t * </pre>\n\t *\n\t * except that it first checks that there is sufficient space in this buffer and\n\t * it is potentially much more efficient. If this buffer and the source buffer\n\t * share the same backing array or memory, then the result will be as if the\n\t * source elements were first copied to an intermediate location before being\n\t * written into this buffer.\n\t *\n\t * @param src The source buffer from which VAL_TYPEs are to be read; must not be\n\t *            this buffer\n\t *\n\t * @return This buffer\n\t *\n\t * @throws BufferOverflowException If there is insufficient space in this buffer\n\t *                                 for the remaining VAL_TYPEs in the source buffer\n\t */\n\tpublic SmallBUFFER_TYPEBuffer put(BUFFER_TYPEBuffer src) {\n\t\tbuffer.putBUFFER_TYPE(src);\n\t\treturn this;\n\t}\n\n\t/**\n\t * Relative bulk <i>put</i> method\n\t * <p>\n\t * This method transfers the VAL_TYPEs remaining in the given source buffer into\n\t * this buffer. If there are more VAL_TYPEs remaining in the source buffer than in\n\t * this buffer, that is, if\n\t * {@code src.remaining()}&nbsp;{@code >}&nbsp;{@code remaining()}, then no\n\t * shorts are transferred and a {@link BufferOverflowException} is thrown.\n\t * <p>\n\t * Otherwise, this method copies <i>n</i>&nbsp;=&nbsp;{@code src.remaining()}\n\t * VAL_TYPEs from the given buffer into this buffer, starting at each buffer's\n\t * current position. The positions of both buffers are then incremented by\n\t * <i>n</i>.\n\t *\n\t * <p>\n\t * In other words, an invocation of this method of the form {@code dst.put(src)}\n\t * has exactly the same effect as the loop\n\t *\n\t * <pre>\n\t * while (src.hasRemaining())\n\t * \tdst.put(src.get());\n\t * </pre>\n\t *\n\t * except that it first checks that there is sufficient space in this buffer and\n\t * it is potentially much more efficient. If this buffer and the source buffer\n\t * share the same backing array or memory, then the result will be as if the\n\t * source elements were first copied to an intermediate location before being\n\t * written into this buffer.\n\t *\n\t * @param src The source buffer from which VAL_TYPEs are to be read; must not be\n\t *            this buffer\n\t *\n\t * @return This buffer\n\t *\n\t * @throws BufferOverflowException If there is insufficient space in this buffer\n\t *                                 for the remaining VAL_TYPEs in the source buffer\n\t */\n\tpublic SmallBUFFER_TYPEBuffer put(SmallBUFFER_TYPEBuffer src) {\n\t\tbuffer.put(src.buffer);\n\t\treturn this;\n\t}\n\n\t/**\n\t * Relative <i>get</i> method. Reads the VAL_TYPE at this buffer's current\n\t * position, and then increments the position.\n\t *\n\t * @return The VAL_TYPE at the buffer's current position\n\t *\n\t * @throws BufferUnderflowException If the buffer's current position is not\n\t *                                  smaller than its limit\n\t */\n\tpublic VAL_TYPE get() {\n\t\treturn buffer.getBUFFER_TYPE();\n\t}\n\n\t/**\n\t * Absolute <i>get</i> method. Reads the VAL_TYPE at the given index.\n\t *\n\t * @param index The index from which the VAL_TYPE will be read\n\t *\n\t * @return The VAL_TYPE at the given index\n\t *\n\t * @throws IndexOutOfBoundsException If {@code index} is negative or not smaller\n\t *                                   than the buffer's limit\n\t */\n\tpublic VAL_TYPE get(int index) {\n\t\treturn buffer.getBUFFER_TYPE((long) index << SHIFT);\n\t}\n\n\t@Override\n\tint shift() {\n\t\treturn SHIFT;\n\t}\n\n\t@Override\n\tpublic SmallBUFFER_TYPEBuffer duplicate() {\n\t\treturn new SmallBUFFER_TYPEBuffer(buffer.duplicate());\n\t}\n\n\t@Override\n\tpublic SmallBUFFER_TYPEBuffer slice() {\n\t\treturn new SmallBUFFER_TYPEBuffer(buffer.slice());\n\t}\n\n\t@Override\n\tpublic String toString() {\n\t\treturn \"[pos=%d lim=%d cap=%d]\".formatted(buffer.position(), buffer.limit(), buffer.capacity());\n\t}\n\n}\n";

    @Override
    public void run() throws Exception {
        this.run("Byte", "byte", 0);
        this.run("Short", "short", 1);
        this.run("Int", "int", 2);
        this.run("Long", "long", 3);
        this.run("Float", "float", 2);
        this.run("Double", "double", 3);
    }

    private void run(String bufferType, String valType, int shift) throws Exception {
        try (BufferedWriter out = this.open("Small" + bufferType + "Buffer.java");){
            out.write(FILE.replace(BUFFER_TYPE, bufferType).replace(VAL_TYPE, valType).replace(SHIFT_BITS, "" + shift).replace("putByte", "put").replace("getByte", "get"));
        }
    }
}

