/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.ByteBuffer;
import java.util.Arrays;
import tech.bitey.bufferstuff.BigByteBuffer;
import tech.bitey.bufferstuff.BufferUtils;
import tech.bitey.bufferstuff.SimpleBigByteBuffer;

public class ResizableBigByteBuffer {
    private BigByteBuffer buffer = BufferUtils.allocateBig(8L);

    public long size() {
        return this.buffer.position();
    }

    public void put(ByteBuffer buffer) {
        this.ensureAdditionalCapacity(buffer.remaining());
        this.buffer.put(buffer);
    }

    public void put(byte[] bytes) {
        this.ensureAdditionalCapacity(bytes.length);
        this.buffer.put(bytes);
    }

    public void putInt(int value) {
        this.ensureAdditionalCapacity(4L);
        this.buffer.putInt(value);
    }

    public void append(ResizableBigByteBuffer tail) {
        if (tail.size() == 0L) {
            return;
        }
        this.ensureAdditionalCapacity(tail.size());
        this.buffer.put(tail.buffer.duplicate().flip());
    }

    private void ensureAdditionalCapacity(long additionalCapacity) {
        this.ensureCapacity(this.size() + additionalCapacity);
    }

    private void ensureCapacity(long minCapacity) {
        if (this.buffer.capacity() < minCapacity) {
            long newCapacity = this.buffer.capacity() + (this.buffer.capacity() >> 1) + 1L;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            BigByteBuffer extended = BufferUtils.allocateBig(newCapacity);
            this.buffer.flip();
            extended.put(this.buffer);
            this.buffer = extended;
        }
    }

    public BigByteBuffer trim() {
        if (this.size() == 0L) {
            return BufferUtils.EMPTY_BIG_BUFFER;
        }
        BigByteBuffer bigByteBuffer = this.buffer;
        if (bigByteBuffer instanceof SimpleBigByteBuffer) {
            SimpleBigByteBuffer s = (SimpleBigByteBuffer)bigByteBuffer;
            return s.position() == s.capacity() ? s.slice(0L, s.position()) : s.copy(0L, s.position());
        }
        ByteBuffer[] buffers = Arrays.copyOf(this.buffer.buffers(), (int)(this.size() - 1L >> 30) + 1);
        ByteBuffer last = buffers[buffers.length - 1];
        int rem = (int)(this.size() & 0x3FFFFFFFL);
        if (rem != 0) {
            buffers[buffers.length - 1] = BufferUtils.copy(last, 0, rem);
        }
        return BufferUtils.wrap(buffers);
    }

    public String toString() {
        return "[pos=%d lim=%d cap=%d]".formatted(this.buffer.position(), this.buffer.limit(), this.buffer.capacity());
    }
}

