/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import tech.bitey.bufferstuff.AbstractBigByteBuffer;
import tech.bitey.bufferstuff.BigByteBuffer;
import tech.bitey.bufferstuff.BufferUtils;

final class SimpleBigByteBuffer
extends AbstractBigByteBuffer {
    private final ByteBuffer buffer;

    SimpleBigByteBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public ByteBuffer[] buffers() {
        return new ByteBuffer[]{this.buffer};
    }

    @Override
    public long position() {
        return this.buffer.position();
    }

    @Override
    public long limit() {
        return this.buffer.limit();
    }

    @Override
    public long capacity() {
        return this.buffer.capacity();
    }

    @Override
    public BigByteBuffer position(long newPosition) {
        this.buffer.position(Math.toIntExact(newPosition));
        return this;
    }

    @Override
    public BigByteBuffer limit(long newLimit) {
        this.buffer.limit(Math.toIntExact(newLimit));
        return this;
    }

    @Override
    public long remaining() {
        return this.buffer.remaining();
    }

    @Override
    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    @Override
    public ByteOrder order() {
        return this.buffer.order();
    }

    @Override
    public BigByteBuffer order(ByteOrder order) {
        this.buffer.order(order);
        return this;
    }

    @Override
    public BigByteBuffer duplicate() {
        return new SimpleBigByteBuffer(this.buffer.duplicate().order(this.buffer.order()));
    }

    @Override
    public BigByteBuffer slice() {
        return new SimpleBigByteBuffer(this.buffer.slice().order(this.buffer.order()));
    }

    @Override
    public BigByteBuffer slice(long fromIndex, long toIndex) {
        return new SimpleBigByteBuffer(this.buffer.slice(Math.toIntExact(fromIndex), Math.toIntExact(toIndex - fromIndex)).order(this.buffer.order()));
    }

    @Override
    public ByteBuffer smallSlice() {
        return this.slice().buffers()[0];
    }

    @Override
    public ByteBuffer smallSlice(long fromIndex, long toIndex) {
        return this.slice(fromIndex, toIndex).buffers()[0];
    }

    @Override
    public BigByteBuffer copy(long fromIndex, long toIndex) {
        return new SimpleBigByteBuffer(BufferUtils.copy(this.buffer, Math.toIntExact(fromIndex), Math.toIntExact(toIndex)));
    }

    @Override
    public BigByteBuffer clear() {
        this.buffer.clear();
        return this;
    }

    @Override
    public BigByteBuffer flip() {
        this.buffer.flip();
        return this;
    }

    @Override
    public BigByteBuffer put(byte value) {
        this.buffer.put(value);
        return this;
    }

    @Override
    public BigByteBuffer put(long index, byte value) {
        this.buffer.put(Math.toIntExact(index), value);
        return this;
    }

    @Override
    public BigByteBuffer put(BigByteBuffer src) {
        if (src.remaining() > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (ByteBuffer b : src.slice().buffers()) {
            this.buffer.put(b);
        }
        return this;
    }

    @Override
    public byte get() {
        return this.buffer.get();
    }

    @Override
    public byte get(long index) {
        return this.buffer.get(Math.toIntExact(index));
    }

    @Override
    public BigByteBuffer get(byte[] dst, int offset, int length) {
        this.buffer.get(dst, offset, length);
        return this;
    }

    @Override
    public BigByteBuffer get(byte[] dst) {
        this.buffer.get(dst);
        return this;
    }

    @Override
    public BigByteBuffer putShort(short value) {
        this.buffer.putShort(value);
        return this;
    }

    @Override
    public BigByteBuffer putShort(long index, short value) {
        this.buffer.putShort(Math.toIntExact(index), value);
        return this;
    }

    @Override
    public short getShort() {
        return this.buffer.getShort();
    }

    @Override
    public short getShort(long index) {
        return this.buffer.getShort(Math.toIntExact(index));
    }

    @Override
    public BigByteBuffer putInt(int value) {
        this.buffer.putInt(value);
        return this;
    }

    @Override
    public BigByteBuffer putInt(long index, int value) {
        this.buffer.putInt(Math.toIntExact(index), value);
        return this;
    }

    @Override
    public int getInt() {
        return this.buffer.getInt();
    }

    @Override
    public int getInt(long index) {
        return this.buffer.getInt(Math.toIntExact(index));
    }

    @Override
    public BigByteBuffer putLong(long value) {
        this.buffer.putLong(value);
        return this;
    }

    @Override
    public BigByteBuffer putLong(long index, long value) {
        this.buffer.putLong(Math.toIntExact(index), value);
        return this;
    }

    @Override
    public long getLong() {
        return this.buffer.getLong();
    }

    @Override
    public long getLong(long index) {
        return this.buffer.getLong(Math.toIntExact(index));
    }

    @Override
    public BigByteBuffer putFloat(float value) {
        this.buffer.putFloat(value);
        return this;
    }

    @Override
    public BigByteBuffer putFloat(long index, float value) {
        this.buffer.putFloat(Math.toIntExact(index), value);
        return this;
    }

    @Override
    public float getFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public float getFloat(long index) {
        return this.buffer.getFloat(Math.toIntExact(index));
    }

    @Override
    public BigByteBuffer putDouble(double value) {
        this.buffer.putDouble(value);
        return this;
    }

    @Override
    public BigByteBuffer putDouble(long index, double value) {
        this.buffer.putDouble(Math.toIntExact(index), value);
        return this;
    }

    @Override
    public double getDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public double getDouble(long index) {
        return this.buffer.getDouble(Math.toIntExact(index));
    }

    @Override
    public BigByteBuffer putShort(short[] src) {
        this.buffer.asShortBuffer().put(src);
        this.buffer.position(this.buffer.position() + src.length * 2);
        return this;
    }

    @Override
    public BigByteBuffer putInt(int[] src) {
        this.buffer.asIntBuffer().put(src);
        this.buffer.position(this.buffer.position() + src.length * 4);
        return this;
    }

    @Override
    public BigByteBuffer putLong(long[] src) {
        this.buffer.asLongBuffer().put(src);
        this.buffer.position(this.buffer.position() + src.length * 8);
        return this;
    }

    @Override
    public BigByteBuffer putFloat(float[] src) {
        this.buffer.asFloatBuffer().put(src);
        this.buffer.position(this.buffer.position() + src.length * 4);
        return this;
    }

    @Override
    public BigByteBuffer putDouble(double[] src) {
        this.buffer.asDoubleBuffer().put(src);
        this.buffer.position(this.buffer.position() + src.length * 8);
        return this;
    }

    @Override
    public BigByteBuffer put(byte[] src) {
        this.buffer.put(src);
        return this;
    }

    @Override
    public BigByteBuffer put(long index, ByteBuffer src, int offset, int length) {
        this.buffer.put(Math.toIntExact(index), src, offset, length);
        return this;
    }

    @Override
    public BigByteBuffer putShort(ShortBuffer src) {
        int remaining = src.remaining();
        this.buffer.asShortBuffer().put(src);
        this.buffer.position(this.buffer.position() + remaining * 2);
        return this;
    }

    @Override
    public BigByteBuffer putInt(IntBuffer src) {
        int remaining = src.remaining();
        this.buffer.asIntBuffer().put(src);
        this.buffer.position(this.buffer.position() + remaining * 4);
        return this;
    }

    @Override
    public BigByteBuffer putLong(LongBuffer src) {
        int remaining = src.remaining();
        this.buffer.asLongBuffer().put(src);
        this.buffer.position(this.buffer.position() + remaining * 8);
        return this;
    }

    @Override
    public BigByteBuffer putFloat(FloatBuffer src) {
        int remaining = src.remaining();
        this.buffer.asFloatBuffer().put(src);
        this.buffer.position(this.buffer.position() + remaining * 4);
        return this;
    }

    @Override
    public BigByteBuffer putDouble(DoubleBuffer src) {
        int remaining = src.remaining();
        this.buffer.asDoubleBuffer().put(src);
        this.buffer.position(this.buffer.position() + remaining * 8);
        return this;
    }

    @Override
    public BigByteBuffer put(ByteBuffer src) {
        this.buffer.put(src);
        return this;
    }

    public boolean equals(Object o) {
        if (o instanceof BigByteBuffer) {
            BigByteBuffer rhs = (BigByteBuffer)o;
            if (this.remaining() != rhs.remaining()) {
                return false;
            }
            return this.buffer.equals(rhs.smallSlice(rhs.position(), rhs.limit()));
        }
        return false;
    }

    @Override
    public InputStream toInputStream() {
        return new InputStream(){
            final ByteBuffer buf;
            {
                this.buf = SimpleBigByteBuffer.this.smallSlice();
            }

            @Override
            public int available() throws IOException {
                return this.buf.remaining();
            }

            @Override
            public int read() throws IOException {
                return this.buf.hasRemaining() ? this.buf.get() & 0xFF : -1;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                len = Math.min(len, this.buf.remaining());
                this.buf.get(bytes, off, len);
                return len;
            }

            public String toString() {
                return SimpleBigByteBuffer.this.toString();
            }
        };
    }
}

