/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff;

import java.nio.LongBuffer;
import tech.bitey.bufferstuff.BigByteBuffer;
import tech.bitey.bufferstuff.SmallBuffer;

public final class SmallLongBuffer
extends SmallBuffer {
    private static final int SHIFT = 3;

    SmallLongBuffer(BigByteBuffer buffer) {
        super(buffer);
    }

    public SmallLongBuffer put(long value) {
        this.buffer.putLong(value);
        return this;
    }

    public SmallLongBuffer put(int index, long value) {
        this.buffer.putLong((long)index << 3, value);
        return this;
    }

    public final SmallLongBuffer put(long[] src) {
        this.buffer.putLong(src);
        return this;
    }

    public SmallLongBuffer put(LongBuffer src) {
        this.buffer.putLong(src);
        return this;
    }

    public SmallLongBuffer put(SmallLongBuffer src) {
        this.buffer.put(src.buffer);
        return this;
    }

    public long get() {
        return this.buffer.getLong();
    }

    public long get(int index) {
        return this.buffer.getLong((long)index << 3);
    }

    @Override
    int shift() {
        return 3;
    }

    @Override
    public SmallLongBuffer duplicate() {
        return new SmallLongBuffer(this.buffer.duplicate());
    }

    @Override
    public SmallLongBuffer slice() {
        return new SmallLongBuffer(this.buffer.slice());
    }

    public String toString() {
        return "[pos=%d lim=%d cap=%d]".formatted(this.buffer.position(), this.buffer.limit(), this.buffer.capacity());
    }
}

