/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff.codegen;

import java.io.BufferedWriter;
import tech.bitey.bufferstuff.codegen.GenBufferCode;

public class GenBigByteBuffer
implements GenBufferCode {
    private static final String VAL_TYPE = "VAL_TYPE";
    private static final String FUNC_NAME = "FUNC_NAME";
    private static final String NUM_BYTES = "NUM_BYTES";
    private static final String TYPE = "\t/**\n\t * Relative <i>put</i> method for writing a VAL_TYPE.\n\t * <p>\n\t * Writes NUM_BYTES bytes containing the given VAL_TYPE value, in the current byte order,\n\t * into this buffer at the current position, and then increments the position by\n\t * NUM_BYTES.\n\t *\n\t * @param value The VAL_TYPE value to be written\n\t *\n\t * @return This buffer\n\t *\n\t * @throws BufferOverflowException If there are fewer than NUM_BYTES bytes remaining\n\t *                                 in this buffer\n\t */\n\tBigByteBuffer putFUNC_NAME(VAL_TYPE value);\n\n\t/**\n\t * Absolute <i>put</i> method for writing a VAL_TYPE.\n\t * <p>\n\t * Writes NUM_BYTES bytes containing the given VAL_TYPE value, in the current byte order,\n\t * into this buffer at the given index.\n\t *\n\t * @param index The index at which the bytes will be written\n\t *\n\t * @param value The VAL_TYPE value to be written\n\t *\n\t * @return This buffer\n\t *\n\t * @throws IndexOutOfBoundsException If {@code index} is negative or not smaller\n\t *                                   than the buffer's limit, minus one\n\t */\n\tBigByteBuffer putFUNC_NAME(long index, VAL_TYPE value);\n\n\t/**\n\t * Relative bulk <i>put</i> method\n\t * <p>\n\t * This method transfers the entire content of the given source VAL_TYPE array into\n\t * this buffer.\n\t *\n\t * @param src The source array\n\t *\n\t * @return This buffer\n\t *\n\t * @throws BufferOverflowException If there is insufficient space in this buffer\n\t */\n\tBigByteBuffer putFUNC_NAME(VAL_TYPE[] src);\n\n\t/**\n\t * Relative bulk <i>put</i> method\n\t * <p>\n\t * This method transfers the VAL_TYPEs remaining in the given source buffer into\n\t * this buffer. If there are more VAL_TYPEs remaining in the source buffer than in\n\t * this buffer, that is, if\n\t * {@code src.remaining()}&nbsp;{@code >}&nbsp;{@code remaining()}, then no\n\t * shorts are transferred and a {@link BufferOverflowException} is thrown.\n\t * <p>\n\t * Otherwise, this method copies <i>n</i>&nbsp;=&nbsp;{@code src.remaining()}\n\t * VAL_TYPEs from the given buffer into this buffer, starting at each buffer's\n\t * current position. The positions of both buffers are then incremented by\n\t * <i>n</i>.\n\t *\n\t * <p>\n\t * In other words, an invocation of this method of the form {@code dst.put(src)}\n\t * has exactly the same effect as the loop\n\t *\n\t * <pre>\n\t * while (src.hasRemaining())\n\t * \tdst.put(src.get());\n\t * </pre>\n\t *\n\t * except that it first checks that there is sufficient space in this buffer and\n\t * it is potentially much more efficient. If this buffer and the source buffer\n\t * share the same backing array or memory, then the result will be as if the\n\t * source elements were first copied to an intermediate location before being\n\t * written into this buffer.\n\t *\n\t * @param src The source buffer from which VAL_TYPEs are to be read; must not be\n\t *            this buffer\n\t *\n\t * @return This buffer\n\t *\n\t * @throws BufferOverflowException If there is insufficient space in this buffer\n\t *                                 for the remaining VAL_TYPEs in the source buffer\n\t */\n\tBigByteBuffer putFUNC_NAME(FUNC_NAMEBuffer src);\n\n\t/**\n\t * Relative <i>get</i> method for reading a VAL_TYPE value.\n\t *\n\t * <p>\n\t * Reads the next NUM_BYTES bytes at this buffer's current position, composing them\n\t * into a VAL_TYPE value according to the current byte order, and then increments\n\t * the position by NUM_BYTES.\n\t * </p>\n\t *\n\t * @return The VAL_TYPE value at the buffer's current position\n\t *\n\t * @throws BufferUnderflowException If there are fewer than NUM_BYTES bytes remaining\n\t *                                  in this buffer\n\t */\n\tVAL_TYPE getFUNC_NAME();\n\n\t/**\n\t * Absolute <i>get</i> method for reading a VAL_TYPE value.\n\t * <p>\n\t * Reads NUM_BYTES bytes at the given index, composing them into a VAL_TYPE value\n\t * according to the current byte order.\n\t *\n\t * @param index The index from which the bytes will be read\n\t *\n\t * @return The VAL_TYPE value at the given index\n\t *\n\t * @throws IndexOutOfBoundsException If {@code index} is negative or not smaller\n\t *                                   than the buffer's limit, minus one\n\t */\n\tVAL_TYPE getFUNC_NAME(long index);\n\n\t/**\n\t * Creates a view of this byte buffer as a VAL_TYPE buffer.\n\t * <p>\n\t * The content of the new buffer will start at this buffer's current position.\n\t * Changes to this buffer's content will be visible in the new buffer, and vice\n\t * versa; the two buffers' position and limit values will be independent.\n\t * <p>\n\t * The new buffer's position will be zero, its capacity and its limit will be\n\t * the number of bytes remaining in this buffer divided by NUM_BYTES, and its byte\n\t * order will be that of the byte buffer at the moment the view is created.\n\t *\n\t * @return A new VAL_TYPE buffer\n\t */\n\tdefault SmallFUNC_NAMEBuffer asFUNC_NAMEBuffer() {\n\t\treturn new SmallFUNC_NAMEBuffer(duplicate());\n\t}\n";
    private static final String PREFIX = "package tech.bitey.bufferstuff;\n\nimport java.io.InputStream;\nimport java.nio.BufferOverflowException;\nimport java.nio.BufferUnderflowException;\nimport java.nio.ByteBuffer;\nimport java.nio.ByteOrder;\nimport java.nio.DoubleBuffer;\nimport java.nio.FloatBuffer;\nimport java.nio.IntBuffer;\nimport java.nio.LongBuffer;\nimport java.nio.ShortBuffer;\n\n/**\n * This class has an API similar to {@link ByteBuffer}, but is addressable with\n * long indices. Implementations are backed by one or more {@code ByteBuffers}.\n * <p>\n * Differences from {@code ByteBuffer} include:\n * <ul>\n * <li>mark and reset are not supported\n * <li>read-only is not supported\n * <li>byte order is preserved in {@link #duplicate()} and {@link #slice()}.\n * </ul>\n *\n * biteytech@protonmail.com, adapted from {@link ByteBuffer}\n */\npublic sealed interface BigByteBuffer permits AbstractBigByteBuffer {\n\n\t/**\n\t * Returns the underlying {@link ByteBuffer buffers}.\n\t *\n\t * @return the underlying buffers.\n\t */\n\tByteBuffer[] buffers();\n\n\t/**\n\t * Returns this buffer's position.\n\t *\n\t * @return The position of this buffer\n\t */\n\tlong position();\n\n\t/**\n\t * Returns this buffer's limit.\n\t *\n\t * @return The limit of this buffer\n\t */\n\tlong limit();\n\n\t/**\n\t * Returns this buffer's capacity.\n\t *\n\t * @return The capacity of this buffer\n\t */\n\tlong capacity();\n\n\t/**\n\t * Sets this buffer's position.\n\t *\n\t * @param newPosition The new position value; must be non-negative and no larger\n\t *                    than the current limit\n\t *\n\t * @return this buffer\n\t *\n\t * @throws IllegalArgumentException If the preconditions on {@code newPosition}\n\t *                                  do not hold\n\t */\n\tBigByteBuffer position(long newPosition);\n\n\t/**\n\t * Sets this buffer's limit. If the position is larger than the new limit then\n\t * it is set to the new limit.\n\t *\n\t * @param newLimit The new limit value; must be non-negative and no larger than\n\t *                 this buffer's capacity\n\t *\n\t * @return this buffer\n\t *\n\t * @throws IllegalArgumentException If the preconditions on {@code newLimit} do\n\t *                                  not hold\n\t */\n\tBigByteBuffer limit(long newLimit);\n\n\t/**\n\t * Returns the number of bytes between the current position and the limit.\n\t *\n\t * @return The number of bytes remaining in this buffer\n\t */\n\tlong remaining();\n\n\t/**\n\t * Tells whether there are any bytes between the current position and the limit.\n\t *\n\t * @return {@code true} if, and only if, there is at least one byte remaining in\n\t *         this buffer\n\t */\n\tboolean hasRemaining();\n\n\t/**\n\t * Retrieves this buffer's byte order.\n\t *\n\t * <p>\n\t * The byte order is used when reading or writing multibyte values, and when\n\t * creating buffers that are views of this byte buffer. The order of a\n\t * newly-created byte buffer is always {@link ByteOrder#BIG_ENDIAN BIG_ENDIAN}.\n\t * </p>\n\t *\n\t * @return This buffer's byte order\n\t */\n\tByteOrder order();\n\n\t/**\n\t * Modifies this buffer's byte order.\n\t *\n\t * @param order The new byte order, either {@link ByteOrder#BIG_ENDIAN\n\t *              BIG_ENDIAN} or {@link ByteOrder#LITTLE_ENDIAN LITTLE_ENDIAN}\n\t *\n\t * @return this buffer\n\t */\n\tBigByteBuffer order(ByteOrder order);\n\n\t/**\n\t * Creates a new byte buffer that shares this buffer's content.\n\t * <p>\n\t * The content of the new buffer will be that of this buffer. Changes to this\n\t * buffer's content will be visible in the new buffer, and vice versa; the two\n\t * buffers' position and limit values will be independent.\n\t * <p>\n\t * The new buffer's capacity, limit, position, and byte order values will be\n\t * identical to those of this buffer. The new buffer will be direct if, and only\n\t * if, this buffer is direct.\n\t *\n\t * @return The new byte buffer\n\t */\n\tBigByteBuffer duplicate();\n\n\t/**\n\t * Creates a new byte buffer whose content is a shared subsequence of this\n\t * buffer's content.\n\t * <p>\n\t * The content of the new buffer will start at this buffer's current position.\n\t * Changes to this buffer's content will be visible in the new buffer, and vice\n\t * versa; the two buffers' position and limit values will be independent.\n\t * <p>\n\t * The new buffer's position will be zero, its capacity and its limit will be\n\t * the number of bytes remaining in this buffer, and the byte order will be the\n\t * same as this buffer. The new buffer will be direct if, and only if, this\n\t * buffer is direct.\n\t *\n\t * @return The new byte buffer\n\t */\n\tBigByteBuffer slice();\n\n\t/**\n\t * Creates a new byte buffer whose content is a shared subsequence of this\n\t * buffer's content.\n\t *\n\t * @return The new byte buffer\n\t */\n    BigByteBuffer slice(long fromIndex, long toIndex);\n\n\t/**\n\t * Creates a new {@link ByteBuffer} whose content is a shared subsequence of this\n\t * buffer's content.\n\t * <p>\n\t * The content of the new buffer will start at this buffer's current position.\n\t * Changes to this buffer's content will be visible in the new buffer, and vice\n\t * versa; the two buffers' position and limit values will be independent.\n\t * <p>\n\t * The new buffer's position will be zero, its capacity and its limit will be\n\t * the number of bytes remaining in this buffer, and the byte order will be the\n\t * same as this buffer. The new buffer will be direct if, and only if, this\n\t * buffer is direct.\n\t *\n\t * @return The new byte buffer\n\t */\n    ByteBuffer smallSlice();\n\n\t/**\n\t * Creates a new {@link ByteBuffer} whose content is a shared subsequence of this\n\t * buffer's content.\n\t *\n\t * @return The new byte buffer\n\t */\n    ByteBuffer smallSlice(long fromIndex, long toIndex);\n\n\t/**\n\t * Returns a copy of a range from this buffer.\n\t *\n\t * @return a copy of a range from this buffer.\n\t */\n    BigByteBuffer copy(long fromIndex, long toIndex);\n\n\t/**\n\t * Clears this buffer. The position is set to zero and the limit is set to the\n\t * capacity.\n\t * <p>\n\t * This method does not actually erase the data in the buffer, but it is named\n\t * as if it did because it will most often be used in situations in which that\n\t * might as well be the case.\n\t *\n\t * @return This buffer\n\t */\n\tBigByteBuffer clear();\n\n\t/**\n\t * Flips this buffer. The limit is set to the current position and then the\n\t * position is set to zero.\n\t *\n\t * @return This buffer\n\t */\n\tBigByteBuffer flip();\n\n\t/**\n\t * Relative <i>put</i> method.\n\t * <p>\n\t * Writes the given byte into this buffer at the current position, and then\n\t * increments the position.\n\t *\n\t * @param value The byte to be written\n\t *\n\t * @return This buffer\n\t *\n\t * @throws BufferOverflowException If this buffer's current position is not\n\t *                                 smaller than its limit\n\t */\n\tBigByteBuffer put(byte value);\n\n\t/**\n\t * Absolute <i>put</i> method.\n\t * <p>\n\t * Writes the given byte into this buffer at the given index.\n\t *\n\t * @param index The index at which the byte will be written\n\t *\n\t * @param value The byte value to be written\n\t *\n\t * @return This buffer\n\t *\n\t * @throws IndexOutOfBoundsException If {@code index} is negative or not smaller\n\t *                                   than the buffer's limit\n\t */\n\tBigByteBuffer put(long index, byte value);\n\n\t/**\n\t * Relative bulk <i>put</i> method\n\t * <p>\n\t * This method transfers the bytes remaining in the given source buffer into\n\t * this buffer. If there are more bytes remaining in the source buffer than in\n\t * this buffer, that is, if\n\t * {@code src.remaining()}&nbsp;{@code >}&nbsp;{@code remaining()}, then no\n\t * bytes are transferred and a {@link BufferOverflowException} is thrown.\n\t * <p>\n\t * Otherwise, this method copies <i>n</i>&nbsp;=&nbsp;{@code src.remaining()}\n\t * bytes from the given buffer into this buffer, starting at each buffer's\n\t * current position. The positions of both buffers are then incremented by\n\t * <i>n</i>.\n\t *\n\t * <p>\n\t * In other words, an invocation of this method of the form {@code dst.put(src)}\n\t * has exactly the same effect as the loop\n\t *\n\t * <pre>\n\t * while (src.hasRemaining())\n\t * \tdst.put(src.get());\n\t * </pre>\n\t *\n\t * except that it first checks that there is sufficient space in this buffer and\n\t * it is potentially much more efficient. If this buffer and the source buffer\n\t * share the same backing array or memory, then the result will be as if the\n\t * source elements were first copied to an intermediate location before being\n\t * written into this buffer.\n\t *\n\t * @param src The source buffer from which bytes are to be read; must not be\n\t *            this buffer\n\t *\n\t * @return This buffer\n\t *\n\t * @throws BufferOverflowException  If there is insufficient space in this\n\t *                                  buffer for the remaining bytes in the source\n\t *                                  buffer\n\t *\n\t * @throws IllegalArgumentException If the source buffer is this buffer\n\t */\n\tBigByteBuffer put(BigByteBuffer src);\n\n\t/**\n\t * Relative bulk <i>put</i> method\n\t * <p>\n\t * This method transfers the bytes remaining in the given source buffer into\n\t * this buffer. If there are more bytes remaining in the source buffer than in\n\t * this buffer, that is, if\n\t * {@code src.remaining()}&nbsp;{@code >}&nbsp;{@code remaining()}, then no\n\t * shorts are transferred and a {@link BufferOverflowException} is thrown.\n\t * <p>\n\t * Otherwise, this method copies <i>n</i>&nbsp;=&nbsp;{@code src.remaining()}\n\t * doubles from the given buffer into this buffer, starting at each buffer's\n\t * current position. The positions of both buffers are then incremented by\n\t * <i>n</i>.\n\t *\n\t * <p>\n\t * In other words, an invocation of this method of the form {@code dst.put(src)}\n\t * has exactly the same effect as the loop\n\t *\n\t * <pre>\n\t * while (src.hasRemaining())\n\t * \tdst.put(src.get());\n\t * </pre>\n\t *\n\t * except that it first checks that there is sufficient space in this buffer and\n\t * it is potentially much more efficient. If this buffer and the source buffer\n\t * share the same backing array or memory, then the result will be as if the\n\t * source elements were first copied to an intermediate location before being\n\t * written into this buffer.\n\t *\n\t * @param src The source buffer from which bytes are to be read; must not be\n\t *            this buffer\n\t *\n\t * @return This buffer\n\t *\n\t * @throws BufferOverflowException If there is insufficient space in this buffer\n\t *                                 for the remaining bytes in the source buffer\n\t */\n    BigByteBuffer put(ByteBuffer src);\n\n\t/**\n\t * Relative bulk <i>put</i> method\n\t * <p>\n\t * This method transfers the entire content of the given source byte array into\n\t * this buffer.\n\t *\n\t * @param src The source array\n\t *\n\t * @return This buffer\n\t *\n\t * @throws BufferOverflowException If there is insufficient space in this buffer\n\t */\n\tBigByteBuffer put(byte[] src);\n\n\t/**\n\t * Absolute bulk <i>put</i> method.\n\t *\n\t * <p>\n\t * This method transfers {@code length} bytes into this buffer from the given\n\t * source buffer, starting at the given {@code offset} in the source buffer and\n\t * the given {@code index} in this buffer. The positions of both buffers are\n\t * unchanged.\n\t *\n\t * <p>\n\t * In other words, an invocation of this method of the form\n\t * <code>dst.put(index,&nbsp;src,&nbsp;offset,&nbsp;length)</code> has exactly\n\t * the same effect as the loop\n\t *\n\t * <pre>{@code\n\t * for (int i = offset, j = index; i < offset + length; i++, j++)\n\t * \tdst.put(j, src.get(i));\n\t * }</pre>\n\t *\n\t * except that it first checks the consistency of the supplied parameters and it\n\t * is potentially much more efficient. If this buffer and the source buffer\n\t * share the same backing array or memory, then the result will be as if the\n\t * source elements were first copied to an intermediate location before being\n\t * written into this buffer.\n\t *\n\t * @param index  The index in this buffer at which the first byte will be\n\t *               written; must be non-negative and less than {@code limit()}\n\t *\n\t * @param src    The buffer from which bytes are to be read\n\t *\n\t * @param offset The index within the source buffer of the first byte to be\n\t *               read; must be non-negative and less than {@code src.limit()}\n\t *\n\t * @param length The number of bytes to be read from the given buffer; must be\n\t *               non-negative and no larger than the smaller of\n\t *               {@code limit() - index} and {@code src.limit() - offset}\n\t *\n\t * @return This buffer\n\t *\n\t * @throws IndexOutOfBoundsException If the preconditions on the {@code index},\n\t *                                   {@code offset}, and {@code length}\n\t *                                   parameters do not hold\n\t */\n\tBigByteBuffer put(long index, ByteBuffer src, int offset, int length);\n\n\t/**\n\t * Relative <i>get</i> method. Reads the byte at this buffer's current position,\n\t * and then increments the position.\n\t *\n\t * @return The byte at the buffer's current position\n\t *\n\t * @throws BufferUnderflowException If the buffer's current position is not\n\t *                                  smaller than its limit\n\t */\n\tbyte get();\n\n\t/**\n\t * Absolute <i>get</i> method. Reads the byte at the given index.\n\t *\n\t * @param index The index from which the byte will be read\n\t *\n\t * @return The byte at the given index\n\t *\n\t * @throws IndexOutOfBoundsException If {@code index} is negative or not smaller\n\t *                                   than the buffer's limit\n\t */\n\tbyte get(long index);\n\n\t/**\n\t * Relative bulk <i>get</i> method.\n\t *\n\t * <p> This method transfers bytes from this buffer into the given\n\t * destination array.  If there are fewer bytes remaining in the\n\t * buffer than are required to satisfy the request, that is, if\n\t * {@code length}&nbsp;{@code >}&nbsp;{@code remaining()}, then no\n\t * bytes are transferred and a {@link BufferUnderflowException} is\n\t * thrown.\n\t *\n\t * <p> Otherwise, this method copies {@code length} bytes from this\n\t * buffer into the given array, starting at the current position of this\n\t * buffer and at the given offset in the array.  The position of this\n\t * buffer is then incremented by {@code length}.\n\t *\n\t * <p> In other words, an invocation of this method of the form\n\t * <code>src.get(dst,&nbsp;off,&nbsp;len)</code> has exactly the same effect as\n\t * the loop\n\t *\n\t * <pre>{@code\n\t *     for (int i = off; i < off + len; i++)\n\t *         dst[i] = src.get();\n\t * }</pre>\n\t *\n\t * except that it first checks that there are sufficient bytes in\n\t * this buffer and it is potentially much more efficient.\n\t *\n\t * @param  dst\n\t *         The array into which bytes are to be written\n\t *\n\t * @param  offset\n\t *         The offset within the array of the first byte to be\n\t *         written; must be non-negative and no larger than\n\t *         {@code dst.length}\n\t *\n\t * @param  length\n\t *         The maximum number of bytes to be written to the given\n\t *         array; must be non-negative and no larger than\n\t *         {@code dst.length - offset}\n\t *\n\t * @return  This buffer\n\t *\n\t * @throws  BufferUnderflowException\n\t *          If there are fewer than {@code length} bytes\n\t *          remaining in this buffer\n\t *\n\t * @throws  IndexOutOfBoundsException\n\t *          If the preconditions on the {@code offset} and {@code length}\n\t *          parameters do not hold\n\t */\n\tBigByteBuffer get(byte[] dst, int offset, int length);\n\n\t/**\n\t * Relative bulk <i>get</i> method.\n\t *\n\t * <p> This method transfers bytes from this buffer into the given\n\t * destination array.  An invocation of this method of the form\n\t * {@code src.get(a)} behaves in exactly the same way as the invocation\n\t *\n\t * <pre>\n\t *     src.get(a, 0, a.length) </pre>\n\t *\n\t * @param   dst\n\t *          The destination array\n\t *\n\t * @return  This buffer\n\t *\n\t * @throws  BufferUnderflowException\n\t *          If there are fewer than {@code length} bytes\n\t *          remaining in this buffer\n\t */\n\tdefault BigByteBuffer get(byte[] dst) {\n\t\treturn get(dst, 0, dst.length);\n\t}\n\n\t/**\n\t * Creates a view of this byte buffer as a byte buffer.\n\t * <p>\n\t * The content of the new buffer will start at this buffer's current position.\n\t * Changes to this buffer's content will be visible in the new buffer, and vice\n\t * versa; the two buffers' position and limit values will be independent.\n\t * <p>\n\t * The new buffer's position will be zero, its capacity and its limit will be\n\t * the number of bytes remaining in this buffer, and its byte\n\t * order will be that of the byte buffer at the moment the view is created.\n\t *\n\t * @return A new byte buffer\n\t */\n\tdefault SmallByteBuffer asByteBuffer() {\n\t\treturn new SmallByteBuffer(duplicate());\n\t}\n\n\t/**\n\t * Creates a new {@link InputStream} which streams this buffer's content.\n\t * <p>\n\t * The stream will start at this buffer's current position, and end at this buffer's limit.\n\t *\n\t * @return the new {@code InputStream}\n\t */\n\tInputStream toInputStream();\n";

    @Override
    public void run() throws Exception {
        try (BufferedWriter out = this.open("BigByteBuffer.java");){
            this.section(out, PREFIX);
            this.section(out, GenBigByteBuffer.type("short", "Short", "two"));
            this.section(out, GenBigByteBuffer.type("int", "Int", "four"));
            this.section(out, GenBigByteBuffer.type("long", "Long", "eight"));
            this.section(out, GenBigByteBuffer.type("float", "Float", "four"));
            this.section(out, GenBigByteBuffer.type("double", "Double", "eight"));
            out.write("}\n");
        }
    }

    private static String type(String valType, String funcName, String numBytes) {
        return TYPE.replace(VAL_TYPE, valType).replace(FUNC_NAME, funcName).replace(NUM_BYTES, numBytes);
    }
}

