/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff.codegen;

import java.io.BufferedWriter;
import tech.bitey.bufferstuff.codegen.GenBufferCode;

public class GenBufferSort
implements GenBufferCode {
    private static final String BUFFER_TYPE = "BUFFER_TYPE";
    private static final String VAL_TYPE = "VAL_TYPE";
    private static final String COMPARE = "COMPARE";
    private static final String COMPARE_L = "COMPARE_L";
    private static final String COMPARE_R = "COMPARE_R";
    private static final String HIGH_BIT_NAME = "HIGH_BIT_NAME";
    private static final String BOX_TYPE = "BOX_TYPE";
    private static final String COUNTING_BITS = "COUNTING_BITS";
    private static final String COUNTING_MASK = "COUNTING_MASK";
    private static final String HEAP_RANGE_COMMENT = "HEAP_RANGE_COMMENT";
    private static final String HEAP_RANGE = "HEAP_RANGE";
    private static final String INSERTION_HEAP = "\t/**\n\t * Sorts a range of the specified {@link BUFFER_TYPE} in ascending order\n\t * (lowest first). The actual sorting algorithm used depends on the length of\n\t * the range:\n\t * <table border=1 summary=\"Sorting algorithm by array length\">\n\t * <tr>\n\t * <th>Length</th>\n\t * <th>Algorithm</th>\n\t * </tr>\n\t * <tr>\n\t * <td>{@code [0 - 100)}</td>\n\t * <td>{@link BufferSort#insertionSort(BUFFER_TYPE, int, int)\n\t * insertionSort}</td>\n\t * </tr>\n\t * <tr>\n\t * <td>{@code 100+}</td>\n\t * <td>{@link BufferSort#heapSort(BUFFER_TYPE, int, int) heapSort}</td>\n\t * </tr>\n\t * </table>\n\t *\n\t * @param b         the buffer to be sorted\n\t * @param fromIndex the index of the first element (inclusive) to be sorted\n\t * @param toIndex   the index of the last element (exclusive) to be sorted\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static void sort(BUFFER_TYPE b, int fromIndex, int toIndex) {\n\n\t\tfinal int length = toIndex - fromIndex;\n\n\t\tif (length < SMALL_RANGE)\n\t\t\tinsertionSort(b, fromIndex, toIndex);\n\t\telse\n\t\t\theapSort(b, fromIndex, toIndex);\n\t}\n";
    private static final String INSERTION_HEAP_COUNTING = "\t/**\n\t * Sorts a range of the specified {@link BUFFER_TYPE} in ascending order (lowest\n\t * first). The actual sorting algorithm used depends on the length of the range:\n\t * <table border=1 summary=\"Sorting algorithm by array length\">\n\t * <tr>\n\t * <th>Length</th>\n\t * <th>Algorithm</th>\n\t * </tr>\n\t * <tr>\n\t * <td>{@code [0 - 100)}</td>\n\t * <td>{@link BufferSort#insertionSort(BUFFER_TYPE, int, int)\n\t * insertionSort}</td>\n\t * </tr>\n\t * <tr>\n\t * <td>{@code [100 - HEAP_RANGE_COMMENT)}</td>\n\t * <td>{@link BufferSort#heapSort(BUFFER_TYPE, int, int) heapSort}</td>\n\t * </tr>\n\t * <tr>\n\t * <td>{@code HEAP_RANGE_COMMENT+}</td>\n\t * <td>{@link BufferSort#countingSort(BUFFER_TYPE, int, int) countingSort}</td>\n\t * </tr>\n\t * </table>\n\t *\n\t * @param b         the buffer to be sorted\n\t * @param fromIndex the index of the first element (inclusive) to be sorted\n\t * @param toIndex   the index of the last element (exclusive) to be sorted\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static void sort(BUFFER_TYPE b, int fromIndex, int toIndex) {\n\n\t\tfinal int length = toIndex - fromIndex;\n\n\t\tif (length < SMALL_RANGE)\n\t\t\tinsertionSort(b, fromIndex, toIndex);\n\t\telse if (length < HEAP_RANGE)\n\t\t\theapSort(b, fromIndex, toIndex);\n\t\telse\n\t\t\tcountingSort(b, fromIndex, toIndex);\n\t}\n";
    private static final String INSERTION_HEAP_RADIX = "\t/**\n\t * Sorts a range of the specified {@link BUFFER_TYPE} in ascending order (lowest\n\t * first). The actual sorting algorithm used depends on the length of the range:\n\t * <table border=1 summary=\"Sorting algorithm by array length\">\n\t * <tr>\n\t * <th>Length</th>\n\t * <th>Algorithm</th>\n\t * </tr>\n\t * <tr>\n\t * <td>{@code [0 - 100)}</td>\n\t * <td>{@link BufferSort#insertionSort(BUFFER_TYPE, int, int) insertionSort}</td>\n\t * </tr>\n\t * <tr>\n\t * <td>{@code [100 - 10^7)}</td>\n\t * <td>{@link BufferSort#heapSort(BUFFER_TYPE, int, int) heapSort}</td>\n\t * </tr>\n\t * <tr>\n\t * <td>{@code 10^7+}</td>\n\t * <td>{@link BufferSort#radixSort(BUFFER_TYPE, int, int) radixSort}</td>\n\t * </tr>\n\t * </table>\n\t *\n\t * @param b         the buffer to be sorted\n\t * @param fromIndex the index of the first element (inclusive) to be sorted\n\t * @param toIndex   the index of the last element (exclusive) to be sorted\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static void sort(BUFFER_TYPE b, int fromIndex, int toIndex) {\n\n\t\tfinal int length = toIndex - fromIndex;\n\n\t\tif (length < SMALL_RANGE)\n\t\t\tinsertionSort(b, fromIndex, toIndex);\n\t\telse if (length < LARGE_RANGE)\n\t\t\theapSort(b, fromIndex, toIndex);\n\t\telse\n\t\t\tradixSort(b, fromIndex, toIndex);\n\t}\n";
    private static final String INSERTION_SORT = "\t/**\n\t * Sorts a range of the specified {@link BUFFER_TYPE} in ascending order (lowest\n\t * first). The sort is:\n\t * <ul>\n\t * <li>in-place\n\t * <li>{@code O(n^2)} in the worst case. However, insertion sort has less\n\t * overhead than heat sort, and is faster for small ranges.\n\t * </ul>\n\t *\n\t * @param b         the buffer to be sorted\n\t * @param fromIndex the index of the first element (inclusive) to be sorted\n\t * @param toIndex   the index of the last element (exclusive) to be sorted\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static void insertionSort(BUFFER_TYPE b, int fromIndex, int toIndex) {\n\t\trangeCheck(b.capacity(), fromIndex, toIndex);\n\n\t\tfor (int i = fromIndex + 1; i < toIndex; i++) {\n\t\t\tVAL_TYPE x = b.get(i);\n\t\t\tint j = i - 1;\n\t\t\tfor (VAL_TYPE xj; j >= fromIndex && COMPARE; j--)\n\t\t\t\tb.put(j + 1, xj);\n\t\t\tb.put(j + 1, x);\n\t\t}\n\t}\n";
    private static final String COUNTING_SORT = "\t/**\n\t * Sorts a range of the specified {@link BUFFER_TYPE} in ascending order (lowest\n\t * first). This sort is {@code O(n)} in the worst case, but it creates and\n\t * iterates over an {@code int} array of length 2^COUNTING_BITS.\n\t *\n\t * @param b         the buffer to be sorted\n\t * @param fromIndex the index of the first element (inclusive) to be sorted\n\t * @param toIndex   the index of the last element (exclusive) to be sorted\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static void countingSort(BUFFER_TYPE b, int fromIndex, int toIndex) {\n\t\trangeCheck(b.capacity(), fromIndex, toIndex);\n\n\t\tint[] counts = new int[1 << COUNTING_BITS];\n\n\t\tfor (int i = fromIndex; i < toIndex; i++)\n\t\t\tcounts[b.get(i) & COUNTING_MASK]++;\n\n\t\tint k = fromIndex;\n\n\t\t// negative values\n\t\tfor (int i = BOX_TYPE.MAX_VALUE + 1; i < counts.length; i++) {\n\t\t\tVAL_TYPE s = (VAL_TYPE) i;\n\t\t\tfor (int j = 0; j < counts[i]; j++)\n\t\t\t\tb.put(k++, s);\n\t\t}\n\n\t\t// positive values\n\t\tfor (int i = 0; i <= BOX_TYPE.MAX_VALUE; i++) {\n\t\t\tVAL_TYPE s = (VAL_TYPE) i;\n\t\t\tfor (int j = 0; j < counts[i]; j++)\n\t\t\t\tb.put(k++, s);\n\t\t}\n\t}\n";
    private static final String RADIX_SORT = "\t/**\n\t * Sorts a range of the specified {@link BUFFER_TYPE} in ascending order (lowest\n\t * first). The sort is:\n\t * <ul>\n\t * <li>in-place\n\t * <li>{@code O(n)} in the worst case. However, radix sort has more overhead\n\t * than heat sort, and is only faster for large ranges.\n\t * </ul>\n\t *\n\t * @param b         the buffer to be sorted\n\t * @param fromIndex the index of the first element (inclusive) to be sorted\n\t * @param toIndex   the index of the last element (exclusive) to be sorted\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static void radixSort(BUFFER_TYPE b, int fromIndex, int toIndex) {\n\t\trangeCheck(b.capacity(), fromIndex, toIndex);\n\t\tradixSort0(b, fromIndex, toIndex, HIGH_BIT_NAME);\n\t}\n\n\tprivate static void radixSort0(BUFFER_TYPE b, int fromIndex, int toIndex, VAL_TYPE bit) {\n\n\t\tint zero = fromIndex;\n\t\tint one = toIndex;\n\n\t\tfinal VAL_TYPE direction = bit == HIGH_BIT_NAME ? bit : 0;\n\n\t\twhile (zero < one) {\n\t\t\tif ((b.get(zero) & bit) == direction)\n\t\t\t\tzero++;\n\t\t\telse\n\t\t\t\tswap(b, zero, --one);\n\t\t}\n\n\t\tif (bit != 1) {\n\t\t\tif (fromIndex < zero)\n\t\t\t\tradixSort0(b, fromIndex, zero, bit >>> 1);\n\t\t\tif (one < toIndex)\n\t\t\t\tradixSort0(b, one, toIndex, bit >>> 1);\n\t\t}\n\t}\n";
    private static final String HEAP_SORT_COMP = "\t/**\n\t * Sorts a range of the specified {@link IntBuffer} in ascending order (lowest\n\t * first). The sort is:\n\t * <ul>\n\t * <li>in-place\n\t * <li>{@code O(n*log(n))} in the worst case\n\t * <li>a good general-purpose sorting algorithm\n\t * </ul>\n\t *\n\t * @param b          the buffer to be sorted\n\t * @param comparator used to compare values from {@code b}. useful when the\n\t *                   integers are identifiers or indices referencing some\n\t *                   external data structure.\n\t * @param fromIndex  the index of the first element (inclusive) to be sorted\n\t * @param toIndex    the index of the last element (exclusive) to be sorted\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static void heapSort(IntBuffer b, IntBinaryOperator comparator, int fromIndex, int toIndex) {\n\t\trangeCheck(b.capacity(), fromIndex, toIndex);\n\n\t\tint n = toIndex - fromIndex;\n\t\tif (n <= 1)\n\t\t\treturn;\n\n\t\t// Build max heap\n\t\tfor (int i = fromIndex + n / 2 - 1; i >= fromIndex; i--)\n\t\t\theapify(b, comparator, toIndex, i, fromIndex);\n\n\t\t// Heap sort\n\t\tfor (int i = toIndex - 1; i >= fromIndex; i--) {\n\t\t\tswap(b, fromIndex, i);\n\n\t\t\t// Heapify root element\n\t\t\theapify(b, comparator, i, fromIndex, fromIndex);\n\t\t}\n\t}\n\n\t// based on https://www.programiz.com/dsa/heap-sort\n\tprivate static void heapify(IntBuffer b, IntBinaryOperator comparator, int n, int i, int offset) {\n\t\t// Find largest among root, left child and right child\n\t\tint largest = i;\n\t\tint l = 2 * i + 1 - offset;\n\t\tint r = l + 1;\n\n\t\tif (l < n && comparator.applyAsInt(b.get(l), b.get(largest)) > 0)\n\t\t\tlargest = l;\n\n\t\tif (r < n && comparator.applyAsInt(b.get(r), b.get(largest)) > 0)\n\t\t\tlargest = r;\n\n\t\t// Swap and continue heapifying if root is not largest\n\t\tif (largest != i) {\n\t\t\tswap(b, i, largest);\n\t\t\theapify(b, comparator, n, largest, offset);\n\t\t}\n\t}\n";
    private static final String HEAP_SORT = "\t/**\n\t * Sorts a range of the specified {@link BUFFER_TYPE} in ascending order (lowest\n\t * first). The sort is:\n\t * <ul>\n\t * <li>in-place\n\t * <li>{@code O(n*log(n))} in the worst case\n\t * <li>a good general-purpose sorting algorithm\n\t * </ul>\n\t *\n\t * @param b         the buffer to be sorted\n\t * @param fromIndex the index of the first element (inclusive) to be sorted\n\t * @param toIndex   the index of the last element (exclusive) to be sorted\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static void heapSort(BUFFER_TYPE b, int fromIndex, int toIndex) {\n\t\trangeCheck(b.capacity(), fromIndex, toIndex);\n\n\t\tint n = toIndex - fromIndex;\n\t\tif (n <= 1)\n\t\t\treturn;\n\n\t\t// Build max heap\n\t\tfor (int i = fromIndex + n / 2 - 1; i >= fromIndex; i--)\n\t\t\theapify(b, toIndex, i, fromIndex);\n\n\t\t// Heap sort\n\t\tfor (int i = toIndex - 1; i >= fromIndex; i--) {\n\t\t\tswap(b, fromIndex, i);\n\n\t\t\t// Heapify root element\n\t\t\theapify(b, i, fromIndex, fromIndex);\n\t\t}\n\t}\n\n\t// based on https://www.programiz.com/dsa/heap-sort\n\tprivate static void heapify(BUFFER_TYPE b, int n, int i, int offset) {\n\t\t// Find largest among root, left child and right child\n\t\tint largest = i;\n\t\tint l = 2 * i + 1 - offset;\n\t\tint r = l + 1;\n\n\t\tif (l < n && COMPARE_L)\n\t\t\tlargest = l;\n\n\t\tif (r < n && COMPARE_R)\n\t\t\tlargest = r;\n\n\t\t// Swap and continue heapifying if root is not largest\n\t\tif (largest != i) {\n\t\t\tswap(b, i, largest);\n\t\t\theapify(b, n, largest, offset);\n\t\t}\n\t}\n\n\tprivate static void swap(BUFFER_TYPE b, int i, int j) {\n\t\tVAL_TYPE swap = b.get(i);\n\t\tb.put(i, b.get(j));\n\t\tb.put(j, swap);\n\t}\n";
    private static final String PREFIX = "package tech.bitey.bufferstuff;\n\nimport static tech.bitey.bufferstuff.BufferUtils.rangeCheck;\n\nimport java.nio.ByteBuffer;\nimport java.nio.DoubleBuffer;\nimport java.nio.FloatBuffer;\nimport java.nio.IntBuffer;\nimport java.nio.LongBuffer;\nimport java.nio.ShortBuffer;\nimport java.util.function.IntBinaryOperator;\n\n/**\n * Sorting algorithms for nio buffers.\n *\n * @author biteytech@protonmail.com, heap-sort adapted from <a\n *         href=https://www.programiz.com/dsa/heap-sort>programiz.com</a>\n */\npublic class BufferSort {\n\n\tprivate static final int SMALL_RANGE = 100;\n\tprivate static final int LARGE_RANGE = 10_000_000;\n\n\tprivate static final int INT_HIGH_BIT = 1 << 31;\n\tprivate static final long LONG_HIGH_BIT = 1L << 63;\n";

    @Override
    public void run() throws Exception {
        try (BufferedWriter out = this.open("BufferSort.java");){
            this.section(out, PREFIX);
            this.sections(out, false);
            this.sections(out, true);
            out.write("}\n");
        }
    }

    private void sections(BufferedWriter out, boolean small) throws Exception {
        String s = small ? "Small" : "";
        this.section(out, GenBufferSort.heapSort("int", s + "IntBuffer", "b.get(l) > b.get(largest)", "b.get(r) > b.get(largest)"));
        if (small) {
            this.section(out, HEAP_SORT_COMP.replace("IntBuffer", "SmallIntBuffer"));
        } else {
            this.section(out, HEAP_SORT_COMP);
        }
        this.section(out, GenBufferSort.heapSort("long", s + "LongBuffer", "b.get(l) > b.get(largest)", "b.get(r) > b.get(largest)"));
        this.section(out, GenBufferSort.heapSort("short", s + "ShortBuffer", "b.get(l) > b.get(largest)", "b.get(r) > b.get(largest)"));
        this.section(out, GenBufferSort.heapSort("byte", s + "ByteBuffer", "b.get(l) > b.get(largest)", "b.get(r) > b.get(largest)"));
        this.section(out, GenBufferSort.heapSort("float", s + "FloatBuffer", "Float.compare(b.get(l), b.get(largest)) > 0", "Float.compare(b.get(r), b.get(largest)) > 0"));
        this.section(out, GenBufferSort.heapSort("double", s + "DoubleBuffer", "Double.compare(b.get(l), b.get(largest)) > 0", "Double.compare(b.get(r), b.get(largest)) > 0"));
        this.section(out, GenBufferSort.radixSort("int", s + "IntBuffer", "INT_HIGH_BIT"));
        this.section(out, GenBufferSort.radixSort("long", s + "LongBuffer", "LONG_HIGH_BIT"));
        this.section(out, GenBufferSort.countingSort("short", s + "ShortBuffer", "Short", 16, "0xFFFF"));
        this.section(out, GenBufferSort.countingSort("byte", s + "ByteBuffer", "Byte", 8, "0xFF"));
        this.section(out, GenBufferSort.insertionSort("int", s + "IntBuffer", "(xj = b.get(j)) > x"));
        this.section(out, GenBufferSort.insertionSort("long", s + "LongBuffer", "(xj = b.get(j)) > x"));
        this.section(out, GenBufferSort.insertionSort("short", s + "ShortBuffer", "(xj = b.get(j)) > x"));
        this.section(out, GenBufferSort.insertionSort("byte", s + "ByteBuffer", "(xj = b.get(j)) > x"));
        this.section(out, GenBufferSort.insertionSort("float", s + "FloatBuffer", "Float.compare(xj = b.get(j), x) > 0"));
        this.section(out, GenBufferSort.insertionSort("double", s + "DoubleBuffer", "Double.compare(xj = b.get(j), x) > 0"));
        this.section(out, GenBufferSort.insertionHeapRadix(s + "IntBuffer"));
        this.section(out, GenBufferSort.insertionHeapRadix(s + "LongBuffer"));
        this.section(out, GenBufferSort.insertionHeapCounting(s + "ShortBuffer", "10^7", "LARGE_RANGE"));
        this.section(out, GenBufferSort.insertionHeapCounting(s + "ByteBuffer", "10^5", "100000"));
        this.section(out, GenBufferSort.insertionHeap(s + "FloatBuffer"));
        this.section(out, GenBufferSort.insertionHeap(s + "DoubleBuffer"));
    }

    private static String heapSort(String valType, String bufferType, String compareL, String compareR) {
        return HEAP_SORT.replace(VAL_TYPE, valType).replace(BUFFER_TYPE, bufferType).replace(COMPARE_L, compareL).replace(COMPARE_R, compareR);
    }

    private static String radixSort(String valType, String bufferType, String highBitName) {
        return RADIX_SORT.replace(VAL_TYPE, valType).replace(BUFFER_TYPE, bufferType).replace(HIGH_BIT_NAME, highBitName);
    }

    private static String countingSort(String valType, String bufferType, String boxType, int bits, String mask) {
        return COUNTING_SORT.replace(VAL_TYPE, valType).replace(BUFFER_TYPE, bufferType).replace(BOX_TYPE, boxType).replace(COUNTING_BITS, "" + bits).replace(COUNTING_MASK, mask);
    }

    private static String insertionSort(String valType, String bufferType, String compare) {
        return INSERTION_SORT.replace(VAL_TYPE, valType).replace(BUFFER_TYPE, bufferType).replace(COMPARE, compare);
    }

    private static String insertionHeapRadix(String bufferType) {
        return INSERTION_HEAP_RADIX.replace(BUFFER_TYPE, bufferType);
    }

    private static String insertionHeapCounting(String bufferType, String comment, String range) {
        return INSERTION_HEAP_COUNTING.replace(BUFFER_TYPE, bufferType).replace(HEAP_RANGE_COMMENT, comment).replace(HEAP_RANGE, range);
    }

    private static String insertionHeap(String bufferType) {
        return INSERTION_HEAP.replace(BUFFER_TYPE, bufferType);
    }
}

