/*
 * Decompiled with CFR 0.152.
 */
package tech.bitey.bufferstuff.codegen;

import java.io.BufferedWriter;
import tech.bitey.bufferstuff.codegen.GenBufferCode;

public class GenBufferUtils
implements GenBufferCode {
    private static final String BUFFER_TYPE = "BUFFER_TYPE";
    private static final String VAL_TYPE = "VAL_TYPE";
    private static final String VAL_SIZE = "VAL_SIZE";
    private static final String COMPARE = "COMPARE";
    private static final String STREAM_TYPE = "STREAM_TYPE";
    private static final String STREAM = "\t/**\n\t * Returns a sequential {@link STREAM_TYPE} with the specified buffer as its\n\t * source.\n\t * <p>\n\t * <b>Note:</b> ignores {@link BUFFER_TYPE#position() position} and\n\t * {@link BUFFER_TYPE#limit() limit}, can pass a {@link BUFFER_TYPE#slice() slice}\n\t * instead.\n\t *\n\t * @param buffer the buffer, assumed to be unmodified during use\n\t * @return an {@code STREAM_TYPE} for the buffer\n\t */\n\tpublic static STREAM_TYPE stream(BUFFER_TYPE buffer) {\n\t\treturn stream(buffer, 0, buffer.capacity(), 0);\n\t}\n\n\t/**\n\t * Returns a sequential {@link STREAM_TYPE} with the specified range of the\n\t * specified buffer as its source.\n\t *\n\t * @param buffer          the buffer, assumed to be unmodified during use\n\t * @param startInclusive  the first index to cover, inclusive\n\t * @param endExclusive    index immediately past the last index to cover\n\t * @param characteristics characteristics of this spliterator's source or\n\t *                        elements beyond {@code SIZED}, {@code SUBSIZED},\n\t *                        {@code ORDERED}, {@code NONNULL}, and\n\t *                        {@code IMMUTABLE}, which are are always reported\n\t * @return an {@code STREAM_TYPE} for the buffer range\n\t * @throws ArrayIndexOutOfBoundsException if {@code startInclusive} is negative,\n\t *                                        {@code endExclusive} is less than\n\t *                                        {@code startInclusive}, or\n\t *                                        {@code endExclusive} is greater than\n\t *                                        the buffer's\n\t *                                        {@link BUFFER_TYPE#capacity() capacity}\n\t */\n\tpublic static STREAM_TYPE stream(BUFFER_TYPE buffer, int startInclusive, int endExclusive, int characteristics) {\n\t\treturn StreamSupport.VAL_TYPEStream(new BufferSpliterators.BUFFER_TYPESpliterator(buffer, startInclusive, endExclusive,\n\t\t\t\tcharacteristics | ORDERED | NONNULL | IMMUTABLE), false);\n\t}\n";
    private static final String DEDUPLICATE = "\t/**\n\t * Deduplicates a range of the specified {@link BUFFER_TYPE}. The range must be\n\t * sorted in ascending order prior to making this call. If it is not sorted, the\n\t * results are undefined.\n\t * <p>\n\t * This method is useful as a post-processing step after a sort on a buffer\n\t * which contains duplicate elements.\n\t *\n\t * @param b         the buffer to be deduplicated\n\t * @param fromIndex - the index of the first element (inclusive) to be\n\t *                  deduplicated\n\t * @param toIndex   - the index of the last element (exclusive) to be\n\t *                  deduplicated\n\t *\n\t * @return the (exclusive) highest index in use after deduplicating\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static int deduplicate(BUFFER_TYPE b, int fromIndex, int toIndex) {\n\t\trangeCheck(b.capacity(), fromIndex, toIndex);\n\n\t\tif (toIndex - fromIndex < 2)\n\t\t\treturn toIndex;\n\n\t\tVAL_TYPE prev = b.get(fromIndex);\n\t\tint highest = fromIndex + 1;\n\n\t\tfor (int i = fromIndex + 1; i < toIndex; i++) {\n\t\t\tVAL_TYPE value = b.get(i);\n\n\t\t\tif (COMPARE) {\n\t\t\t\tif (highest < i)\n\t\t\t\t\tb.put(highest, value);\n\n\t\t\t\thighest++;\n\t\t\t\tprev = value;\n\t\t\t}\n\t\t}\n\n\t\treturn highest;\n\t}\n";
    private static final String COPY_BUFFER = "\t/**\n\t * Returns a copy of a range from the specified buffer. The new buffer will be\n\t * direct iff the specified buffer is direct, and will have the same byte order.\n\t * The capacity will be equal to the size of the specified range. The limit will\n\t * be set to the capacity, and the position will be set to zero.\n\t *\n\t * @param b         - the buffer to be checked\n\t * @param fromIndex - the index of the first element (inclusive) to be checked\n\t * @param toIndex   - the index of the last element (exclusive) to be checked\n\t *\n\t * @return a copy of a range of data from the specified buffer\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static BUFFER_TYPE copy(BUFFER_TYPE b, int fromIndex, int toIndex) {\n\t\trangeCheck(b.capacity(), fromIndex, toIndex);\n\n\t\tBUFFER_TYPE dup = b.duplicate();\n\t\tdup.limit(toIndex);\n\t\tdup.position(fromIndex);\n\n\t\tByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(dup.remaining() * VAL_SIZE)\n\t\t\t\t: ByteBuffer.allocate(dup.remaining() * VAL_SIZE);\n\t\tcopy.order(b.order());\n\n\t\tBUFFER_TYPE view = copy.asBUFFER_TYPE();\n\t\tview.put(dup);\n\t\tview.flip();\n\n\t\treturn view;\n\t}\n";
    private static final String COPY_BYTE_BUFFER = "\t/**\n\t * Returns a copy of a range from the specified buffer. The new buffer will be\n\t * direct iff the specified buffer is direct, and will have the same byte order.\n\t * The capacity will be equal to the size of the specified range. The limit will\n\t * be set to the capacity, and the position will be set to zero.\n\t *\n\t * @param b         - the buffer to be checked\n\t * @param fromIndex - the index of the first element (inclusive) to be checked\n\t * @param toIndex   - the index of the last element (exclusive) to be checked\n\t *\n\t * @return a copy of a range of data from the specified buffer\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static ByteBuffer copy(ByteBuffer b, int fromIndex, int toIndex) {\n\n\t\tByteBuffer slice = slice(b, fromIndex, toIndex);\n\n\t\tByteBuffer copy = b.isDirect() ? ByteBuffer.allocateDirect(slice.capacity())\n\t\t\t\t: ByteBuffer.allocate(slice.capacity());\n\t\tcopy.order(b.order());\n\n\t\tcopy.put(slice);\n\t\tcopy.flip();\n\n\t\treturn copy;\n\t}\n";
    private static final String IS_SORTED = "\t/**\n\t * Determines if the specified buffer is sorted inside the specified range. That\n\t * is: {@code buffer[i] <= buffer[i + 1]} for all elements in the range. A range\n\t * of length zero or one is considered sorted.\n\t *\n\t * @param b         - the buffer to be checked\n\t * @param fromIndex - the index of the first element (inclusive) to be checked\n\t * @param toIndex   - the index of the last element (exclusive) to be checked\n\t *\n\t * @return true if the buffer is sorted inside the specified range\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static boolean isSorted(BUFFER_TYPE b, int fromIndex, int toIndex) {\n\t\trangeCheck(b.capacity(), fromIndex, toIndex);\n\n\t\tif (toIndex - fromIndex <= 1)\n\t\t\treturn true;\n\n\t\tVAL_TYPE prev = b.get(fromIndex);\n\t\tfor (int i = fromIndex + 1; i < toIndex; i++) {\n\t\t\tVAL_TYPE value = b.get(i);\n\t\t\tif (COMPARE)\n\t\t\t\treturn false;\n\t\t\tprev = value;\n\t\t}\n\n\t\treturn true;\n\t}\n";
    private static final String IS_DISTINCT = "\t/**\n\t * Determines if the specified buffer is sorted and distinct inside the\n\t * specified range. That is: {@code buffer[i] < buffer[i + 1]} for all elements\n\t * in the range. A range of length zero or one is considered sorted and\n\t * distinct.\n\t *\n\t * @param b         - the buffer to be checked\n\t * @param fromIndex - the index of the first element (inclusive) to be checked\n\t * @param toIndex   - the index of the last element (exclusive) to be checked\n\t *\n\t * @return true if the buffer is sorted and distinct inside the specified range\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t */\n\tpublic static boolean isSortedAndDistinct(BUFFER_TYPE b, int fromIndex, int toIndex) {\n\t\trangeCheck(b.capacity(), fromIndex, toIndex);\n\n\t\tif (toIndex - fromIndex <= 1)\n\t\t\treturn true;\n\n\t\tVAL_TYPE prev = b.get(fromIndex);\n\t\tfor (int i = fromIndex + 1; i < toIndex; i++) {\n\t\t\tVAL_TYPE value = b.get(i);\n\t\t\tif (COMPARE)\n\t\t\t\treturn false;\n\t\t\tprev = value;\n\t\t}\n\n\t\treturn true;\n\t}\n";
    private static final String PREFIX = "package tech.bitey.bufferstuff;\n\nimport static java.lang.Math.toIntExact;\nimport static java.util.Spliterator.IMMUTABLE;\nimport static java.util.Spliterator.NONNULL;\nimport static java.util.Spliterator.ORDERED;\n\nimport java.io.IOException;\nimport java.nio.ByteBuffer;\nimport java.nio.ByteOrder;\nimport java.nio.DoubleBuffer;\nimport java.nio.FloatBuffer;\nimport java.nio.IntBuffer;\nimport java.nio.LongBuffer;\nimport java.nio.ShortBuffer;\nimport java.nio.channels.ReadableByteChannel;\nimport java.nio.channels.WritableByteChannel;\nimport java.util.stream.DoubleStream;\nimport java.util.stream.IntStream;\nimport java.util.stream.LongStream;\nimport java.util.stream.StreamSupport;\n\n/**\n * Utility methods for working with nio buffers.\n *\n * @author biteytech@protonmail.com\n */\npublic enum BufferUtils {\n\t; // static methods only, enum prevents instantiation\n\n\tprivate static final boolean DIRECT = \"true\".equalsIgnoreCase(System.getProperty(\"tech.bitey.allocateDirect\"));\n\n\t/**\n\t * An empty, read-only {@link ByteBuffer} which has\n\t * {@link ByteOrder#nativeOrder() native order}\n\t */\n\tpublic static final ByteBuffer EMPTY_BUFFER = asReadOnlyBuffer(allocate(0));\n\n\t/**\n\t * An empty, read-only {@link BigByteBuffer} which has\n\t * {@link ByteOrder#nativeOrder() native order}\n\t */\n\tpublic static final BigByteBuffer EMPTY_BIG_BUFFER = new SimpleBigByteBuffer(EMPTY_BUFFER);\n\n\t/**\n\t * Allocates a new {@link ByteBuffer} with the specified capacity. The buffer\n\t * will be direct if the {@code tech.bitey.allocateDirect} system property is\n\t * set to \"true\", and will have {@link ByteOrder#nativeOrder() native order}.\n\t *\n\t * @param capacity the new buffer's capacity, in bytes\n\t *\n\t * @return the new native order {@code ByteBuffer}\n\t */\n\tpublic static ByteBuffer allocate(int capacity) {\n\t\treturn allocate(capacity, ByteOrder.nativeOrder());\n\t}\n\n\t/**\n\t * Allocates a new {@link ByteBuffer} with the specified capacity. The buffer\n\t * will be direct if the {@code tech.bitey.allocateDirect} system property is\n\t * set to \"true\", and will have the specified {@link ByteOrder}.\n\t *\n\t * @param capacity the new buffer's capacity, in bytes\n\t * @param order    the {@code ByteOrder}\n\t *\n\t * @return the new {@code ByteBuffer}\n\t */\n\tpublic static ByteBuffer allocate(int capacity, ByteOrder order) {\n\t\treturn (DIRECT ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity)).order(order);\n\t}\n\n\t/**\n\t * Allocates a new {@link BigByteBuffer} with the specified capacity. The buffer\n\t * will be direct if the {@code tech.bitey.allocateDirect} system property is\n\t * set to \"true\", and will have {@link ByteOrder#nativeOrder() native order}.\n\t *\n\t * @param capacity the new buffer's capacity, in bytes\n\t *\n\t * @return the new native order {@code BigByteBuffer}\n\t */\n\tpublic static BigByteBuffer allocateBig(long capacity) {\n\t\treturn allocateBig(capacity, ByteOrder.nativeOrder());\n\t}\n\n\t/**\n\t * Allocates a new {@link BigByteBuffer} with the specified capacity. The buffer\n\t * will be direct if the {@code tech.bitey.allocateDirect} system property is\n\t * set to \"true\", and will have the specified {@link ByteOrder}.\n\t *\n\t * @param capacity the new buffer's capacity, in bytes\n\t * @param order    the {@code ByteOrder}\n\t *\n\t * @return the new {@code BigByteBuffer}\n\t */\n\tpublic static BigByteBuffer allocateBig(long capacity, ByteOrder order) {\n\n\t\tif (capacity <= CompoundBigByteBuffer.CHUNK_SIZE)\n\t\t\treturn new SimpleBigByteBuffer(allocate(toIntExact(capacity), order));\n\t\telse {\n\t\t\tint chunks = (int) (capacity >> CompoundBigByteBuffer.CHUNK_BITS);\n\t\t\tint remainder = (int) (capacity & CompoundBigByteBuffer.CHUNK_MASK);\n\n\t\t\tByteBuffer buffers[] = new ByteBuffer[chunks + (remainder > 0 ? 1 : 0)];\n\t\t\tint i = 0;\n\t\t\tfor (; i < chunks; i++)\n\t\t\t\tbuffers[i] = allocate(CompoundBigByteBuffer.CHUNK_SIZE, order);\n\t\t\tif (remainder > 0)\n\t\t\t\tbuffers[i] = allocate(remainder, order);\n\n\t\t\treturn new CompoundBigByteBuffer(buffers);\n\t\t}\n\t}\n\n\t/**\n\t * Returns a new {@link BigByteBuffer} backed by the specified {@link ByteBuffer\n\t * ByteBuffers}.\n\t *\n\t * @return a new {@code BigByteBuffer} backed by the specified\n\t *         {@code ByteBuffer ByteBuffers}.\n\t */\n\tpublic static BigByteBuffer wrap(ByteBuffer[] buffers) {\n\t\tif (buffers.length == 1)\n\t\t\treturn new SimpleBigByteBuffer(buffers[0]);\n\t\telse\n\t\t\treturn new CompoundBigByteBuffer(buffers);\n\t}\n\n\t/**\n\t * Duplicate a {@link ByteBuffer} and preserve the order. Equivalent to:\n\t *\n\t * <pre>\n\t * b.duplicate().order(b.order())\n\t * </pre>\n\t *\n\t * @param b - the buffer to be duplicated\n\t *\n\t * @return duplicated buffer with order preserved\n\t *\n\t * @see ByteBuffer#duplicate()\n\t * @see ByteBuffer#order()\n\t */\n\tpublic static ByteBuffer duplicate(ByteBuffer b) {\n\t\treturn b.duplicate().order(b.order());\n\t}\n\n\t/**\n\t * Slice a {@link ByteBuffer} and preserve the order. Equivalent to:\n\t *\n\t * <pre>\n\t * b.slice().order(b.order())\n\t * </pre>\n\t *\n\t * @param b - the buffer to be sliced\n\t *\n\t * @return sliced buffer with order preserved\n\t *\n\t * @see ByteBuffer#slice()\n\t * @see ByteBuffer#order()\n\t */\n\tpublic static ByteBuffer slice(ByteBuffer b) {\n\t\treturn b.slice().order(b.order());\n\t}\n\n\t/**\n\t * Creates a new, read-only byte buffer that shares the specified buffer's\n\t * content, and preserves it's order. Equivalent to:\n\t *\n\t * <pre>\n\t * b.asReadOnlyBuffer().order(b.order())\n\t * </pre>\n\t *\n\t * @param b - the buffer to be made read-only\n\t *\n\t * @return read-only byte buffer that shares the specified buffer's content\n\t *\n\t * @see ByteBuffer#asReadOnlyBuffer()\n\t * @see ByteBuffer#order()\n\t */\n\tpublic static ByteBuffer asReadOnlyBuffer(ByteBuffer b) {\n\t\treturn b.asReadOnlyBuffer().order(b.order());\n\t}\n\n\t/**\n\t * Slice a range from the specified {@link ByteBuffer}. The buffer's order is\n\t * preserved.\n\t *\n\t * @param b         - the buffer to be sliced\n\t * @param fromIndex - the index of the first element in the range (inclusive)\n\t * @param toIndex   - the index of the last element in the range (exclusive)\n\t *\n\t * @return sliced buffer with order preserved\n\t *\n\t * @throws IllegalArgumentException  if {@code fromIndex > toIndex}\n\t * @throws IndexOutOfBoundsException if\n\t *                                   {@code fromIndex < 0 or toIndex > b.capacity()}\n\t *\n\t * @see ByteBuffer#slice()\n\t * @see ByteBuffer#order()\n\t */\n\tpublic static ByteBuffer slice(ByteBuffer b, int fromIndex, int toIndex) {\n\t\trangeCheck(b.capacity(), fromIndex, toIndex);\n\n\t\treturn b.slice(fromIndex, toIndex - fromIndex).order(b.order());\n\t}\n";
    private static final String SUFFIX = "\t/**\n\t * Checks that {@code fromIndex} and {@code toIndex} are in the range and throws\n\t * an exception if they aren't.\n\t *\n\t * @param bufferCapacity - capacity of the buffer being checked\n\t * @param fromIndex      - the index of the first element (inclusive) to be\n\t *                       checked\n\t * @param toIndex        - the index of the last element (exclusive) to be\n\t *                       checked\n\t */\n\tstatic void rangeCheck(int bufferCapacity, int fromIndex, int toIndex) {\n\t\tif (fromIndex > toIndex) {\n\t\t\tthrow new IllegalArgumentException(\"fromIndex(\" + fromIndex + \") > toIndex(\" + toIndex + \")\");\n\t\t}\n\t\tif (fromIndex < 0) {\n\t\t\tthrow new IndexOutOfBoundsException(\"fromIndex(\" + fromIndex + \") < 0\");\n\t\t}\n\t\tif (toIndex > bufferCapacity) {\n\t\t\tthrow new IndexOutOfBoundsException(\"toIndex(\" + toIndex + \") > \" + bufferCapacity);\n\t\t}\n\t}\n\n\t/**\n\t * Checks that {@code fromIndex} and {@code toIndex} are in the range and throws\n\t * an exception if they aren't.\n\t *\n\t * @param bufferCapacity - capacity of the buffer being checked\n\t * @param fromIndex      - the index of the first element (inclusive) to be\n\t *                       checked\n\t * @param toIndex        - the index of the last element (inclusive) to be\n\t *                       checked\n\t */\n\tstatic void rangeCheckInclusive(int bufferCapacity, int fromIndex, int toIndex) {\n\t\tif (fromIndex > toIndex) {\n\t\t\tthrow new IllegalArgumentException(\"fromIndex(\" + fromIndex + \") > toIndex(\" + toIndex + \")\");\n\t\t}\n\t\tif (fromIndex < 0) {\n\t\t\tthrow new IndexOutOfBoundsException(\"fromIndex(\" + fromIndex + \") < 0\");\n\t\t}\n\t\tif (toIndex >= bufferCapacity) {\n\t\t\tthrow new IndexOutOfBoundsException(\"toIndex(\" + toIndex + \") >= \" + bufferCapacity);\n\t\t}\n\t}\n\n\t/**\n\t * Writes all {@link ByteBuffer#remaining() remaining} bytes from the given\n\t * {@link ByteBuffer buffer} into the given {@link WritableByteChannel channel}.\n\t *\n\t * @param channel - the channel being written to\n\t * @param buffer  - the buffer being read from\n\t * @throws IOException\n\t */\n\tpublic static void writeFully(WritableByteChannel channel, ByteBuffer buffer) throws IOException {\n\t\twhile (buffer.remaining() > 0)\n\t\t\tchannel.write(buffer);\n\t}\n\n\t/**\n\t * Reads bytes from the given {@link ReadableByteChannel channel} until the\n\t * given buffer is full ({@link ByteBuffer#remaining() remaining} is {@code 0}).\n\t *\n\t * @param channel - the channel being read from\n\t * @param buffer  - the buffer being written to\n\t * @throws IOException\n\t */\n\tpublic static void readFully(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {\n\t\twhile (buffer.remaining() > 0)\n\t\t\tchannel.read(buffer);\n\t}\n}\n";

    @Override
    public void run() throws Exception {
        try (BufferedWriter out = this.open("BufferUtils.java");){
            this.section(out, PREFIX);
            this.sections(out, false);
            this.sections(out, true);
            this.section(out, SUFFIX);
        }
    }

    private void sections(BufferedWriter out, boolean small) throws Exception {
        String s = small ? "Small" : "";
        this.section(out, GenBufferUtils.isSorted("int", s + "IntBuffer", "prev > value"));
        this.section(out, GenBufferUtils.isDistinct("int", s + "IntBuffer", "prev >= value"));
        this.section(out, GenBufferUtils.isSorted("long", s + "LongBuffer", "prev > value"));
        this.section(out, GenBufferUtils.isDistinct("long", s + "LongBuffer", "prev >= value"));
        this.section(out, GenBufferUtils.isSorted("byte", s + "ByteBuffer", "prev > value"));
        this.section(out, GenBufferUtils.isDistinct("byte", s + "ByteBuffer", "prev >= value"));
        this.section(out, GenBufferUtils.isSorted("short", s + "ShortBuffer", "prev > value"));
        this.section(out, GenBufferUtils.isDistinct("short", s + "ShortBuffer", "prev >= value"));
        this.section(out, GenBufferUtils.isSorted("float", s + "FloatBuffer", "Float.compare(prev, value) > 0"));
        this.section(out, GenBufferUtils.isDistinct("float", s + "FloatBuffer", "Float.compare(prev, value) >= 0"));
        this.section(out, GenBufferUtils.isSorted("double", s + "DoubleBuffer", "Double.compare(prev, value) > 0"));
        this.section(out, GenBufferUtils.isDistinct("double", s + "DoubleBuffer", "Double.compare(prev, value) >= 0"));
        if (!small) {
            this.section(out, COPY_BYTE_BUFFER);
            this.section(out, GenBufferUtils.copy("IntBuffer", 4));
            this.section(out, GenBufferUtils.copy("LongBuffer", 8));
            this.section(out, GenBufferUtils.copy("ShortBuffer", 2));
            this.section(out, GenBufferUtils.copy("FloatBuffer", 4));
            this.section(out, GenBufferUtils.copy("DoubleBuffer", 8));
        }
        this.section(out, GenBufferUtils.deduplicate("int", s + "IntBuffer", "value != prev"));
        this.section(out, GenBufferUtils.deduplicate("long", s + "LongBuffer", "value != prev"));
        this.section(out, GenBufferUtils.deduplicate("short", s + "ShortBuffer", "value != prev"));
        this.section(out, GenBufferUtils.deduplicate("byte", s + "ByteBuffer", "value != prev"));
        this.section(out, GenBufferUtils.deduplicate("float", s + "FloatBuffer", "Float.compare(value, prev) != 0"));
        this.section(out, GenBufferUtils.deduplicate("double", s + "DoubleBuffer", "Double.compare(value, prev) != 0"));
        this.section(out, GenBufferUtils.stream("int", s + "IntBuffer", "IntStream"));
        this.section(out, GenBufferUtils.stream("long", s + "LongBuffer", "LongStream"));
        this.section(out, GenBufferUtils.stream("double", s + "DoubleBuffer", "DoubleStream"));
    }

    private static String isSorted(String valType, String bufferType, String compare) {
        return IS_SORTED.replace(VAL_TYPE, valType).replace(BUFFER_TYPE, bufferType).replace(COMPARE, compare);
    }

    private static String isDistinct(String valType, String bufferType, String compare) {
        return IS_DISTINCT.replace(VAL_TYPE, valType).replace(BUFFER_TYPE, bufferType).replace(COMPARE, compare);
    }

    private static String copy(String bufferType, int valSize) {
        return COPY_BUFFER.replace(BUFFER_TYPE, bufferType).replace(VAL_SIZE, "" + valSize);
    }

    private static String deduplicate(String valType, String bufferType, String compare) {
        return DEDUPLICATE.replace(VAL_TYPE, valType).replace(BUFFER_TYPE, bufferType).replace(COMPARE, compare);
    }

    private static String stream(String valType, String bufferType, String streamType) {
        return STREAM.replace(VAL_TYPE, valType).replace(BUFFER_TYPE, bufferType).replace(STREAM_TYPE, streamType);
    }
}

