/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import jdk.incubator.foreign.Addressable;
import jdk.incubator.foreign.MemorySegment;
import jdk.incubator.foreign.ResourceScope;
import jdk.incubator.foreign.SegmentAllocator;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import tech.deplant.java4ever.binding.json.JsonData;
import tech.deplant.java4ever.binding.loader.LibraryLoader;
import tech.deplant.java4ever.binding.response.EverResponse;
import tech.deplant.java4ever.ffi.tc_response_handler_t;
import tech.deplant.java4ever.ffi.tc_string_data_t;
import tech.deplant.java4ever.ffi.ton_client;

public final class Context {
    @Generated
    private static final Logger log = LogManager.getLogger(Context.class);
    public int requestCount = 0;
    int id;
    long timeout;
    Double version = 1.28;
    private ResourceScope resourceScopeOfConfig = ResourceScope.newSharedScope();

    public Context(LibraryLoader loader, String config) {
        loader.load();
        this.id = this.tcCreateContext(this.resourceScopeOfConfig, config);
        this.timeout = 30L;
    }

    private Context(LibraryLoader loader, Config config) {
        this(loader, config.toJson());
    }

    static <T, P extends JsonData> CompletableFuture<T> futureCallback(String functionName, Context context, P params, Class<T> clazz) {
        return context.future(functionName, params, clazz);
    }

    public <T, P extends JsonData> CompletableFuture<T> future(String functionName, P params, Class<T> clazz) {
        return this.tcRequest(functionName, params == null ? "" : params.toJson(this.version())).thenApply(json -> new Gson().fromJson(json, clazz));
    }

    public CompletableFuture<String> tcRequest(String functionName, String params) {
        int requestId = this.requestCount++;
        EverResponse response = new EverResponse();
        log.trace("FUNC:{} CTXID:{} REQID:{} SEND:{}", new Supplier[]{() -> functionName, () -> this.id(), () -> requestId, () -> params});
        ton_client.tc_request(this.id(), tc_string_data_t.ofString(functionName, ResourceScope.newSharedScope()), tc_string_data_t.ofString(params, ResourceScope.newSharedScope()), requestId, (Addressable)tc_response_handler_t.allocate(response, ResourceScope.newSharedScope()));
        response.result().thenApply(res -> {
            log.trace("FUNC: " + functionName + " CTXID:" + this.id() + " REQID:" + requestId + " RESP:" + res);
            return res;
        });
        return response.result();
    }

    private int tcCreateContext(ResourceScope scope, String configJson) {
        log.info("FUNC:sdk.create_context CTXID:0 REQID:0 SEND:{}", new Supplier[]{() -> configJson});
        MemorySegment out = ton_client.tc_read_string(SegmentAllocator.ofScope((ResourceScope)scope), (Addressable)ton_client.tc_create_context(tc_string_data_t.ofString(configJson, scope)));
        String result = tc_string_data_t.toString(out, scope);
        log.info("FUNC:sdk.create_context CTXID:0 REQID:0 RESP:{}", new Supplier[]{() -> result});
        ResultOfCreateContext context = (ResultOfCreateContext)new Gson().fromJson(result, ResultOfCreateContext.class);
        return context.result() == null ? -1 : context.result();
    }

    @Generated
    public int id() {
        return this.id;
    }

    @Generated
    public long timeout() {
        return this.timeout;
    }

    @Generated
    public Context timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Generated
    public Double version() {
        return this.version;
    }

    public static final class Config
    extends JsonData {
        private final NetworkConfig network;
        private final CryptoConfig crypto;
        private final AbiConfig abi;

        @Generated
        public Config(NetworkConfig network, CryptoConfig crypto, AbiConfig abi) {
            this.network = network;
            this.crypto = crypto;
            this.abi = abi;
        }

        @Generated
        public NetworkConfig network() {
            return this.network;
        }

        @Generated
        public CryptoConfig crypto() {
            return this.crypto;
        }

        @Generated
        public AbiConfig abi() {
            return this.abi;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            NetworkConfig this$network = this.network();
            NetworkConfig other$network = other.network();
            if (this$network == null ? other$network != null : !((Object)this$network).equals(other$network)) {
                return false;
            }
            CryptoConfig this$crypto = this.crypto();
            CryptoConfig other$crypto = other.crypto();
            if (this$crypto == null ? other$crypto != null : !((Object)this$crypto).equals(other$crypto)) {
                return false;
            }
            AbiConfig this$abi = this.abi();
            AbiConfig other$abi = other.abi();
            return !(this$abi == null ? other$abi != null : !((Object)this$abi).equals(other$abi));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            NetworkConfig $network = this.network();
            result = result * 59 + ($network == null ? 43 : ((Object)$network).hashCode());
            CryptoConfig $crypto = this.crypto();
            result = result * 59 + ($crypto == null ? 43 : ((Object)$crypto).hashCode());
            AbiConfig $abi = this.abi();
            result = result * 59 + ($abi == null ? 43 : ((Object)$abi).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Context.Config(network=" + this.network() + ", crypto=" + this.crypto() + ", abi=" + this.abi() + ")";
        }
    }

    public static final class ResultOfCreateContext
    extends JsonData {
        private final Integer result;
        private final String error;

        @Generated
        public ResultOfCreateContext(Integer result, String error) {
            this.result = result;
            this.error = error;
        }

        @Generated
        public Integer result() {
            return this.result;
        }

        @Generated
        public String error() {
            return this.error;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfCreateContext)) {
                return false;
            }
            ResultOfCreateContext other = (ResultOfCreateContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$result = this.result();
            Integer other$result = other.result();
            if (this$result == null ? other$result != null : !((Object)this$result).equals(other$result)) {
                return false;
            }
            String this$error = this.error();
            String other$error = other.error();
            return !(this$error == null ? other$error != null : !this$error.equals(other$error));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfCreateContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $result = this.result();
            result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
            String $error = this.error();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Context.ResultOfCreateContext(result=" + this.result() + ", error=" + this.error() + ")";
        }
    }

    private class Callback<T> {
        BiConsumer<T, Integer> consumer;
        Class<T> clazz;

        Callback(BiConsumer<T, Integer> consumer, Class<T> clazz) {
            this.consumer = consumer;
            this.clazz = clazz;
        }
    }

    public static final class AbiConfig
    extends JsonData {
        private final Integer workchain;
        private final Integer message_expiration_timeout;
        private final Integer message_expiration_timeout_grow_factor;

        @Generated
        public AbiConfig(Integer workchain, Integer message_expiration_timeout, Integer message_expiration_timeout_grow_factor) {
            this.workchain = workchain;
            this.message_expiration_timeout = message_expiration_timeout;
            this.message_expiration_timeout_grow_factor = message_expiration_timeout_grow_factor;
        }

        @Generated
        public Integer workchain() {
            return this.workchain;
        }

        @Generated
        public Integer message_expiration_timeout() {
            return this.message_expiration_timeout;
        }

        @Generated
        public Integer message_expiration_timeout_grow_factor() {
            return this.message_expiration_timeout_grow_factor;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AbiConfig)) {
                return false;
            }
            AbiConfig other = (AbiConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$workchain = this.workchain();
            Integer other$workchain = other.workchain();
            if (this$workchain == null ? other$workchain != null : !((Object)this$workchain).equals(other$workchain)) {
                return false;
            }
            Integer this$message_expiration_timeout = this.message_expiration_timeout();
            Integer other$message_expiration_timeout = other.message_expiration_timeout();
            if (this$message_expiration_timeout == null ? other$message_expiration_timeout != null : !((Object)this$message_expiration_timeout).equals(other$message_expiration_timeout)) {
                return false;
            }
            Integer this$message_expiration_timeout_grow_factor = this.message_expiration_timeout_grow_factor();
            Integer other$message_expiration_timeout_grow_factor = other.message_expiration_timeout_grow_factor();
            return !(this$message_expiration_timeout_grow_factor == null ? other$message_expiration_timeout_grow_factor != null : !((Object)this$message_expiration_timeout_grow_factor).equals(other$message_expiration_timeout_grow_factor));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AbiConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $workchain = this.workchain();
            result = result * 59 + ($workchain == null ? 43 : ((Object)$workchain).hashCode());
            Integer $message_expiration_timeout = this.message_expiration_timeout();
            result = result * 59 + ($message_expiration_timeout == null ? 43 : ((Object)$message_expiration_timeout).hashCode());
            Integer $message_expiration_timeout_grow_factor = this.message_expiration_timeout_grow_factor();
            result = result * 59 + ($message_expiration_timeout_grow_factor == null ? 43 : ((Object)$message_expiration_timeout_grow_factor).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Context.AbiConfig(workchain=" + this.workchain() + ", message_expiration_timeout=" + this.message_expiration_timeout() + ", message_expiration_timeout_grow_factor=" + this.message_expiration_timeout_grow_factor() + ")";
        }
    }

    public static final class CryptoConfig
    extends JsonData {
        private final Integer mnemonic_dictionary;
        private final Integer mnemonic_word_count;
        private final String hdkey_derivation_path;

        @Generated
        public CryptoConfig(Integer mnemonic_dictionary, Integer mnemonic_word_count, String hdkey_derivation_path) {
            this.mnemonic_dictionary = mnemonic_dictionary;
            this.mnemonic_word_count = mnemonic_word_count;
            this.hdkey_derivation_path = hdkey_derivation_path;
        }

        @Generated
        public Integer mnemonic_dictionary() {
            return this.mnemonic_dictionary;
        }

        @Generated
        public Integer mnemonic_word_count() {
            return this.mnemonic_word_count;
        }

        @Generated
        public String hdkey_derivation_path() {
            return this.hdkey_derivation_path;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CryptoConfig)) {
                return false;
            }
            CryptoConfig other = (CryptoConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$mnemonic_dictionary = this.mnemonic_dictionary();
            Integer other$mnemonic_dictionary = other.mnemonic_dictionary();
            if (this$mnemonic_dictionary == null ? other$mnemonic_dictionary != null : !((Object)this$mnemonic_dictionary).equals(other$mnemonic_dictionary)) {
                return false;
            }
            Integer this$mnemonic_word_count = this.mnemonic_word_count();
            Integer other$mnemonic_word_count = other.mnemonic_word_count();
            if (this$mnemonic_word_count == null ? other$mnemonic_word_count != null : !((Object)this$mnemonic_word_count).equals(other$mnemonic_word_count)) {
                return false;
            }
            String this$hdkey_derivation_path = this.hdkey_derivation_path();
            String other$hdkey_derivation_path = other.hdkey_derivation_path();
            return !(this$hdkey_derivation_path == null ? other$hdkey_derivation_path != null : !this$hdkey_derivation_path.equals(other$hdkey_derivation_path));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CryptoConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $mnemonic_dictionary = this.mnemonic_dictionary();
            result = result * 59 + ($mnemonic_dictionary == null ? 43 : ((Object)$mnemonic_dictionary).hashCode());
            Integer $mnemonic_word_count = this.mnemonic_word_count();
            result = result * 59 + ($mnemonic_word_count == null ? 43 : ((Object)$mnemonic_word_count).hashCode());
            String $hdkey_derivation_path = this.hdkey_derivation_path();
            result = result * 59 + ($hdkey_derivation_path == null ? 43 : $hdkey_derivation_path.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Context.CryptoConfig(mnemonic_dictionary=" + this.mnemonic_dictionary() + ", mnemonic_word_count=" + this.mnemonic_word_count() + ", hdkey_derivation_path=" + this.hdkey_derivation_path() + ")";
        }
    }

    public static final class NetworkConfig
    extends JsonData {
        private final String[] endpoints;
        @Deprecated
        private final String server_address;
        private final Integer network_retries_count;
        private final Integer message_retries_count;
        private final Integer message_processing_timeout;
        private final Integer wait_for_timeout;
        private final Integer out_of_sync_threshold;
        private final Integer reconnect_timeout;
        private final String access_key;

        @Generated
        public NetworkConfig(String[] endpoints, String server_address, Integer network_retries_count, Integer message_retries_count, Integer message_processing_timeout, Integer wait_for_timeout, Integer out_of_sync_threshold, Integer reconnect_timeout, String access_key) {
            this.endpoints = endpoints;
            this.server_address = server_address;
            this.network_retries_count = network_retries_count;
            this.message_retries_count = message_retries_count;
            this.message_processing_timeout = message_processing_timeout;
            this.wait_for_timeout = wait_for_timeout;
            this.out_of_sync_threshold = out_of_sync_threshold;
            this.reconnect_timeout = reconnect_timeout;
            this.access_key = access_key;
        }

        @Generated
        public String[] endpoints() {
            return this.endpoints;
        }

        @Deprecated
        @Generated
        public String server_address() {
            return this.server_address;
        }

        @Generated
        public Integer network_retries_count() {
            return this.network_retries_count;
        }

        @Generated
        public Integer message_retries_count() {
            return this.message_retries_count;
        }

        @Generated
        public Integer message_processing_timeout() {
            return this.message_processing_timeout;
        }

        @Generated
        public Integer wait_for_timeout() {
            return this.wait_for_timeout;
        }

        @Generated
        public Integer out_of_sync_threshold() {
            return this.out_of_sync_threshold;
        }

        @Generated
        public Integer reconnect_timeout() {
            return this.reconnect_timeout;
        }

        @Generated
        public String access_key() {
            return this.access_key;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkConfig)) {
                return false;
            }
            NetworkConfig other = (NetworkConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Integer this$network_retries_count = this.network_retries_count();
            Integer other$network_retries_count = other.network_retries_count();
            if (this$network_retries_count == null ? other$network_retries_count != null : !((Object)this$network_retries_count).equals(other$network_retries_count)) {
                return false;
            }
            Integer this$message_retries_count = this.message_retries_count();
            Integer other$message_retries_count = other.message_retries_count();
            if (this$message_retries_count == null ? other$message_retries_count != null : !((Object)this$message_retries_count).equals(other$message_retries_count)) {
                return false;
            }
            Integer this$message_processing_timeout = this.message_processing_timeout();
            Integer other$message_processing_timeout = other.message_processing_timeout();
            if (this$message_processing_timeout == null ? other$message_processing_timeout != null : !((Object)this$message_processing_timeout).equals(other$message_processing_timeout)) {
                return false;
            }
            Integer this$wait_for_timeout = this.wait_for_timeout();
            Integer other$wait_for_timeout = other.wait_for_timeout();
            if (this$wait_for_timeout == null ? other$wait_for_timeout != null : !((Object)this$wait_for_timeout).equals(other$wait_for_timeout)) {
                return false;
            }
            Integer this$out_of_sync_threshold = this.out_of_sync_threshold();
            Integer other$out_of_sync_threshold = other.out_of_sync_threshold();
            if (this$out_of_sync_threshold == null ? other$out_of_sync_threshold != null : !((Object)this$out_of_sync_threshold).equals(other$out_of_sync_threshold)) {
                return false;
            }
            Integer this$reconnect_timeout = this.reconnect_timeout();
            Integer other$reconnect_timeout = other.reconnect_timeout();
            if (this$reconnect_timeout == null ? other$reconnect_timeout != null : !((Object)this$reconnect_timeout).equals(other$reconnect_timeout)) {
                return false;
            }
            if (!Arrays.deepEquals(this.endpoints(), other.endpoints())) {
                return false;
            }
            String this$server_address = this.server_address();
            String other$server_address = other.server_address();
            if (this$server_address == null ? other$server_address != null : !this$server_address.equals(other$server_address)) {
                return false;
            }
            String this$access_key = this.access_key();
            String other$access_key = other.access_key();
            return !(this$access_key == null ? other$access_key != null : !this$access_key.equals(other$access_key));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetworkConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Integer $network_retries_count = this.network_retries_count();
            result = result * 59 + ($network_retries_count == null ? 43 : ((Object)$network_retries_count).hashCode());
            Integer $message_retries_count = this.message_retries_count();
            result = result * 59 + ($message_retries_count == null ? 43 : ((Object)$message_retries_count).hashCode());
            Integer $message_processing_timeout = this.message_processing_timeout();
            result = result * 59 + ($message_processing_timeout == null ? 43 : ((Object)$message_processing_timeout).hashCode());
            Integer $wait_for_timeout = this.wait_for_timeout();
            result = result * 59 + ($wait_for_timeout == null ? 43 : ((Object)$wait_for_timeout).hashCode());
            Integer $out_of_sync_threshold = this.out_of_sync_threshold();
            result = result * 59 + ($out_of_sync_threshold == null ? 43 : ((Object)$out_of_sync_threshold).hashCode());
            Integer $reconnect_timeout = this.reconnect_timeout();
            result = result * 59 + ($reconnect_timeout == null ? 43 : ((Object)$reconnect_timeout).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.endpoints());
            String $server_address = this.server_address();
            result = result * 59 + ($server_address == null ? 43 : $server_address.hashCode());
            String $access_key = this.access_key();
            result = result * 59 + ($access_key == null ? 43 : $access_key.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Context.NetworkConfig(endpoints=" + Arrays.deepToString(this.endpoints()) + ", server_address=" + this.server_address() + ", network_retries_count=" + this.network_retries_count() + ", message_retries_count=" + this.message_retries_count() + ", message_processing_timeout=" + this.message_processing_timeout() + ", wait_for_timeout=" + this.wait_for_timeout() + ", out_of_sync_threshold=" + this.out_of_sync_threshold() + ", reconnect_timeout=" + this.reconnect_timeout() + ", access_key=" + this.access_key() + ")";
        }
    }
}

