/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.google.gson.annotations.SerializedName;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import lombok.NonNull;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.json.JsonData;

public class Utils {
    public static CompletableFuture<ResultOfConvertAddress> convertAddress(@NonNull Context context, @NonNull String address, @NonNull AddressStringFormat outputFormat) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (outputFormat == null) {
            throw new NullPointerException("outputFormat is marked non-null but is null");
        }
        return context.future("utils.convert_address", new ParamsOfConvertAddress(address, outputFormat), ResultOfConvertAddress.class);
    }

    public static CompletableFuture<ResultOfGetAddressType> getAddressType(@NonNull Context context, @NonNull String address) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        return context.future("utils.get_address_type", new ParamsOfGetAddressType(address), ResultOfGetAddressType.class);
    }

    public static CompletableFuture<ResultOfCalcStorageFee> calcStorageFee(@NonNull Context context, @NonNull String account, @NonNull Number period) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        if (period == null) {
            throw new NullPointerException("period is marked non-null but is null");
        }
        return context.future("utils.calc_storage_fee", new ParamsOfCalcStorageFee(account, period), ResultOfCalcStorageFee.class);
    }

    public static CompletableFuture<ResultOfCompressZstd> compressZstd(@NonNull Context context, @NonNull String uncompressed, Number level) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (uncompressed == null) {
            throw new NullPointerException("uncompressed is marked non-null but is null");
        }
        return context.future("utils.compress_zstd", new ParamsOfCompressZstd(uncompressed, level), ResultOfCompressZstd.class);
    }

    public static CompletableFuture<ResultOfDecompressZstd> decompressZstd(@NonNull Context context, @NonNull String compressed) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (compressed == null) {
            throw new NullPointerException("compressed is marked non-null but is null");
        }
        return context.future("utils.decompress_zstd", new ParamsOfDecompressZstd(compressed), ResultOfDecompressZstd.class);
    }

    public static final class ParamsOfConvertAddress
    extends JsonData {
        @SerializedName(value="address")
        @NonNull
        private final String address;
        @SerializedName(value="output_format")
        @NonNull
        private final AddressStringFormat outputFormat;

        @Generated
        public ParamsOfConvertAddress(@NonNull String address, @NonNull AddressStringFormat outputFormat) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            if (outputFormat == null) {
                throw new NullPointerException("outputFormat is marked non-null but is null");
            }
            this.address = address;
            this.outputFormat = outputFormat;
        }

        @NonNull
        @Generated
        public String address() {
            return this.address;
        }

        @NonNull
        @Generated
        public AddressStringFormat outputFormat() {
            return this.outputFormat;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfConvertAddress)) {
                return false;
            }
            ParamsOfConvertAddress other = (ParamsOfConvertAddress)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$address = this.address();
            String other$address = other.address();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            AddressStringFormat this$outputFormat = this.outputFormat();
            AddressStringFormat other$outputFormat = other.outputFormat();
            return !(this$outputFormat == null ? other$outputFormat != null : !this$outputFormat.equals(other$outputFormat));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfConvertAddress;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $address = this.address();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            AddressStringFormat $outputFormat = this.outputFormat();
            result = result * 59 + ($outputFormat == null ? 43 : $outputFormat.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Utils.ParamsOfConvertAddress(address=" + this.address() + ", outputFormat=" + this.outputFormat() + ")";
        }
    }

    public static abstract class AddressStringFormat {
        public static final AccountId AccountId = new AccountId();
        public static final Hex Hex = new Hex();

        public static final class AccountId
        extends AddressStringFormat {
            @Generated
            public AccountId() {
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AccountId)) {
                    return false;
                }
                AccountId other = (AccountId)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return super.equals(o);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AccountId;
            }

            @Generated
            public int hashCode() {
                int result = super.hashCode();
                return result;
            }

            @Generated
            public String toString() {
                return "Utils.AddressStringFormat.AccountId()";
            }
        }

        public static final class Hex
        extends AddressStringFormat {
            @Generated
            public Hex() {
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Hex)) {
                    return false;
                }
                Hex other = (Hex)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return super.equals(o);
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Hex;
            }

            @Generated
            public int hashCode() {
                int result = super.hashCode();
                return result;
            }

            @Generated
            public String toString() {
                return "Utils.AddressStringFormat.Hex()";
            }
        }

        public static final class Base64
        extends AddressStringFormat {
            @SerializedName(value="url")
            @NonNull
            private final Boolean url;
            @SerializedName(value="test")
            @NonNull
            private final Boolean test;
            @SerializedName(value="bounce")
            @NonNull
            private final Boolean bounce;

            @Generated
            public Base64(@NonNull Boolean url, @NonNull Boolean test, @NonNull Boolean bounce) {
                if (url == null) {
                    throw new NullPointerException("url is marked non-null but is null");
                }
                if (test == null) {
                    throw new NullPointerException("test is marked non-null but is null");
                }
                if (bounce == null) {
                    throw new NullPointerException("bounce is marked non-null but is null");
                }
                this.url = url;
                this.test = test;
                this.bounce = bounce;
            }

            @NonNull
            @Generated
            public Boolean url() {
                return this.url;
            }

            @NonNull
            @Generated
            public Boolean test() {
                return this.test;
            }

            @NonNull
            @Generated
            public Boolean bounce() {
                return this.bounce;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Base64)) {
                    return false;
                }
                Base64 other = (Base64)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                Boolean this$url = this.url();
                Boolean other$url = other.url();
                if (this$url == null ? other$url != null : !((Object)this$url).equals(other$url)) {
                    return false;
                }
                Boolean this$test = this.test();
                Boolean other$test = other.test();
                if (this$test == null ? other$test != null : !((Object)this$test).equals(other$test)) {
                    return false;
                }
                Boolean this$bounce = this.bounce();
                Boolean other$bounce = other.bounce();
                return !(this$bounce == null ? other$bounce != null : !((Object)this$bounce).equals(other$bounce));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Base64;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = super.hashCode();
                Boolean $url = this.url();
                result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
                Boolean $test = this.test();
                result = result * 59 + ($test == null ? 43 : ((Object)$test).hashCode());
                Boolean $bounce = this.bounce();
                result = result * 59 + ($bounce == null ? 43 : ((Object)$bounce).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Utils.AddressStringFormat.Base64(url=" + this.url() + ", test=" + this.test() + ", bounce=" + this.bounce() + ")";
            }
        }
    }

    public static final class ResultOfConvertAddress
    extends JsonData {
        @SerializedName(value="address")
        @NonNull
        private final String address;

        @Generated
        public ResultOfConvertAddress(@NonNull String address) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            this.address = address;
        }

        @NonNull
        @Generated
        public String address() {
            return this.address;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfConvertAddress)) {
                return false;
            }
            ResultOfConvertAddress other = (ResultOfConvertAddress)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$address = this.address();
            String other$address = other.address();
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfConvertAddress;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $address = this.address();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Utils.ResultOfConvertAddress(address=" + this.address() + ")";
        }
    }

    public static final class ParamsOfGetAddressType
    extends JsonData {
        @SerializedName(value="address")
        @NonNull
        private final String address;

        @Generated
        public ParamsOfGetAddressType(@NonNull String address) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            this.address = address;
        }

        @NonNull
        @Generated
        public String address() {
            return this.address;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfGetAddressType)) {
                return false;
            }
            ParamsOfGetAddressType other = (ParamsOfGetAddressType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$address = this.address();
            String other$address = other.address();
            return !(this$address == null ? other$address != null : !this$address.equals(other$address));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfGetAddressType;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $address = this.address();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Utils.ParamsOfGetAddressType(address=" + this.address() + ")";
        }
    }

    public static final class ResultOfGetAddressType
    extends JsonData {
        @SerializedName(value="address_type")
        @NonNull
        private final AccountAddressType addressType;

        @Generated
        public ResultOfGetAddressType(@NonNull AccountAddressType addressType) {
            if (addressType == null) {
                throw new NullPointerException("addressType is marked non-null but is null");
            }
            this.addressType = addressType;
        }

        @NonNull
        @Generated
        public AccountAddressType addressType() {
            return this.addressType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfGetAddressType)) {
                return false;
            }
            ResultOfGetAddressType other = (ResultOfGetAddressType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AccountAddressType this$addressType = this.addressType();
            AccountAddressType other$addressType = other.addressType();
            return !(this$addressType == null ? other$addressType != null : !((Object)((Object)this$addressType)).equals((Object)other$addressType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfGetAddressType;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            AccountAddressType $addressType = this.addressType();
            result = result * 59 + ($addressType == null ? 43 : ((Object)((Object)$addressType)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Utils.ResultOfGetAddressType(addressType=" + this.addressType() + ")";
        }
    }

    public static final class ParamsOfCalcStorageFee
    extends JsonData {
        @SerializedName(value="account")
        @NonNull
        private final String account;
        @SerializedName(value="period")
        @NonNull
        private final Number period;

        @Generated
        public ParamsOfCalcStorageFee(@NonNull String account, @NonNull Number period) {
            if (account == null) {
                throw new NullPointerException("account is marked non-null but is null");
            }
            if (period == null) {
                throw new NullPointerException("period is marked non-null but is null");
            }
            this.account = account;
            this.period = period;
        }

        @NonNull
        @Generated
        public String account() {
            return this.account;
        }

        @NonNull
        @Generated
        public Number period() {
            return this.period;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfCalcStorageFee)) {
                return false;
            }
            ParamsOfCalcStorageFee other = (ParamsOfCalcStorageFee)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$account = this.account();
            String other$account = other.account();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            Number this$period = this.period();
            Number other$period = other.period();
            return !(this$period == null ? other$period != null : !this$period.equals(other$period));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfCalcStorageFee;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $account = this.account();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            Number $period = this.period();
            result = result * 59 + ($period == null ? 43 : $period.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Utils.ParamsOfCalcStorageFee(account=" + this.account() + ", period=" + this.period() + ")";
        }
    }

    public static final class ResultOfCalcStorageFee
    extends JsonData {
        @SerializedName(value="fee")
        @NonNull
        private final String fee;

        @Generated
        public ResultOfCalcStorageFee(@NonNull String fee) {
            if (fee == null) {
                throw new NullPointerException("fee is marked non-null but is null");
            }
            this.fee = fee;
        }

        @NonNull
        @Generated
        public String fee() {
            return this.fee;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfCalcStorageFee)) {
                return false;
            }
            ResultOfCalcStorageFee other = (ResultOfCalcStorageFee)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$fee = this.fee();
            String other$fee = other.fee();
            return !(this$fee == null ? other$fee != null : !this$fee.equals(other$fee));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfCalcStorageFee;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $fee = this.fee();
            result = result * 59 + ($fee == null ? 43 : $fee.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Utils.ResultOfCalcStorageFee(fee=" + this.fee() + ")";
        }
    }

    public static final class ParamsOfCompressZstd
    extends JsonData {
        @SerializedName(value="uncompressed")
        @NonNull
        private final String uncompressed;
        @SerializedName(value="level")
        private final Number level;

        public Optional<Number> level() {
            return Optional.ofNullable(this.level);
        }

        @Generated
        public ParamsOfCompressZstd(@NonNull String uncompressed, Number level) {
            if (uncompressed == null) {
                throw new NullPointerException("uncompressed is marked non-null but is null");
            }
            this.uncompressed = uncompressed;
            this.level = level;
        }

        @NonNull
        @Generated
        public String uncompressed() {
            return this.uncompressed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfCompressZstd)) {
                return false;
            }
            ParamsOfCompressZstd other = (ParamsOfCompressZstd)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$uncompressed = this.uncompressed();
            String other$uncompressed = other.uncompressed();
            if (this$uncompressed == null ? other$uncompressed != null : !this$uncompressed.equals(other$uncompressed)) {
                return false;
            }
            Optional<Number> this$level = this.level();
            Optional<Number> other$level = other.level();
            return !(this$level == null ? other$level != null : !((Object)this$level).equals(other$level));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfCompressZstd;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $uncompressed = this.uncompressed();
            result = result * 59 + ($uncompressed == null ? 43 : $uncompressed.hashCode());
            Optional<Number> $level = this.level();
            result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Utils.ParamsOfCompressZstd(uncompressed=" + this.uncompressed() + ", level=" + this.level() + ")";
        }
    }

    public static final class ResultOfCompressZstd
    extends JsonData {
        @SerializedName(value="compressed")
        @NonNull
        private final String compressed;

        @Generated
        public ResultOfCompressZstd(@NonNull String compressed) {
            if (compressed == null) {
                throw new NullPointerException("compressed is marked non-null but is null");
            }
            this.compressed = compressed;
        }

        @NonNull
        @Generated
        public String compressed() {
            return this.compressed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfCompressZstd)) {
                return false;
            }
            ResultOfCompressZstd other = (ResultOfCompressZstd)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$compressed = this.compressed();
            String other$compressed = other.compressed();
            return !(this$compressed == null ? other$compressed != null : !this$compressed.equals(other$compressed));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfCompressZstd;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $compressed = this.compressed();
            result = result * 59 + ($compressed == null ? 43 : $compressed.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Utils.ResultOfCompressZstd(compressed=" + this.compressed() + ")";
        }
    }

    public static final class ParamsOfDecompressZstd
    extends JsonData {
        @SerializedName(value="compressed")
        @NonNull
        private final String compressed;

        @Generated
        public ParamsOfDecompressZstd(@NonNull String compressed) {
            if (compressed == null) {
                throw new NullPointerException("compressed is marked non-null but is null");
            }
            this.compressed = compressed;
        }

        @NonNull
        @Generated
        public String compressed() {
            return this.compressed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ParamsOfDecompressZstd)) {
                return false;
            }
            ParamsOfDecompressZstd other = (ParamsOfDecompressZstd)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$compressed = this.compressed();
            String other$compressed = other.compressed();
            return !(this$compressed == null ? other$compressed != null : !this$compressed.equals(other$compressed));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ParamsOfDecompressZstd;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $compressed = this.compressed();
            result = result * 59 + ($compressed == null ? 43 : $compressed.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Utils.ParamsOfDecompressZstd(compressed=" + this.compressed() + ")";
        }
    }

    public static final class ResultOfDecompressZstd
    extends JsonData {
        @SerializedName(value="decompressed")
        @NonNull
        private final String decompressed;

        @Generated
        public ResultOfDecompressZstd(@NonNull String decompressed) {
            if (decompressed == null) {
                throw new NullPointerException("decompressed is marked non-null but is null");
            }
            this.decompressed = decompressed;
        }

        @NonNull
        @Generated
        public String decompressed() {
            return this.decompressed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultOfDecompressZstd)) {
                return false;
            }
            ResultOfDecompressZstd other = (ResultOfDecompressZstd)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$decompressed = this.decompressed();
            String other$decompressed = other.decompressed();
            return !(this$decompressed == null ? other$decompressed != null : !this$decompressed.equals(other$decompressed));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ResultOfDecompressZstd;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $decompressed = this.decompressed();
            result = result * 59 + ($decompressed == null ? 43 : $decompressed.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Utils.ResultOfDecompressZstd(decompressed=" + this.decompressed() + ")";
        }
    }

    public static enum AccountAddressType {
        AccountId,
        Hex,
        Base64;

    }
}

