/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tech.deplant.java4ever.framework.ContractTemplate;
import tech.deplant.java4ever.framework.Solc;
import tech.deplant.java4ever.framework.TvmLinker;
import tech.deplant.java4ever.framework.artifact.Artifact;
import tech.deplant.java4ever.framework.artifact.FileArtifact;

public final class ArtifactConfig {
    @Generated
    private static final Logger log = LogManager.getLogger(ArtifactConfig.class);
    public final String solcPath;
    public final String linkerPath;
    public final String stdLibPath;
    public final String sourcePath;
    public final String buildPath;
    private final Map<String, ContractTemplate> templates = new HashMap<String, ContractTemplate>();

    public ArtifactConfig(Artifact fileArtifact) {
        JsonObject jsonRoot = JsonParser.parseString((String)fileArtifact.getAsJsonString()).getAsJsonObject();
        jsonRoot.get("contracts").getAsJsonArray().iterator().forEachRemaining(elem -> {
            JsonObject obj = elem.getAsJsonObject();
            this.templates.put(obj.get("name").getAsString(), new ContractTemplate(FileArtifact.ofResourcePath(obj.get("abiPath").getAsString()).getAsABI(), FileArtifact.ofResourcePath(obj.get("tvcPath").getAsString()).getAsTVC()));
        });
        this.solcPath = jsonRoot.get("solc").getAsJsonObject().get("path").getAsString();
        this.linkerPath = jsonRoot.get("linker").getAsJsonObject().get("path").getAsString();
        this.stdLibPath = jsonRoot.get("linker").getAsJsonObject().get("stdLibPath").getAsString();
        this.sourcePath = jsonRoot.get("sourcePath").getAsString();
        this.buildPath = jsonRoot.get("buildPath").getAsString();
    }

    public Solc getSolidityCompiler() {
        try {
            return new Solc(this.solcPath);
        }
        catch (Exception e) {
            log.error("Solidity Compiler init failed! " + e.getMessage());
            return null;
        }
    }

    public TvmLinker getTvmLinker() {
        try {
            return new TvmLinker(this.linkerPath, this.stdLibPath);
        }
        catch (Exception e) {
            log.error("Linker init failed! " + e.getMessage());
            return null;
        }
    }

    public ContractTemplate getTemplate(String name) {
        return this.templates.get(name);
    }

    @Generated
    public String solcPath() {
        return this.solcPath;
    }

    @Generated
    public String linkerPath() {
        return this.linkerPath;
    }

    @Generated
    public String stdLibPath() {
        return this.stdLibPath;
    }

    @Generated
    public String sourcePath() {
        return this.sourcePath;
    }

    @Generated
    public String buildPath() {
        return this.buildPath;
    }

    @Generated
    public Map<String, ContractTemplate> templates() {
        return this.templates;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactConfig)) {
            return false;
        }
        ArtifactConfig other = (ArtifactConfig)o;
        String this$solcPath = this.solcPath();
        String other$solcPath = other.solcPath();
        if (this$solcPath == null ? other$solcPath != null : !this$solcPath.equals(other$solcPath)) {
            return false;
        }
        String this$linkerPath = this.linkerPath();
        String other$linkerPath = other.linkerPath();
        if (this$linkerPath == null ? other$linkerPath != null : !this$linkerPath.equals(other$linkerPath)) {
            return false;
        }
        String this$stdLibPath = this.stdLibPath();
        String other$stdLibPath = other.stdLibPath();
        if (this$stdLibPath == null ? other$stdLibPath != null : !this$stdLibPath.equals(other$stdLibPath)) {
            return false;
        }
        String this$sourcePath = this.sourcePath();
        String other$sourcePath = other.sourcePath();
        if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
            return false;
        }
        String this$buildPath = this.buildPath();
        String other$buildPath = other.buildPath();
        if (this$buildPath == null ? other$buildPath != null : !this$buildPath.equals(other$buildPath)) {
            return false;
        }
        Map<String, ContractTemplate> this$templates = this.templates();
        Map<String, ContractTemplate> other$templates = other.templates();
        return !(this$templates == null ? other$templates != null : !((Object)this$templates).equals(other$templates));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $solcPath = this.solcPath();
        result = result * 59 + ($solcPath == null ? 43 : $solcPath.hashCode());
        String $linkerPath = this.linkerPath();
        result = result * 59 + ($linkerPath == null ? 43 : $linkerPath.hashCode());
        String $stdLibPath = this.stdLibPath();
        result = result * 59 + ($stdLibPath == null ? 43 : $stdLibPath.hashCode());
        String $sourcePath = this.sourcePath();
        result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
        String $buildPath = this.buildPath();
        result = result * 59 + ($buildPath == null ? 43 : $buildPath.hashCode());
        Map<String, ContractTemplate> $templates = this.templates();
        result = result * 59 + ($templates == null ? 43 : ((Object)$templates).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArtifactConfig(solcPath=" + this.solcPath() + ", linkerPath=" + this.linkerPath() + ", stdLibPath=" + this.stdLibPath() + ", sourcePath=" + this.sourcePath() + ", buildPath=" + this.buildPath() + ", templates=" + this.templates() + ")";
    }
}

