/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.Crypto;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Data;
import tech.deplant.java4ever.framework.FileData;
import tech.deplant.java4ever.framework.Sdk;

public final class Credentials {
    @Generated
    private static final Logger log = LogManager.getLogger(Credentials.class);
    public static final Credentials NONE = new Credentials("0000000000000000000000000000000000000000000000000000000000000000", "0000000000000000000000000000000000000000000000000000000000000000");
    @SerializedName(value="public")
    private final String publicKey;
    @SerializedName(value="secret")
    private final String secretKey;

    private static String generateEntropy(Sdk sdk) throws Sdk.SdkException {
        return ((Crypto.ResultOfGenerateRandomBytes)sdk.syncCall(Crypto.generateRandomBytes((Context)sdk.context(), (Number)512))).bytes();
    }

    private static String generateSeedOfEntropy(Sdk sdk, Number words, String entropyBase64) throws Sdk.SdkException {
        return ((Crypto.ResultOfMnemonicFromEntropy)sdk.syncCall(Crypto.mnemonicFromEntropy((Context)sdk.context(), (String)Data.base64ToHexString(entropyBase64).toUpperCase(Locale.ROOT), null, (Number)words))).phrase();
    }

    private static String generateSeedOfRandom(Sdk sdk, Number words) throws Sdk.SdkException {
        return Credentials.generateSeedOfEntropy(sdk, words, Credentials.generateEntropy(sdk));
    }

    public static String generateSeed12(Sdk sdk) throws Sdk.SdkException {
        return Credentials.generateSeedOfRandom(sdk, 12);
    }

    public static String generateSeed24(Sdk sdk) throws Sdk.SdkException {
        return Credentials.generateSeedOfRandom(sdk, 24);
    }

    public static Credentials ofStored(String path) {
        String str = null;
        try {
            str = FileData.jsonFromFile(path);
        }
        catch (IOException e) {
            log.error("Path: {}, Error: {}", new Supplier[]{() -> path, () -> e.getMessage()});
            return null;
        }
        JsonObject jsonRoot = JsonParser.parseString((String)ContractAbi.SAFE_MULTISIG.abiJsonString()).getAsJsonObject();
        return new Credentials(jsonRoot.get("public").getAsString(), jsonRoot.get("secret").getAsString());
    }

    public static Credentials ofRandom(Sdk sdk) throws Sdk.SdkException {
        Crypto.KeyPair randomPair = (Crypto.KeyPair)sdk.syncCall(Crypto.generateRandomSignKeys((Context)sdk.context()));
        return new Credentials(randomPair.publicKey(), randomPair.secretKey());
    }

    private static Credentials ofSeed(Sdk sdk, String seed, Number words) throws Sdk.SdkException {
        if (((Crypto.ResultOfMnemonicVerify)sdk.syncCall(Crypto.mnemonicVerify((Context)sdk.context(), (String)seed, null, (Number)words))).valid().booleanValue()) {
            Crypto.KeyPair pairFromSeed = (Crypto.KeyPair)sdk.syncCall(Crypto.mnemonicDeriveSignKeys((Context)sdk.context(), (String)seed, null, null, (Number)words));
            return new Credentials(pairFromSeed.publicKey(), pairFromSeed.secretKey());
        }
        throw new RuntimeException("Seed/mnemonic phrase checksum is not valid.");
    }

    public static Credentials ofSeed12(Sdk sdk, String seed) throws Sdk.SdkException {
        return Credentials.ofSeed(sdk, seed, 12);
    }

    public static Credentials ofSeed24(Sdk sdk, String seed) throws Sdk.SdkException {
        return Credentials.ofSeed(sdk, seed, 24);
    }

    public Abi.Signer signer() {
        return new Abi.Signer.Keys(this.keyPair());
    }

    public Crypto.KeyPair keyPair() {
        return new Crypto.KeyPair(this.publicKey, this.secretKey);
    }

    public String publicKeyTonSafe(Sdk sdk) throws Sdk.SdkException {
        return ((Crypto.ResultOfConvertPublicKeyToTonSafeFormat)sdk.syncCall(Crypto.convertPublicKeyToTonSafeFormat((Context)sdk.context(), (String)this.publicKey))).tonPublicKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(String path) throws IOException {
        FileWriter file = new FileWriter(path);
        try {
            file.write(new Gson().toJson((Object)this));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            file.flush();
            file.close();
        }
    }

    @Generated
    public Credentials(String publicKey, String secretKey) {
        this.publicKey = publicKey;
        this.secretKey = secretKey;
    }

    @Generated
    public String publicKey() {
        return this.publicKey;
    }

    @Generated
    public String secretKey() {
        return this.secretKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Credentials)) {
            return false;
        }
        Credentials other = (Credentials)o;
        String this$publicKey = this.publicKey();
        String other$publicKey = other.publicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        String this$secretKey = this.secretKey();
        String other$secretKey = other.secretKey();
        return !(this$secretKey == null ? other$secretKey != null : !this$secretKey.equals(other$secretKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $publicKey = this.publicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        String $secretKey = this.secretKey();
        result = result * 59 + ($secretKey == null ? 43 : $secretKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Credentials(publicKey=" + this.publicKey() + ", secretKey=" + this.secretKey() + ")";
    }
}

