/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class FileData {
    @Generated
    private static final Logger log = LogManager.getLogger(FileData.class);
    public static final String CONTRACTS_PATH = "/artifacts";

    public static String storedContractPath(String fileName) {
        return "/artifacts/" + fileName;
    }

    public static byte[] bytesFromFile(String path) throws IOException {
        return Files.readAllBytes(Paths.get(path, new String[0]));
    }

    public static String stringFromFile(String path) throws IOException {
        log.trace("Accessing file:" + path);
        try {
            return Files.readString(Paths.get(FileData.class.getClassLoader().getResource(path).toURI()), StandardCharsets.UTF_8);
        }
        catch (URISyntaxException e) {
            log.error("Wrong path: " + path + "Error: " + e.getMessage());
            return null;
        }
    }

    public static String jsonFromFile(String path) throws IOException {
        return FileData.stringFromFile(path).replaceAll("[\u0000-\u001f]", "");
    }

    public static String fileToBase64String(String path) {
        try {
            return Base64.getEncoder().encodeToString(FileData.bytesFromFile(path));
        }
        catch (IOException e) {
            log.error("Path: {}, Error: {}", new Supplier[]{() -> path, () -> e.getMessage()});
            return "";
        }
    }
}

