/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.google.gson.Gson;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tech.deplant.java4ever.binding.Client;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.loader.LibraryLoader;

public final class Sdk {
    @Generated
    private static final Logger log = LogManager.getLogger(Sdk.class);
    private final Context context;
    private final long timeout;
    private final Double version;

    public static Sdk fromContext(Context context, long timeout) {
        try {
            String verString = ((Client.ResultOfVersion)Client.version((Context)context).get(timeout, TimeUnit.SECONDS)).version();
            Double ver2 = Double.valueOf(verString.substring(0, verString.lastIndexOf(".")));
            return new Sdk(context, timeout, ver2);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Sdk fromConfig(LibraryLoader loader, Context.Config config, long timeout) {
        return Sdk.fromContext(new Context(loader, config.toJson()), timeout);
    }

    public static Sdk fromDefault(LibraryLoader loader) {
        return Sdk.fromContext(new Context(loader, "{}"), 30L);
    }

    public static Sdk fromEndpoints(LibraryLoader loader, String[] endpoints, long timeout) {
        return Sdk.fromConfig(loader, new Context.Config(new Context.NetworkConfig(endpoints, null, null, null, null, null, null, null, null), null, null), timeout);
    }

    public <T> T syncCall(CompletableFuture<T> future) throws SdkException {
        SdkException[] exSdk = new SdkException[1];
        try {
            return future.get(this.timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.error("Library call interrupted! " + e.getMessage());
            throw new SdkException(new Error(-499, "Library request interrupted!"));
        }
        catch (ExecutionException e) {
            log.error(e.getCause().getMessage());
            throw new SdkException((Error)new Gson().fromJson(e.getCause().getMessage(), Error.class));
        }
        catch (TimeoutException e) {
            log.error("Library call timeout! " + e.getMessage());
            throw new SdkException(new Error(-408, "Library request timeout!"));
        }
    }

    @Generated
    public Sdk(Context context, long timeout, Double version) {
        this.context = context;
        this.timeout = timeout;
        this.version = version;
    }

    @Generated
    public Context context() {
        return this.context;
    }

    @Generated
    public long timeout() {
        return this.timeout;
    }

    @Generated
    public Double version() {
        return this.version;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sdk)) {
            return false;
        }
        Sdk other = (Sdk)o;
        if (this.timeout() != other.timeout()) {
            return false;
        }
        Double this$version = this.version();
        Double other$version = other.version();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        Context this$context = this.context();
        Context other$context = other.context();
        return !(this$context == null ? other$context != null : !this$context.equals(other$context));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timeout = this.timeout();
        result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
        Double $version = this.version();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        Context $context = this.context();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Sdk(context=" + this.context() + ", timeout=" + this.timeout() + ", version=" + this.version() + ")";
    }

    public static final class SdkException
    extends RuntimeException {
        private final Error error;

        @Override
        public String toString() {
            return "Code: " + this.error.code() + "\nMessage: " + this.error.message();
        }

        @Generated
        public SdkException(Error error) {
            this.error = error;
        }

        @Generated
        public Error error() {
            return this.error;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SdkException)) {
                return false;
            }
            SdkException other = (SdkException)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Error this$error = this.error();
            Error other$error = other.error();
            return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SdkException;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Error $error = this.error();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            return result;
        }
    }

    public static final class Error {
        private final int code;
        private final String message;

        @Generated
        public Error(int code, String message) {
            this.code = code;
            this.message = message;
        }

        @Generated
        public int code() {
            return this.code;
        }

        @Generated
        public String message() {
            return this.message;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Error)) {
                return false;
            }
            Error other = (Error)o;
            if (this.code() != other.code()) {
                return false;
            }
            String this$message = this.message();
            String other$message = other.message();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.code();
            String $message = this.message();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Sdk.Error(code=" + this.code() + ", message=" + this.message() + ")";
        }
    }
}

