/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TvmLinker {
    @Generated
    private static final Logger log = LogManager.getLogger(TvmLinker.class);
    private final String linkerPath;
    private final String stdlibSolPath;

    public TvmLinker(String linkerPath, String stdlibSolPath) {
        if (!Files.exists(Path.of(linkerPath, new String[0]), new LinkOption[0]) && !Files.exists(Path.of(linkerPath + ".exe", new String[0]), new LinkOption[0]) || !Files.exists(Path.of(stdlibSolPath, new String[0]), new LinkOption[0])) {
            log.error("ERROR! Linker executable not found at specified path!");
            throw new RuntimeException();
        }
        this.linkerPath = linkerPath;
        this.stdlibSolPath = stdlibSolPath;
    }

    public CompletableFuture<Process> assemblyContract(String contractName, String buildFolder) {
        return this.assemblyContract(buildFolder + "/" + contractName + ".code", buildFolder + "/" + contractName + ".abi.json", buildFolder + "/" + contractName + ".tvc");
    }

    public CompletableFuture<Process> assemblyContract(String codePath, String abiPath, String outputPath) {
        try {
            log.info("Begging assembly of TVM Assembly source...");
            Process p = new ProcessBuilder(new String[0]).inheritIO().command(this.linkerPath, "compile", "-o", outputPath, "--lib", this.stdlibSolPath, "--abi-json", abiPath, codePath).start();
            return p.onExit();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return CompletableFuture.failedFuture(new RuntimeException(e.getMessage()));
        }
    }

    @Generated
    public String linkerPath() {
        return this.linkerPath;
    }

    @Generated
    public String stdlibSolPath() {
        return this.stdlibSolPath;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TvmLinker)) {
            return false;
        }
        TvmLinker other = (TvmLinker)o;
        String this$linkerPath = this.linkerPath();
        String other$linkerPath = other.linkerPath();
        if (this$linkerPath == null ? other$linkerPath != null : !this$linkerPath.equals(other$linkerPath)) {
            return false;
        }
        String this$stdlibSolPath = this.stdlibSolPath();
        String other$stdlibSolPath = other.stdlibSolPath();
        return !(this$stdlibSolPath == null ? other$stdlibSolPath != null : !this$stdlibSolPath.equals(other$stdlibSolPath));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $linkerPath = this.linkerPath();
        result = result * 59 + ($linkerPath == null ? 43 : $linkerPath.hashCode());
        String $stdlibSolPath = this.stdlibSolPath();
        result = result * 59 + ($stdlibSolPath == null ? 43 : $stdlibSolPath.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TvmLinker(linkerPath=" + this.linkerPath() + ", stdlibSolPath=" + this.stdlibSolPath() + ")";
    }
}

