/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.type;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigInteger;

public class UintBigIntegerAdapter
implements JsonSerializer<BigInteger>,
JsonDeserializer<BigInteger> {
    public JsonElement serialize(BigInteger src, Type srcType, JsonSerializationContext context) {
        return new JsonPrimitive("0x" + src.toString(16));
    }

    public BigInteger deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        String str = json.getAsString();
        if (str.length() >= 2 && "0x".equals(str.substring(0, 2))) {
            str = str.substring(2);
            return new BigInteger(str, 16);
        }
        return new BigInteger(str, 10);
    }
}

