/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.template;

import java.math.BigInteger;
import java.util.Map;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Boc;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.Processing;
import tech.deplant.java4ever.framework.Account;
import tech.deplant.java4ever.framework.Address;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.abi.ContractAbi;
import tech.deplant.java4ever.framework.contract.Giver;
import tech.deplant.java4ever.framework.contract.OwnedContract;
import tech.deplant.java4ever.framework.crypto.Credentials;
import tech.deplant.java4ever.framework.template.ContractTvc;

public class ContractTemplate {
    private static System.Logger logger = System.getLogger(ContractTemplate.class.getName());
    private final ContractAbi abi;
    private final ContractTvc tvc;

    public ContractTemplate(ContractAbi abi, ContractTvc tvc) {
        this.abi = abi;
        this.tvc = tvc;
    }

    public ContractAbi abi() {
        return this.abi;
    }

    public ContractTvc tvc() {
        return this.tvc;
    }

    protected OwnedContract doDeploy(Sdk sdk, int workchainId, Address address, Map<String, Object> initialData, Credentials credentials, Map<String, Object> constructorInputs) throws EverSdkException {
        Processing.processMessage((Context)sdk.context(), (Abi.ABI)this.abi().ABI(), null, (Abi.DeploySet)new Abi.DeploySet(this.tvc.base64String(), (Number)workchainId, this.abi().convertInitDataInputs(initialData), credentials.publicKey()), (Abi.CallSet)new Abi.CallSet("constructor", null, this.abi().convertFunctionInputs("constructor", constructorInputs)), (Abi.Signer)credentials.signer(), null, (Boolean)false, null);
        return new OwnedContract(sdk, address, this.abi, credentials);
    }

    public OwnedContract deploy(Sdk sdk, int workchainId, Map<String, Object> initialData, Credentials credentials, Map<String, Object> constructorInputs) throws EverSdkException {
        Address address = Address.ofFutureDeploy(sdk, this, 0, initialData, credentials);
        logger.log(System.Logger.Level.INFO, () -> "Future address: " + address.makeAddrStd());
        return this.doDeploy(sdk, workchainId, address, initialData, credentials, constructorInputs);
    }

    public OwnedContract deployWithGiver(Sdk sdk, Giver giver, BigInteger value, int workchainId, Map<String, Object> initialData, Credentials credentials, Map<String, Object> constructorInputs) throws EverSdkException {
        Address address = Address.ofFutureDeploy(sdk, this, 0, initialData, credentials);
        logger.log(System.Logger.Level.INFO, () -> "Future address: " + address.makeAddrStd());
        giver.give(address, value);
        return this.doDeploy(sdk, workchainId, address, initialData, credentials, constructorInputs);
    }

    public Map<String, Object> decodeInitialData(Sdk sdk) throws EverSdkException {
        return this.tvc().decodeInitialData(sdk, this.abi());
    }

    public String decodeInitialPubkey(Sdk sdk) throws EverSdkException {
        return this.tvc().decodeInitialPubkey(sdk, this.abi());
    }

    public Address calculateAddress(Sdk sdk) throws EverSdkException {
        return new Address("0:" + Boc.getBocHash((Context)sdk.context(), (String)this.tvc().base64String()).hash());
    }

    public boolean isDeployed(Sdk sdk) throws EverSdkException {
        return Account.ofAddress(sdk, this.calculateAddress(sdk)).isActive();
    }

    public ContractTemplate withUpdatedInitialData(Sdk sdk, Map<String, Object> initialData, String publicKey) throws EverSdkException {
        return new ContractTemplate(this.abi(), this.tvc().withUpdatedInitialData(sdk, this.abi(), initialData, publicKey));
    }
}

