/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.ContextBuilder;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.artifact.JsonFile;
import tech.deplant.java4ever.framework.artifact.JsonResource;
import tech.deplant.java4ever.framework.datatype.AbiType;
import tech.deplant.java4ever.framework.datatype.TypePrefix;
import tech.deplant.java4ever.framework.datatype.Uint;
import tech.deplant.java4ever.utils.regex.AnyOf;
import tech.deplant.java4ever.utils.regex.GroupOf;
import tech.deplant.java4ever.utils.regex.Occurences;
import tech.deplant.java4ever.utils.regex.RegExpBuilder;
import tech.deplant.java4ever.utils.regex.Special;
import tech.deplant.java4ever.utils.regex.Symbol;
import tech.deplant.java4ever.utils.regex.Then;
import tech.deplant.java4ever.utils.regex.Word;

public record ContractAbi(Abi.AbiContract abiContract) {
    private static final System.Logger logger = System.getLogger(ContractAbi.class.getName());

    public static ContractAbi ofString(String jsonString) throws JsonProcessingException {
        return new ContractAbi((Abi.AbiContract)ContextBuilder.DEFAULT_MAPPER.readValue(jsonString, Abi.AbiContract.class));
    }

    public static ContractAbi ofResource(String resourceName) throws JsonProcessingException {
        return ContractAbi.ofString(new JsonResource(resourceName).get());
    }

    public static ContractAbi ofFile(String filePath) throws JsonProcessingException {
        return ContractAbi.ofString(new JsonFile(filePath).get());
    }

    public static ContractAbi ofJsonNode(JsonNode node) throws JsonProcessingException {
        return ContractAbi.ofString(ContextBuilder.DEFAULT_MAPPER.writeValueAsString((Object)node));
    }

    public static AbiTypeDetails typeParser(String typeString) throws EverSdkException {
        Pattern expr = new Then(new RegExpBuilder[]{new GroupOf((RegExpBuilder)new Occurences((RegExpBuilder)new AnyOf(new Word((CharSequence)"a-zA-Z")), Integer.valueOf(1))), new GroupOf((RegExpBuilder)new Occurences((RegExpBuilder)Special.DIGIT, Integer.valueOf(1), Integer.valueOf(3)))}).toPattern();
        Matcher matcher = expr.matcher(typeString);
        if (matcher.find()) {
            return new AbiTypeDetails(TypePrefix.valueOf(matcher.group(1).toUpperCase()), Integer.parseInt(matcher.group(2)), ContractAbi.arrayMatcher(typeString));
        }
        matcher = Pattern.compile("([a-zA-Z]+)").matcher(typeString);
        if (matcher.find()) {
            return new AbiTypeDetails(TypePrefix.valueOf(matcher.group(1).toUpperCase()), 0, ContractAbi.arrayMatcher(typeString));
        }
        EverSdkException ex = new EverSdkException(new EverSdkException.ErrorResult(-300, "ABI Type parsing failed! Type: " + typeString), (Throwable)new RuntimeException());
        logger.log(System.Logger.Level.WARNING, () -> ex.toString());
        throw ex;
    }

    public static boolean arrayMatcher(String typeString) {
        Pattern arrayPattern = new Then(new RegExpBuilder[]{new GroupOf((RegExpBuilder)new Then(new RegExpBuilder[]{new Occurences((RegExpBuilder)new AnyOf(new Word((CharSequence)"a-zA-Z")), Integer.valueOf(1)), new Occurences((RegExpBuilder)Special.DIGIT, Integer.valueOf(0), Integer.valueOf(3))})), new GroupOf((RegExpBuilder)new Then(new RegExpBuilder[]{new Symbol('['), new Symbol(']')}))}).toPattern();
        Matcher matcher = arrayPattern.matcher(typeString);
        return matcher.find();
    }

    public String json() throws JsonProcessingException {
        return ContextBuilder.DEFAULT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL).writeValueAsString((Object)this.abiContract());
    }

    public String functionId(Sdk sdk, String name) throws EverSdkException {
        return Uint.fromJava(32, Abi.calcFunctionId((Context)sdk.context(), (Abi.ABI)this.ABI(), (String)name, (Boolean)false).functionId()).toABI();
    }

    public boolean hasHeader(String name) {
        return Arrays.asList(this.header()).contains(name);
    }

    public boolean hasFunction(String name) {
        return Arrays.stream(this.functions()).anyMatch(function -> name.equals(function.name()));
    }

    public boolean hasInitDataParam(String initDataName) {
        return Arrays.stream(this.data()).anyMatch(data -> initDataName.equals(data.name()));
    }

    public boolean hasInput(String functionName, String inputName) {
        return Arrays.stream(this.functions()).anyMatch(function -> functionName.equals(function.name()) && Arrays.stream(function.inputs()).anyMatch(input -> inputName.equals(input.name())));
    }

    public boolean hasOutput(String functionName, String outputName) {
        return Arrays.stream(this.functions()).anyMatch(function -> functionName.equals(function.name()) && Arrays.stream(function.outputs()).anyMatch(output -> outputName.equals(output.name())));
    }

    private Abi.AbiFunction findFunction(Abi.AbiFunction[] functionArr, String name) {
        return Arrays.stream(functionArr).filter(function -> name.equals(function.name())).findAny().orElseThrow();
    }

    private Abi.AbiEvent findEvent(Abi.AbiEvent[] functionArr, String name) {
        return Arrays.stream(functionArr).filter(event -> name.equals(event.name())).findAny().orElseThrow();
    }

    private Abi.AbiParam findParam(Abi.AbiParam[] paramArr, String name) {
        return Arrays.stream(paramArr).filter(input -> name.equals(input.name())).findAny().orElseThrow();
    }

    public Abi.AbiParam functionInputType(String functionName, String inputName) {
        return this.findParam(this.findFunction(this.functions(), functionName).inputs(), inputName);
    }

    public Abi.AbiParam initDataType(String initDataName) {
        Abi.AbiData dataParam = Arrays.stream(this.data()).filter(data -> initDataName.equals(data.name())).findAny().orElseThrow();
        return new Abi.AbiParam(dataParam.name(), dataParam.type(), dataParam.components());
    }

    public Abi.AbiParam functionOutputType(String functionName, String outputName) {
        return this.findParam(this.findFunction(this.functions(), functionName).outputs(), outputName);
    }

    public Abi.AbiParam eventInputType(String functionName, String inputName) {
        return this.findParam(this.findEvent(this.events(), functionName).inputs(), inputName);
    }

    public Abi.AbiData[] data() {
        return this.abiContract().data();
    }

    public Abi.AbiFunction[] functions() {
        return this.abiContract().functions();
    }

    public Abi.AbiEvent[] events() {
        return this.abiContract().events();
    }

    public String[] header() {
        return this.abiContract().header();
    }

    public Abi.ABI ABI() {
        return new Abi.ABI.Contract(this.abiContract());
    }

    protected Object serializeTree(Abi.AbiParam param, Object inputValue) throws EverSdkException {
        String typeStringPattern = "([a-zA-Z]+\\d{0,3}\\[?\\]?)";
        Pattern mapPattern = Pattern.compile("(map\\()" + typeStringPattern + "(,)" + typeStringPattern + "(\\))");
        boolean rootIsMap = false;
        String rootTypeString = param.type();
        String keyTypeString = null;
        String valueTypeString = null;
        logger.log(System.Logger.Level.TRACE, () -> "param: " + param.name() + " ( " + param.type() + " -> " + rootTypeString + " ): " + String.valueOf(inputValue));
        Matcher matcher = mapPattern.matcher(rootTypeString);
        while (matcher.find()) {
            rootIsMap = true;
            keyTypeString = matcher.group(2);
            valueTypeString = matcher.group(4);
        }
        if (rootIsMap) {
            AbiTypeDetails keyDetails = ContractAbi.typeParser(keyTypeString);
            Map mapValue = (Map)inputValue;
            if (mapValue.size() == 1) {
                Object key = mapValue.keySet().toArray()[0];
                Object value = mapValue.values().toArray()[0];
                return Map.of(AbiType.of(keyDetails.type(), keyDetails.size(), key).toABI(), this.serializeTree(new Abi.AbiParam(valueTypeString, valueTypeString, param.components()), value));
            }
            EverSdkException ex = new EverSdkException(new EverSdkException.ErrorResult(-302, "ABI Type Conversion fails. Wrong argument! Too many keys provided for single map(type,type) " + String.valueOf(mapValue)), (Throwable)new RuntimeException());
            logger.log(System.Logger.Level.WARNING, () -> ex.toString());
            throw ex;
        }
        AbiTypeDetails rootDetails = ContractAbi.typeParser(rootTypeString);
        if (rootDetails.type().equals((Object)TypePrefix.TUPLE)) {
            Map mapValue = (Map)inputValue;
            return Arrays.stream(param.components()).collect(Collectors.toMap(component -> component.name(), component -> {
                try {
                    return this.serializeTree((Abi.AbiParam)component, mapValue.get(component.name()));
                }
                catch (EverSdkException e) {
                    return mapValue.get(component.name());
                }
            }));
        }
        if (rootDetails.isArray()) {
            Object[] objectArray;
            Object object = inputValue;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Object[].class, List.class}, (Object)object2, n)) {
                case 0: {
                    String s = (String)object2;
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = AbiType.of(rootDetails.type(), rootDetails.size(), s).toABI();
                    break;
                }
                case 1: {
                    Object[] arr = (Object[])object2;
                    objectArray = Arrays.stream(arr).map(element -> {
                        try {
                            return AbiType.of(rootDetails.type(), rootDetails.size(), element).toABI();
                        }
                        catch (EverSdkException e) {
                            return element;
                        }
                    }).toArray();
                    break;
                }
                case 2: {
                    List list = (List)object2;
                    objectArray = list.stream().map(element -> {
                        try {
                            return AbiType.of(rootDetails.type(), rootDetails.size(), element).toABI();
                        }
                        catch (EverSdkException e) {
                            return element;
                        }
                    }).toArray();
                    break;
                }
                default: {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = AbiType.of(rootDetails.type(), rootDetails.size(), inputValue).toABI();
                }
            }
            return objectArray;
        }
        return AbiType.of(rootDetails.type(), rootDetails.size(), inputValue).toABI();
    }

    public Map<String, Object> convertFunctionInputs(String functionName, Map<String, Object> functionInputs) throws EverSdkException {
        if (functionInputs != null) {
            HashMap<String, Object> convertedInputs = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : functionInputs.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (this.hasInput(functionName, key)) {
                    Abi.AbiParam type = this.functionInputType(functionName, key);
                    try {
                        convertedInputs.put(key, this.serializeTree(type, value));
                    }
                    catch (EverSdkException e) {
                        convertedInputs.put(key, value);
                    }
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, () -> "ABI Function " + functionName + " doesn't contain input '" + key + "'");
                throw new EverSdkException(new EverSdkException.ErrorResult(-303, "Function " + functionName + " doesn't contain input (" + key + ") in ABI"), (Throwable)new Exception());
            }
            return convertedInputs;
        }
        return null;
    }

    public Map<String, Object> convertInitDataInputs(Map<String, Object> initDataInputs) throws EverSdkException {
        if (initDataInputs != null) {
            HashMap<String, Object> convertedInputs = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : initDataInputs.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (this.hasInitDataParam(key)) {
                    Abi.AbiParam type = this.initDataType(key);
                    try {
                        convertedInputs.put(key, this.serializeTree(type, value));
                    }
                    catch (EverSdkException e) {
                        convertedInputs.put(key, value);
                    }
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, () -> "ABI doesn't contain initData parameter '" + key + "'");
                throw new EverSdkException(new EverSdkException.ErrorResult(-304, "ABI doesn't contain initData parameter '" + key + "'"), (Throwable)new Exception());
            }
            return convertedInputs;
        }
        return null;
    }

    public record AbiTypeDetails(TypePrefix type, int size, boolean isArray) {
    }
}

