/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tech.deplant.java4ever.binding.ContextBuilder;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.LogUtils;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.artifact.Artifact;
import tech.deplant.java4ever.framework.artifact.JsonFile;
import tech.deplant.java4ever.framework.artifact.JsonResource;
import tech.deplant.java4ever.framework.contract.Contract;

public record OnchainConfig(Artifact<String, String> artifact, OnchainInfo info) {
    private static System.Logger logger = System.getLogger(OnchainConfig.class.getName());

    public static OnchainConfig LOAD_IF_EXISTS(String serializationPath) throws IOException {
        OnchainConfig conf = null;
        try {
            conf = OnchainConfig.LOAD(serializationPath);
        }
        catch (Exception e) {
            conf = OnchainConfig.EMPTY(serializationPath);
            LogUtils.warn(logger, e.getMessage());
        }
        return conf;
    }

    public static OnchainConfig EMPTY(String serializationPath) throws IOException {
        Path path = Paths.get(serializationPath, new String[0]);
        Record jsonArtifact = null;
        switch (Artifact.pathType(serializationPath)) {
            case ABSOLUTE: 
            case RELATIONAL: {
                jsonArtifact = new JsonFile(serializationPath);
                break;
            }
            case RESOURCE: {
                jsonArtifact = new JsonResource(serializationPath);
            }
        }
        OnchainConfig config = new OnchainConfig((Artifact<String, String>)((Object)jsonArtifact), new OnchainInfo(new ConcurrentHashMap<String, SavedContract>(), new ConcurrentHashMap<String, Credentials>()));
        config.sync();
        return config;
    }

    public static OnchainConfig LOAD(String serializationPath) throws JsonProcessingException {
        ObjectMapper mapper = ContextBuilder.DEFAULT_MAPPER;
        Record jsonArtifact = null;
        switch (Artifact.pathType(serializationPath)) {
            case ABSOLUTE: 
            case RELATIONAL: {
                jsonArtifact = new JsonFile(serializationPath);
                break;
            }
            case RESOURCE: {
                jsonArtifact = new JsonResource(serializationPath);
            }
        }
        return new OnchainConfig((Artifact<String, String>)((Object)jsonArtifact), (OnchainInfo)mapper.readValue((String)jsonArtifact.get(), OnchainInfo.class));
    }

    public Credentials keys(String keysName) {
        return this.info().credentials().get(keysName);
    }

    public String address(String contractName) {
        return this.info().contracts().get(contractName).address();
    }

    public ContractAbi abi(String contractName) throws JsonProcessingException {
        return ContractAbi.ofString(this.info().contracts().get(contractName).abiJson());
    }

    public <T> T contract(Class<T> clazz, Sdk sdk, String contractName, String keysName) throws JsonProcessingException {
        return Contract.instantiate(clazz, sdk, this.address(contractName), this.abi(contractName), this.keys(keysName));
    }

    public <T> T contract(Class<T> clazz, Sdk sdk, String contractName) throws JsonProcessingException {
        return Contract.instantiate(clazz, sdk, this.address(contractName), this.abi(contractName), Credentials.NONE);
    }

    public Contract addContract(String name, Contract contract) throws IOException {
        this.info().contracts().put(name, new SavedContract(contract.abi().json(), contract.address()));
        this.sync();
        return contract;
    }

    public Credentials addKeys(String name, Credentials keys) throws IOException {
        this.info().credentials().put(name, keys);
        this.sync();
        return keys;
    }

    public void sync() throws IOException {
        ObjectMapper mapper = ContextBuilder.DEFAULT_MAPPER;
        this.artifact().accept(mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.info()));
    }

    public record OnchainInfo(Map<String, SavedContract> contracts, Map<String, Credentials> credentials) {
    }

    public record SavedContract(String abiJson, String address) {
    }
}

