/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.datatype;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import tech.deplant.java4ever.binding.Boc;
import tech.deplant.java4ever.binding.Context;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.datatype.AbiType;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.SolBytes;
import tech.deplant.java4ever.framework.datatype.SolString;
import tech.deplant.java4ever.framework.datatype.TvmCell;
import tech.deplant.java4ever.framework.datatype.TypePrefix;
import tech.deplant.java4ever.framework.datatype.Uint;

public class TvmBuilder {
    private final AtomicInteger refCounter = new AtomicInteger(0);
    private final List<Boc.BuilderOp> operations = new ArrayList<Boc.BuilderOp>();

    public Boc.BuilderOp[] builders() {
        return (Boc.BuilderOp[])this.operations.toArray(Boc.BuilderOp[]::new);
    }

    public void store(AbiType ... types) throws EverSdkException {
        for (AbiType type : types) {
            AbiType abiType;
            Objects.requireNonNull(type);
            int n = 0;
            this.operations.add((Boc.BuilderOp)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Uint.class, Address.class, SolString.class, SolBytes.class, TvmBuilder.class}, (Object)abiType, n)) {
                case 0 -> {
                    BigInteger var11_11;
                    int var11_12 = TvmBuilder.$proxy$size((Uint)abiType);
                    int size = var11_12;
                    BigInteger bigInteger = var11_11 = TvmBuilder.$proxy$bigInteger((Uint)abiType);
                    Uint intVal = (Uint)abiType;
                    yield new Boc.BuilderOp.Integer(Integer.valueOf(size), intVal.toABI());
                }
                case 1 -> {
                    Address addr = (Address)abiType;
                    yield new Boc.BuilderOp.Address(addr.toABI());
                }
                case 2 -> {
                    SolString str = (SolString)abiType;
                    this.incrementRefCounter();
                    yield new Boc.BuilderOp.Cell(new Boc.BuilderOp[]{new Boc.BuilderOp.BitString(str.toABI())});
                }
                case 3 -> {
                    SolBytes byt = (SolBytes)abiType;
                    this.incrementRefCounter();
                    yield new Boc.BuilderOp.Cell(new Boc.BuilderOp[]{new Boc.BuilderOp.BitString(byt.toABI())});
                }
                case 4 -> {
                    TvmBuilder builder = (TvmBuilder)((Object)abiType);
                    this.incrementRefCounter();
                    yield new Boc.BuilderOp.Cell(builder.builders());
                }
                default -> throw new EverSdkException(new EverSdkException.ErrorResult(-305, "Builder of TvmCell doesn't support this type for ABI conversion"), (Throwable)new Exception());
            }));
        }
    }

    private void incrementRefCounter() throws EverSdkException {
        int refCount = this.refCounter.incrementAndGet();
        if (refCount > 4) {
            throw new EverSdkException(new EverSdkException.ErrorResult(-306, "TvmCell can't contain more than 4 references to other TvmCells"));
        }
    }

    public TvmBuilder store(TypePrefix prefix, int size, Object inputValue) throws EverSdkException {
        this.store(AbiType.of(prefix, size, inputValue));
        return this;
    }

    public TvmCell toCell(Sdk sdk) throws EverSdkException {
        return new TvmCell(Boc.encodeBoc((Context)sdk.context(), (Boc.BuilderOp[])this.builders(), null).boc());
    }

    private static /* synthetic */ int $proxy$size(Uint arg0) {
        try {
            return arg0.size();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private static /* synthetic */ BigInteger $proxy$bigInteger(Uint arg0) {
        try {
            return arg0.bigInteger();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }
}

