/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.Net;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Sdk;

public record Account(String id, int accType, String balance, String boc, String data, String dataHash, String code, String codeHash, String initCodeHash, long last_paid) {
    private static System.Logger logger = System.getLogger(Account.class.getName());

    public static Account ofAddress(Sdk sdk, String address) throws EverSdkException {
        HashMap<String, GraphQLFilter.In> filter = new HashMap<String, GraphQLFilter.In>();
        filter.put("id", new GraphQLFilter.In(new String[]{address}));
        Net.ResultOfQueryCollection result = Net.queryCollection((EverSdkContext)sdk.context(), (String)"accounts", (JsonNode)JsonContext.ABI_JSON_MAPPER().valueToTree(filter), (String)"id acc_type balance boc data data_hash code code_hash init_code_hash last_paid", null, null);
        if (result.result().length > 0) {
            try {
                return (Account)JsonContext.SDK_JSON_MAPPER().readValue(result.result()[0].traverse(), Account.class);
            }
            catch (IOException e) {
                logger.log(System.Logger.Level.ERROR, e);
                return new Account(address, 0, "0x00", null, null, null, null, null, null, 0L);
            }
        }
        return new Account(address, 0, "0x00", null, null, null, null, null, null, 0L);
    }

    public static List<Account> ofAddressList(Sdk sdk, String ... addresses) throws EverSdkException {
        HashMap<String, GraphQLFilter.In> filter = new HashMap<String, GraphQLFilter.In>();
        filter.put("id", new GraphQLFilter.In(addresses));
        return Arrays.stream(Net.queryCollection((EverSdkContext)sdk.context(), (String)"accounts", (JsonNode)JsonContext.ABI_JSON_MAPPER().valueToTree(filter), (String)"id acc_type balance boc data data_hash code code_hash init_code_hash last_paid", null, null).result()).map(obj -> (Account)JsonContext.SDK_JSON_MAPPER().convertValue(obj, Account.class)).toList();
    }

    public Boolean isActive() {
        return 1 == this.accType;
    }

    public String tvmPubkey(Sdk sdk, ContractAbi abi) throws EverSdkException {
        return Abi.decodeInitialData((EverSdkContext)sdk.context(), (Abi.ABI)abi.ABI(), (String)this.data(), (Boolean)false).initialPubkey();
    }

    public static interface GraphQLFilter {

        public record Lt(String lt) implements GraphQLFilter
        {
        }

        public record Gt(String gt) implements GraphQLFilter
        {
        }

        public record Eq(Integer eq) implements GraphQLFilter
        {
        }

        public record In(String[] in) implements GraphQLFilter
        {
        }
    }
}

