/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.datatype;

import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.datatype.AbiType;
import tech.deplant.java4ever.framework.datatype.AbiTypePrefix;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.Bool;
import tech.deplant.java4ever.framework.datatype.SolArray;
import tech.deplant.java4ever.framework.datatype.SolBytes;
import tech.deplant.java4ever.framework.datatype.SolString;
import tech.deplant.java4ever.framework.datatype.SolStruct;
import tech.deplant.java4ever.framework.datatype.TvmBuilder;
import tech.deplant.java4ever.framework.datatype.TvmCell;
import tech.deplant.java4ever.framework.datatype.Uint;

public sealed interface AbiValue<J>
permits Address, Bool, SolArray, SolBytes, SolString, SolStruct, TvmBuilder, TvmCell, Uint {
    public static AbiValue of(AbiType type, Object value) throws EverSdkException {
        return switch (type.prefix()) {
            default -> throw new MatchException(null, null);
            case AbiTypePrefix.UINT, AbiTypePrefix.INT -> Uint.of(type.size(), value);
            case AbiTypePrefix.STRING -> new SolString(String.valueOf(value));
            case AbiTypePrefix.BYTES, AbiTypePrefix.BYTE -> new SolBytes(type.size(), String.valueOf(value));
            case AbiTypePrefix.ADDRESS -> new Address(String.valueOf(value));
            case AbiTypePrefix.BOOL -> new Bool(String.valueOf(value));
            case AbiTypePrefix.CELL, AbiTypePrefix.SLICE, AbiTypePrefix.BUILDER -> new TvmCell(String.valueOf(value));
            case AbiTypePrefix.TUPLE, AbiTypePrefix.OPTIONAL -> {
                EverSdkException ex = new EverSdkException(new EverSdkException.ErrorResult(-301L, "ABI Parsing unexpected! Shouldn't get here!"), (Throwable)new RuntimeException());
                System.getLogger(AbiValue.class.getName()).log(System.Logger.Level.WARNING, () -> ex.toString());
                throw ex;
            }
        };
    }

    public J toJava();

    public Object toABI();

    public AbiType type();
}

