/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import tech.deplant.java4ever.binding.EverSdk;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.Net;
import tech.deplant.java4ever.framework.gql.TransactionStatus;

public class SubscribeHandle
implements AutoCloseable {
    public static final Predicate<JsonNode> TR_SUCCESSFUL = node -> node.get("result").get("transactions").get("status").asInt() == TransactionStatus.FINALIZED.value() && !node.get("result").get("transactions").get("aborted").asBoolean();
    public static final String TRANSACTIONS_SUB = "subscription {\n\t\t\ttransactions(\n\t\t\t\t\tfilter: {\n\t\t\t\t\t\taccount_addr: { eq: \"%s\" }\n\t\t\t\t\t}\n                ) {\n\t\t\t\t%s\n\t\t\t}\n\t\t}\n";
    private static System.Logger logger = System.getLogger(SubscribeHandle.class.getName());
    private final int contextId;
    private final String queryText;
    private final Set<Predicate<JsonNode>> unsubscribeFilters = new HashSet<Predicate<JsonNode>>();
    private final Set<Predicate<JsonNode>> consumeFilters = new HashSet<Predicate<JsonNode>>();
    private final Set<Consumer<JsonNode>> consumers = new HashSet<Consumer<JsonNode>>();
    private long handle;

    public SubscribeHandle(int contextId, String queryText) {
        this.contextId = contextId;
        this.queryText = queryText;
    }

    public static JsonNode singleJsonGetSyncAwait(int contextId, String queryText) throws ExecutionException, InterruptedException, TimeoutException, EverSdkException {
        CompletableFuture node = new CompletableFuture();
        Consumer<JsonNode> consumer = node::complete;
        new SubscribeHandle(contextId, queryText).addEventConsumer(consumer).subscribe();
        return (JsonNode)node.get(300000L, TimeUnit.MILLISECONDS);
    }

    public SubscribeHandle addEventConsumer(Consumer<JsonNode> eventConsumer) {
        this.consumers.add(eventConsumer);
        return this;
    }

    public SubscribeHandle addConsumeFilter(Predicate<JsonNode> consumeFilter) {
        this.consumeFilters.add(consumeFilter);
        return this;
    }

    public SubscribeHandle addUnsubscribeFilter(Predicate<JsonNode> unsubscribeFilter) {
        this.unsubscribeFilters.add(unsubscribeFilter);
        return this;
    }

    public SubscribeHandle subscribe() throws EverSdkException {
        Consumer<JsonNode> subscription = eventJson -> {
            logger.log(System.Logger.Level.TRACE, "Event received: " + String.valueOf(eventJson));
            if (this.testConsumeFilters((JsonNode)eventJson)) {
                if (this.testUnsubscribeFilters((JsonNode)eventJson) && !this.consumers.isEmpty()) {
                    this.unsubscribe();
                }
                this.broadcastToConsumers((JsonNode)eventJson);
            }
        };
        this.handle = ((Net.ResultOfSubscribeCollection)EverSdk.await((CompletableFuture)Net.subscribe((int)this.contextId, (String)this.queryText(), (JsonNode)JsonContext.EMPTY_NODE(), subscription))).handle();
        return this;
    }

    private boolean testUnsubscribeFilters(JsonNode jsonNode) {
        return this.unsubscribeFilters.isEmpty() || this.unsubscribeFilters.stream().anyMatch(flt -> flt.test(jsonNode));
    }

    private boolean testConsumeFilters(JsonNode jsonNode) {
        return this.consumeFilters.isEmpty() || this.consumeFilters.stream().allMatch(flt -> flt.test(jsonNode));
    }

    private void broadcastToConsumers(JsonNode jsonNode) {
        this.consumers.forEach(consumer -> consumer.accept(jsonNode));
    }

    public void unsubscribe() {
        try {
            if (this.handle() > 0L) {
                logger.log(System.Logger.Level.TRACE, () -> "HANDLE:%d Unsubscribing...".formatted(this.handle));
                Net.unsubscribe((int)this.contextId, (Net.ResultOfSubscribeCollection)new Net.ResultOfSubscribeCollection(Long.valueOf(this.handle())));
            }
        }
        catch (EverSdkException e) {
            logger.log(System.Logger.Level.ERROR, () -> "HANDLE:%d Unsubscribe failed!".formatted(this.handle));
        }
    }

    public int contextId() {
        return this.contextId;
    }

    public String queryText() {
        return this.queryText;
    }

    public long handle() {
        return this.handle;
    }

    @Override
    public void close() {
        this.unsubscribe();
    }
}

