/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.contract.multisig;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.math.BigInteger;
import java.util.Map;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.FunctionHandle;
import tech.deplant.java4ever.framework.contract.multisig.MultisigContract;
import tech.deplant.java4ever.framework.contract.multisig.ResultOfGetCustodians;
import tech.deplant.java4ever.framework.contract.multisig.ResultOfGetParameters;
import tech.deplant.java4ever.framework.contract.multisig.ResultOfGetTransaction;
import tech.deplant.java4ever.framework.contract.multisig.ResultOfGetTransactionIds;
import tech.deplant.java4ever.framework.contract.multisig.ResultOfGetTransactions;
import tech.deplant.java4ever.framework.contract.multisig.ResultOfIsConfirmed;
import tech.deplant.java4ever.framework.contract.multisig.ResultOfSubmitTransaction;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.datatype.TvmCell;

public class SafeMultisigWalletContract
extends MultisigContract {
    public SafeMultisigWalletContract(int contextId, String address) throws JsonProcessingException {
        super(contextId, address, SafeMultisigWalletContract.DEFAULT_ABI(), Credentials.NONE);
    }

    public SafeMultisigWalletContract(int contextId, String address, ContractAbi abi) {
        super(contextId, address, abi, Credentials.NONE);
    }

    public SafeMultisigWalletContract(int contextId, String address, Credentials credentials) throws JsonProcessingException {
        super(contextId, address, SafeMultisigWalletContract.DEFAULT_ABI(), credentials);
    }

    @JsonCreator
    public SafeMultisigWalletContract(int contextId, String address, ContractAbi abi, Credentials credentials) {
        super(contextId, address, abi, credentials);
    }

    public static ContractAbi DEFAULT_ABI() throws JsonProcessingException {
        return ContractAbi.ofString("{\"header\":[\"pubkey\",\"time\",\"expire\"],\"functions\":[{\"name\":\"constructor\",\"inputs\":[{\"name\":\"owners\",\"type\":\"uint256[]\"},{\"name\":\"reqConfirms\",\"type\":\"uint8\"}],\"outputs\":[]},{\"name\":\"acceptTransfer\",\"inputs\":[{\"name\":\"payload\",\"type\":\"bytes\"}],\"outputs\":[]},{\"name\":\"sendTransaction\",\"inputs\":[{\"name\":\"dest\",\"type\":\"address\"},{\"name\":\"value\",\"type\":\"uint128\"},{\"name\":\"bounce\",\"type\":\"bool\"},{\"name\":\"flags\",\"type\":\"uint8\"},{\"name\":\"payload\",\"type\":\"cell\"}],\"outputs\":[]},{\"name\":\"submitTransaction\",\"inputs\":[{\"name\":\"dest\",\"type\":\"address\"},{\"name\":\"value\",\"type\":\"uint128\"},{\"name\":\"bounce\",\"type\":\"bool\"},{\"name\":\"allBalance\",\"type\":\"bool\"},{\"name\":\"payload\",\"type\":\"cell\"}],\"outputs\":[{\"name\":\"transId\",\"type\":\"uint64\"}]},{\"name\":\"confirmTransaction\",\"inputs\":[{\"name\":\"transactionId\",\"type\":\"uint64\"}],\"outputs\":[]},{\"name\":\"isConfirmed\",\"inputs\":[{\"name\":\"mask\",\"type\":\"uint32\"},{\"name\":\"index\",\"type\":\"uint8\"}],\"outputs\":[{\"name\":\"confirmed\",\"type\":\"bool\"}]},{\"name\":\"getParameters\",\"inputs\":[],\"outputs\":[{\"name\":\"maxQueuedTransactions\",\"type\":\"uint8\"},{\"name\":\"maxCustodianCount\",\"type\":\"uint8\"},{\"name\":\"expirationTime\",\"type\":\"uint64\"},{\"name\":\"minValue\",\"type\":\"uint128\"},{\"name\":\"requiredTxnConfirms\",\"type\":\"uint8\"}]},{\"name\":\"getTransaction\",\"inputs\":[{\"name\":\"transactionId\",\"type\":\"uint64\"}],\"outputs\":[{\"name\":\"trans\",\"type\":\"tuple\",\"components\":[{\"name\":\"id\",\"type\":\"uint64\"},{\"name\":\"confirmationsMask\",\"type\":\"uint32\"},{\"name\":\"signsRequired\",\"type\":\"uint8\"},{\"name\":\"signsReceived\",\"type\":\"uint8\"},{\"name\":\"creator\",\"type\":\"uint256\"},{\"name\":\"index\",\"type\":\"uint8\"},{\"name\":\"dest\",\"type\":\"address\"},{\"name\":\"value\",\"type\":\"uint128\"},{\"name\":\"sendFlags\",\"type\":\"uint16\"},{\"name\":\"payload\",\"type\":\"cell\"},{\"name\":\"bounce\",\"type\":\"bool\"}]}]},{\"name\":\"getTransactions\",\"inputs\":[],\"outputs\":[{\"name\":\"transactions\",\"type\":\"tuple[]\",\"components\":[{\"name\":\"id\",\"type\":\"uint64\"},{\"name\":\"confirmationsMask\",\"type\":\"uint32\"},{\"name\":\"signsRequired\",\"type\":\"uint8\"},{\"name\":\"signsReceived\",\"type\":\"uint8\"},{\"name\":\"creator\",\"type\":\"uint256\"},{\"name\":\"index\",\"type\":\"uint8\"},{\"name\":\"dest\",\"type\":\"address\"},{\"name\":\"value\",\"type\":\"uint128\"},{\"name\":\"sendFlags\",\"type\":\"uint16\"},{\"name\":\"payload\",\"type\":\"cell\"},{\"name\":\"bounce\",\"type\":\"bool\"}]}]},{\"name\":\"getTransactionIds\",\"inputs\":[],\"outputs\":[{\"name\":\"ids\",\"type\":\"uint64[]\"}]},{\"name\":\"getCustodians\",\"inputs\":[],\"outputs\":[{\"name\":\"custodians\",\"type\":\"tuple[]\",\"components\":[{\"name\":\"index\",\"type\":\"uint8\"},{\"name\":\"pubkey\",\"type\":\"uint256\"}]}]}],\"events\":[{\"name\":\"TransferAccepted\",\"inputs\":[{\"name\":\"payload\",\"type\":\"bytes\"}]}],\"data\":[],\"ABI version\":2}");
    }

    @Override
    public FunctionHandle<Void> acceptTransfer(Byte[] payload) {
        Map<String, Byte[]> params = Map.of("payload", payload);
        return new FunctionHandle<Void>(Void.class, this.contextId(), this.address(), this.abi(), this.credentials(), "acceptTransfer", params, null);
    }

    @Override
    public FunctionHandle<Void> sendTransaction(Address dest, BigInteger value, Boolean bounce, Integer flags, TvmCell payload) {
        Map<String, Object> params = Map.of("dest", dest, "value", value, "bounce", bounce, "flags", flags, "payload", payload);
        return new FunctionHandle<Void>(Void.class, this.contextId(), this.address(), this.abi(), this.credentials(), "sendTransaction", params, null);
    }

    @Override
    public FunctionHandle<ResultOfSubmitTransaction> submitTransaction(Address dest, BigInteger value, Boolean bounce, Boolean allBalance, TvmCell payload) {
        Map<String, Object> params = Map.of("dest", dest, "value", value, "bounce", bounce, "allBalance", allBalance, "payload", payload);
        return new FunctionHandle<ResultOfSubmitTransaction>(ResultOfSubmitTransaction.class, this.contextId(), this.address(), this.abi(), this.credentials(), "submitTransaction", params, null);
    }

    @Override
    public FunctionHandle<Void> confirmTransaction(BigInteger transactionId) {
        Map<String, Object> params = Map.of("transactionId", transactionId);
        return new FunctionHandle<Void>(Void.class, this.contextId(), this.address(), this.abi(), this.credentials(), "confirmTransaction", params, null);
    }

    @Override
    public FunctionHandle<ResultOfIsConfirmed> isConfirmed(Long mask, Integer index) {
        Map<String, Object> params = Map.of("mask", mask, "index", index);
        return new FunctionHandle<ResultOfIsConfirmed>(ResultOfIsConfirmed.class, this.contextId(), this.address(), this.abi(), this.credentials(), "isConfirmed", params, null);
    }

    @Override
    public FunctionHandle<ResultOfGetParameters> getParameters() {
        Map<String, Object> params = Map.of();
        return new FunctionHandle<ResultOfGetParameters>(ResultOfGetParameters.class, this.contextId(), this.address(), this.abi(), this.credentials(), "getParameters", params, null);
    }

    @Override
    public FunctionHandle<ResultOfGetTransaction> getTransaction(BigInteger transactionId) {
        Map<String, Object> params = Map.of("transactionId", transactionId);
        return new FunctionHandle<ResultOfGetTransaction>(ResultOfGetTransaction.class, this.contextId(), this.address(), this.abi(), this.credentials(), "getTransaction", params, null);
    }

    @Override
    public FunctionHandle<ResultOfGetTransactions> getTransactions() {
        Map<String, Object> params = Map.of();
        return new FunctionHandle<ResultOfGetTransactions>(ResultOfGetTransactions.class, this.contextId(), this.address(), this.abi(), this.credentials(), "getTransactions", params, null);
    }

    @Override
    public FunctionHandle<ResultOfGetTransactionIds> getTransactionIds() {
        Map<String, Object> params = Map.of();
        return new FunctionHandle<ResultOfGetTransactionIds>(ResultOfGetTransactionIds.class, this.contextId(), this.address(), this.abi(), this.credentials(), "getTransactionIds", params, null);
    }

    @Override
    public FunctionHandle<ResultOfGetCustodians> getCustodians() {
        Map<String, Object> params = Map.of();
        return new FunctionHandle<ResultOfGetCustodians>(ResultOfGetCustodians.class, this.contextId(), this.address(), this.abi(), this.credentials(), "getCustodians", params, null);
    }
}

