/*
 * Decompiled with CFR 0.152.
 */
package tech.ugma.customcomponents;

import java.text.Collator;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.scene.layout.HBox;
import javafx.util.Callback;

public class AddRemoveComboBox
extends ComboBox<String> {
    public static final String ADD_CELL_PLACEHOLDER = "ADD_AN_ADD_CELL_RIGHT_HERE_RIGHT_NOW";
    private Comparator<String> addCellRelegator;
    private EventHandler<ActionEvent> removalAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button button = (Button)event.getSource();
            HBox hBox = (HBox)button.getParent();
            AddRemoveListCell cell = (AddRemoveListCell)hBox.getParent();
            AddRemoveComboBox.this.getItems().remove(cell.getItem());
            AddRemoveComboBox.this.hide();
            AddRemoveComboBox.this.show();
        }
    };
    private EventHandler<ActionEvent> additionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            TextInputDialog addDialog = new TextInputDialog();
            addDialog.setTitle("New Item");
            addDialog.setHeaderText(null);
            addDialog.setContentText("Please enter the new item: ");
            Parent parent = AddRemoveComboBox.this.getParent();
            while (parent.getParent() != null) {
                parent = parent.getParent();
            }
            addDialog.initOwner(parent.getScene().getWindow());
            Optional result = addDialog.showAndWait();
            result.ifPresent(new Consumer<String>(){

                @Override
                public void accept(String s) {
                    AddRemoveComboBox.this.getItems().add((Object)s);
                    AddRemoveComboBox.this.getSelectionModel().select((Object)s);
                }
            });
        }
    };
    private boolean wasJustSorted;
    private boolean sortAlphabetically = false;

    public AddRemoveComboBox() {
        this((ObservableList<String>)FXCollections.emptyObservableList());
    }

    public AddRemoveComboBox(ObservableList<String> list) {
        super(list);
        this.addCellRelegator = this.initAddCellRelegator();
        if (list == null) {
            throw new NullPointerException("List passed to constructor is null.");
        }
        list.addListener(this.initAddCellManager());
        this.setCellFactory(this.initCellFactory());
        this.skinProperty().addListener(new ChangeListener<Skin<?>>(){

            public void changed(ObservableValue<? extends Skin<?>> observable, Skin<?> oldValue, Skin<?> newValue) {
                if (newValue != null) {
                    ((ComboBoxListViewSkin)newValue).setHideOnClick(false);
                }
            }
        });
        this.getSelectionModel().selectedItemProperty().addListener(this.initHideUglyConstantListener());
        this.getSelectionModel().selectFirst();
    }

    private Comparator<String> initAddCellRelegator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (Objects.equals(AddRemoveComboBox.ADD_CELL_PLACEHOLDER, o1)) {
                    return Integer.MAX_VALUE;
                }
                if (Objects.equals(AddRemoveComboBox.ADD_CELL_PLACEHOLDER, o2)) {
                    return Integer.MIN_VALUE;
                }
                if (AddRemoveComboBox.this.sortAlphabetically) {
                    return Collator.getInstance().compare(o1, o2);
                }
                return 0;
            }
        };
    }

    private InvalidationListener initAddCellManager() {
        return new InvalidationListener(){

            public void invalidated(Observable observable) {
                if (AddRemoveComboBox.this.wasJustSorted) {
                    AddRemoveComboBox.this.wasJustSorted = false;
                } else {
                    AddRemoveComboBox.this.wasJustSorted = true;
                    AddRemoveComboBox.this.getItems().sort(AddRemoveComboBox.this.addCellRelegator);
                }
            }
        };
    }

    private Callback<ListView<String>, ListCell<String>> initCellFactory() {
        return new Callback<ListView<String>, ListCell<String>>(){

            public ListCell<String> call(ListView<String> param) {
                AddRemoveListCell customCell = new AddRemoveListCell();
                customCell.setRemoveButtonAction(AddRemoveComboBox.this.removalAction);
                customCell.setAddButtonAction(AddRemoveComboBox.this.additionAction);
                customCell.setOnMousePressed(clickAddButton -> {
                    if (Objects.equals(customCell.getItem(), AddRemoveComboBox.ADD_CELL_PLACEHOLDER)) {
                        customCell.button.fire();
                    }
                    AddRemoveComboBox.this.hide();
                });
                return customCell;
            }
        };
    }

    private ChangeListener<? super String> initHideUglyConstantListener() {
        return (observable, oldValue, selectedValue) -> {
            if (Objects.equals(selectedValue, ADD_CELL_PLACEHOLDER)) {
                Platform.runLater(() -> {
                    this.getSelectionModel().clearSelection();
                    this.valueProperty().set(null);
                });
                return;
            }
            if (selectedValue != null) {
                this.getSelectionModel().select(selectedValue);
            }
        };
    }

    public void setRemovalAction(EventHandler<ActionEvent> removalAction) {
        this.removalAction = removalAction;
    }

    public void setAdditionAction(EventHandler<ActionEvent> additionAction) {
        this.additionAction = additionAction;
    }

    public boolean isSortAlphabetically() {
        return this.sortAlphabetically;
    }

    public void setSortAlphabetically(boolean sortAlphabetically) {
        this.sortAlphabetically = sortAlphabetically;
    }

    public class AddRemoveListCell
    extends ListCell<String> {
        private Label label = new Label();
        private Button button = new Button();
        private HBox box = new HBox(new Node[]{this.button, this.label});
        private EventHandler<ActionEvent> removeEvent;
        private EventHandler<ActionEvent> addEvent;
        private String addButtonStyle = "-fx-background-color: transparent;\n        -fx-graphic:  url('Plus-Math-15.png');\n        -fx-opacity: 0.2;\n        -fx-padding: 0.333 .333 .333 .333;\n        -fx-cursor: hand;";
        private String removeButtonStyle = "-fx-background-color: transparent;\n        -fx-graphic:  url('Delete-15.png');\n        -fx-opacity: 0.2;\n        -fx-padding: 0.333 .333 .333 .333;\n        -fx-cursor: hand;";

        public AddRemoveListCell() {
            this.label.textProperty().bind((ObservableValue)this.itemProperty());
            this.label.setMaxWidth(Double.POSITIVE_INFINITY);
            this.button.styleProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.itemProperty().isEqualTo((Object)AddRemoveComboBox.ADD_CELL_PLACEHOLDER)).then(this.addButtonStyle).otherwise(this.removeButtonStyle));
            this.label.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.itemProperty().isEqualTo((Object)AddRemoveComboBox.ADD_CELL_PLACEHOLDER)).then("").otherwise((ObservableStringValue)this.itemProperty().asString()));
            this.itemProperty().addListener((ChangeListener)new ChangeListener<String>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (Objects.equals(newValue, AddRemoveComboBox.ADD_CELL_PLACEHOLDER)) {
                        if (AddRemoveListCell.this.addEvent == null) throw new NullPointerException("Cell's Add-Event is null! oldValue: " + oldValue + "; newValue: " + newValue);
                        AddRemoveListCell.this.button.setOnAction(AddRemoveListCell.this.addEvent);
                        return;
                    } else {
                        if (AddRemoveListCell.this.removeEvent == null) throw new NullPointerException("Cell's Remove-Event is null! oldValue: " + oldValue + "; newValue: " + newValue);
                        AddRemoveListCell.this.button.setOnAction(AddRemoveListCell.this.removeEvent);
                    }
                }
            });
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.box.setSpacing(3.0);
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                this.setText(null);
                this.setGraphic((Node)this.box);
            }
        }

        public void setRemoveButtonAction(EventHandler<ActionEvent> removeEvent) {
            this.removeEvent = removeEvent;
        }

        public void setAddButtonAction(EventHandler<ActionEvent> addEvent) {
            this.addEvent = addEvent;
        }
    }
}

