/*
 * Decompiled with CFR 0.152.
 */
package tech.xigam.express;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class Request {
    public final HttpExchange httpExchange;
    public final String requestType;
    public final String requestUrl;
    public final Map<String, String> requestArguments;
    private int responseCode = 200;

    public Request(HttpExchange httpExchange, String requestType, String requestUrl, Map<String, String> requestArguments) {
        this.httpExchange = httpExchange;
        this.requestType = requestType;
        this.requestUrl = requestUrl;
        this.requestArguments = requestArguments;
    }

    public Request code(int statusCode) {
        this.responseCode = statusCode;
        return this;
    }

    public void respond(String response) {
        try {
            OutputStream output = this.httpExchange.getResponseBody();
            this.httpExchange.sendResponseHeaders(this.responseCode, response.length());
            output.write(response.getBytes());
            output.flush();
            output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public List<String> urlSegments() {
        ArrayList<String> initial = new ArrayList<String>(List.of(this.requestUrl.split("/")));
        initial.remove(0);
        initial.remove(1);
        return initial;
    }
}

