/*
 * Decompiled with CFR 0.152.
 */
package http;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;

public class HttpUtil {
    private static final String BOUNDARY = UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
    private static final String PREFIX = "--";
    private static final String LINE_END = "\r\n";

    public static <T> String sendGet(String url, T paramObj, Map<String, String> header) {
        HttpURLConnection connection = null;
        try {
            connection = HttpUtil.initGetConnection(url, paramObj);
            if (header != null) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.connect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return HttpUtil.getResponseString(connection);
    }

    public static <T> String sendDelete(String url, T paramObj, Map<String, String> header) {
        HttpURLConnection connection = null;
        try {
            connection = HttpUtil.initGetConnection(url, paramObj);
            connection.setRequestMethod("DELETE");
            if (header != null) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.connect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return HttpUtil.getResponseString(connection);
    }

    public static String sendPost(String url, String param, Map<String, String> header) {
        HttpURLConnection connection = null;
        try {
            URL realUrl = new URL(url);
            connection = (HttpURLConnection)realUrl.openConnection();
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
            connection.setRequestMethod("POST");
            connection.setConnectTimeout(30000);
            connection.setReadTimeout(30000);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            if (header != null) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (param != null) {
            byte[] content = param.toString().getBytes(StandardCharsets.UTF_8);
            try (OutputStream os = connection.getOutputStream();){
                os.write(content);
            }
            catch (Exception e) {
                e.getStackTrace();
            }
        }
        return HttpUtil.getResponseString(connection);
    }

    public static String sendObjPost(String url, Object param, Map<String, String> header) {
        return HttpUtil.sendPost(url, JSON.toJSONString((Object)param), header);
    }

    public static <T> String sendPostFile(String url, T paramObj, String dir, Map<String, String> header) {
        String urlParams = HttpUtil.appendGetUrlParam(url, paramObj);
        HttpURLConnection connection = null;
        try {
            URL uri = new URL(urlParams);
            URLConnection urlConnection = uri.openConnection();
            connection = (HttpURLConnection)urlConnection;
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Cache-Control", "no-cache");
            connection.setRequestProperty("Charset", StandardCharsets.UTF_8.name());
            connection.setInstanceFollowRedirects(true);
            connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            connection.setRequestProperty("Charset", StandardCharsets.UTF_8.name());
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            if (header != null) {
                for (Map.Entry<String, String> entry : header.entrySet()) {
                    connection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            connection.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File file = new File(dir);
        if (!file.exists()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try (DataOutputStream out = new DataOutputStream(connection.getOutputStream());
             DataInputStream in = new DataInputStream(new FileInputStream(file));){
            try {
                StringBuilder requestParams = new StringBuilder();
                requestParams.append(PREFIX).append(BOUNDARY).append(LINE_END);
                requestParams.append("Content-Disposition: form-data; name=\"").append("file").append("\"").append(LINE_END);
                requestParams.append("Content-Type: text/plain; charset=utf-8").append(LINE_END);
                requestParams.append("Content-Transfer-Encoding: 8bit").append(LINE_END);
                requestParams.append(LINE_END);
                requestParams.append("ori2.jpeg");
                requestParams.append(LINE_END);
                out.write(requestParams.toString().getBytes());
                out.flush();
                String msg = "\u8bf7\u6c42\u4e0a\u4f20\u6587\u4ef6\u90e8\u5206:\n";
                requestParams = new StringBuilder();
                requestParams.append(PREFIX).append(BOUNDARY).append(LINE_END);
                requestParams.append("Content-Disposition: form-data; name=\"").append("file").append("\"; filename=\"").append("ori2.jpeg").append("\"").append(LINE_END);
                requestParams.append("Content-Type:").append("multipart/form-data").append(LINE_END);
                requestParams.append("Content-Transfer-Encoding: 8bit").append(LINE_END);
                requestParams.append(LINE_END);
                out.write(requestParams.toString().getBytes());
                int bytes = 0;
                byte[] buffer = new byte[1024];
                while ((bytes = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes);
                }
                out.write(LINE_END.getBytes());
                out.flush();
                String endTarget = PREFIX + BOUNDARY + "--\r\n";
                out.write(endTarget.getBytes());
                out.flush();
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return HttpUtil.getResponseString(connection);
    }

    private static HttpURLConnection getConnection(String url) throws IOException {
        URL realUrl = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)realUrl.openConnection();
        conn.setRequestProperty("accept", "*/*");
        conn.setRequestProperty("connection", "Keep-Alive");
        conn.setRequestProperty("Content-Type", "application/json; utf-8");
        conn.setConnectTimeout(0);
        conn.setReadTimeout(0);
        return conn;
    }

    private static <T> String appendGetUrlParam(String url, T paramObj) {
        StringBuilder urlNameString = new StringBuilder(url);
        if (paramObj != null) {
            Field[] fields;
            urlNameString.append("?");
            Class<?> c = paramObj.getClass();
            for (Field field : fields = c.getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                field.setAccessible(true);
                Object filedValue = null;
                try {
                    filedValue = field.get(paramObj);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                if (filedValue == null) continue;
                fieldName = URLEncoder.encode(fieldName, StandardCharsets.UTF_8);
                String filedValueStr = URLEncoder.encode(filedValue.toString(), StandardCharsets.UTF_8);
                urlNameString.append(fieldName).append("=").append(filedValueStr).append("&");
            }
        }
        return urlNameString.toString();
    }

    private static <T> HttpURLConnection initGetConnection(String url, T paramObj) throws IOException {
        String urlParams = HttpUtil.appendGetUrlParam(url, paramObj);
        HttpURLConnection connection = HttpUtil.getConnection(urlParams);
        return connection;
    }

    private static String getResponseString(HttpURLConnection connection) {
        String result = null;
        Long time1 = System.currentTimeMillis();
        InputStream retStream = null;
        try {
            int retCode = connection.getResponseCode();
            retStream = retCode == 200 ? connection.getInputStream() : connection.getErrorStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Long time2 = System.currentTimeMillis();
        System.out.println("getInput ms " + (time2 - time1));
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int length;
            byte[] buffer = new byte[8192];
            while ((length = retStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            result = outputStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

