/*
 * Decompiled with CFR 0.152.
 */
package http.demo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import http.HttpUtil;
import http.demo.DemoPagingVO;
import http.demo.DemoVO;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class HttpDemoUtil {
    public static <T, M> M sendGet(String url, T paramObj, Map<String, String> header, Class<M> responseClass) {
        String result = HttpUtil.sendGet(url, paramObj, header);
        return HttpDemoUtil.getRet(result, responseClass);
    }

    public static <T, M> M sendDelete(String url, T paramObj, Map<String, String> header, Class<M> responseClass) {
        String result = HttpUtil.sendDelete(url, paramObj, header);
        return HttpDemoUtil.getRet(result, responseClass);
    }

    public static <T, M> List<M> sendGetPage(String url, T paramObj, Map<String, String> header, Class<M> responseClass) {
        String result = HttpUtil.sendGet(url, paramObj, header);
        return HttpDemoUtil.getRetPage(result, responseClass);
    }

    public static <M> M sendPost(String url, String param, Map<String, String> header, Class<M> responseClass) {
        String result = HttpUtil.sendPost(url, param, header);
        return HttpDemoUtil.getRet(result, responseClass);
    }

    public static <M> M sendObjPost(String url, Object param, Map<String, String> header, Class<M> responseClass) {
        return HttpDemoUtil.sendPost(url, JSON.toJSONString((Object)param), header, responseClass);
    }

    public static <T, M> M sendPostFile(String url, T paramObj, String dir, Map<String, String> header, Class<M> responseClass) {
        String result = HttpUtil.sendPostFile(url, paramObj, dir, header);
        return HttpDemoUtil.getRet(result, responseClass);
    }

    private static <T> T getRet(String result, Class<T> responseClass) {
        DemoVO baseRes = (DemoVO)JSONObject.parseObject((String)result, (TypeReference)new TypeReference<DemoVO<T>>(new Type[]{responseClass}){}, (Feature[])new Feature[0]);
        if (baseRes == null) {
            return null;
        }
        if ("0000".equals(baseRes.getCode())) {
            try {
                if (responseClass == String.class) {
                    return (T)baseRes.getMessage();
                }
                Object t = baseRes.getBody();
                if (t == null) {
                    throw new IllegalArgumentException("ret null!");
                }
                return t;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException(baseRes.getMessage());
        }
        return null;
    }

    private static <T> List<T> getRetPage(String result, Class<T> responseClass) {
        TypeReference typeReference = new TypeReference<DemoVO<DemoPagingVO<T>>>(new Type[]{responseClass}){};
        DemoVO baseRes = (DemoVO)JSONObject.parseObject((String)result, (TypeReference)typeReference, (Feature[])new Feature[0]);
        if ("0000".equals(baseRes.getCode())) {
            try {
                if (responseClass == String.class) {
                    throw new Exception(baseRes.getMessage());
                }
                DemoPagingVO pagingBody = (DemoPagingVO)baseRes.getBody();
                List list = pagingBody.getList();
                if (list == null) {
                    throw new IllegalArgumentException("ret null!");
                }
                return list;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException(baseRes.getMessage());
        }
        return null;
    }
}

