/*
 * Decompiled with CFR 0.152.
 */
package com.jpetrak.gate.java;

import com.jpetrak.gate.java.Flag;
import com.jpetrak.gate.java.JavaCodeDriven;
import com.jpetrak.gate.java.JavaScripting;
import com.jpetrak.gate.java.gui.JavaEditorVR;
import gate.Controller;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.LanguageResource;
import gate.ProcessingResource;
import gate.Resource;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ControllerAwarePR;
import gate.creole.CustomDuplication;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.creole.metadata.Sharable;
import gate.util.Benchmark;
import gate.util.Files;
import gate.util.GateClassLoader;
import gate.util.GateRuntimeException;
import gate.util.Javac;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.log4j.Logger;

@CreoleResource(name="Java Scripting PR", helpURL="https://github.com/johann-petrak/gateplugin-Java/wiki/JavaScriptingPR", comment="Use a Java program as a processing resource")
public class JavaScriptingPR
extends AbstractLanguageAnalyser
implements ControllerAwarePR,
JavaCodeDriven,
CustomDuplication {
    protected URL javaProgramUrl;
    protected String inputAS;
    protected String outputAS;
    protected Resource resource1;
    protected Resource resource2;
    protected Resource resource3;
    protected URL libDirUrl = null;
    public Logger logger = Logger.getLogger(this.getClass());
    protected FeatureMap scriptParams;
    GateClassLoader classloader = null;
    Controller controller = null;
    File javaProgramFile = null;
    List<String> javaProgramLines = null;
    JavaScripting javaProgramClass = null;
    String fileProlog = "package javascripting;";
    String fileImport = "import com.jpetrak.gate.java.JavaScripting;";
    String classProlog = "public class THECLASSNAME extends JavaScripting {";
    String classEpilog = "}";
    Pattern importPattern = Pattern.compile("\\s*import\\s+([\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*(?:[\\p{L}_$][\\p{L}\\p{N}_$]*|\\*)\\s*;\\s*(?://.*)?");
    protected Object lockForPr;
    protected Flag initializedForPr;
    protected Flag cleanedUpForPr;
    protected AtomicInteger nrDuplicates;
    public boolean isCompileError;
    private JavaEditorVR registeredEditorVR = null;
    private static int idNumber = 0;
    protected ConcurrentMap<String, Object> globalsForPr;
    private String benchmarkId = this.getName();

    @CreoleParameter(comment="The URL of the Java program to run", suffixes=".java")
    public void setJavaProgramUrl(URL surl) {
        this.javaProgramUrl = surl;
    }

    public URL getJavaProgramUrl() {
        return this.javaProgramUrl;
    }

    @Optional
    @RunTime
    @CreoleParameter(comment="The input annotation set", defaultValue="")
    public void setInputAS(String asname) {
        this.inputAS = asname;
    }

    public String getInputAS() {
        return this.inputAS;
    }

    @Optional
    @RunTime
    @CreoleParameter(comment="The output annotation set", defaultValue="")
    public void setOutputAS(String asname) {
        this.outputAS = asname;
    }

    public String getOutputAS() {
        return this.outputAS;
    }

    @Optional
    @RunTime
    @CreoleParameter(comment="The script parameters", defaultValue="")
    public void setScriptParams(FeatureMap parms) {
        this.scriptParams = parms;
    }

    @Optional
    @RunTime
    @CreoleParameter
    public void setDocument(Document d) {
        this.document = d;
    }

    @Optional
    @RunTime
    @CreoleParameter
    public void setResource1(Resource r) {
        this.resource1 = r;
    }

    public Resource getResource1() {
        return this.resource1;
    }

    @Optional
    @RunTime
    @CreoleParameter
    public void setResource2(Resource r) {
        this.resource2 = r;
    }

    public Resource getResource2() {
        return this.resource2;
    }

    @Optional
    @RunTime
    @CreoleParameter
    public void setResource3(Resource r) {
        this.resource3 = r;
    }

    public Resource getResource3() {
        return this.resource3;
    }

    public FeatureMap getScriptParams() {
        if (this.scriptParams == null) {
            this.scriptParams = Factory.newFeatureMap();
        }
        return this.scriptParams;
    }

    @Optional
    @RunTime
    @CreoleParameter(comment="An optional directory with additional JAR files to use for compilation and running. If specified, must be a file: URL")
    public void setLibDirUrl(URL url) {
        this.libDirUrl = url;
    }

    public URL getLibDirUrl() {
        return this.libDirUrl;
    }

    public File getJavaProgramFile() {
        return this.javaProgramFile;
    }

    protected File getPluginDir() {
        URL creoleURL = ((ResourceData)Gate.getCreoleRegister().get((Object)this.getClass().getName())).getXmlFileUrl();
        File pluginDir = Files.fileFromURL((URL)creoleURL).getParentFile();
        return pluginDir;
    }

    @Sharable
    public void setLockForPr(Object what) {
        this.lockForPr = what;
    }

    public Object getLockForPr() {
        return this.lockForPr;
    }

    @Sharable
    public void setInitializedForPr(Flag value) {
        this.initializedForPr = value;
    }

    public Flag getInitializedForPr() {
        return this.initializedForPr;
    }

    @Sharable
    public void setCleanedUpForPr(Flag value) {
        this.cleanedUpForPr = value;
    }

    public Flag getCleanedUpForPr() {
        return this.cleanedUpForPr;
    }

    @Sharable
    public void setNrDuplicates(AtomicInteger value) {
        this.nrDuplicates = value;
    }

    public AtomicInteger getNrDuplicates() {
        return this.nrDuplicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryCompileScript() {
        String javaProgramSource;
        String className;
        if (this.classloader != null) {
            Gate.getClassLoader().forgetClassLoader(this.classloader);
        }
        this.classloader = Gate.getClassLoader().getDisposableClassLoader(this.javaProgramUrl.toExternalForm() + System.currentTimeMillis(), true);
        if (this.libDirUrl != null) {
            File dirFile = Files.fileFromURL((URL)this.libDirUrl);
            File[] directoryListing = dirFile.listFiles();
            if (directoryListing != null) {
                for (File child : directoryListing) {
                    if (!child.getName().toLowerCase().endsWith(".jar")) continue;
                    try {
                        Gate.getClassLoader().addURL(child.toURI().toURL());
                        this.logger.info((Object)("Added to Gate classpath: " + child.toURI().toURL()));
                    }
                    catch (MalformedURLException ex) {
                        this.logger.error((Object)("Could not add file " + child + " to classpath"), (Throwable)ex);
                    }
                }
            } else {
                this.logger.error((Object)("Not a directory: " + this.libDirUrl));
            }
        }
        try {
            className = "JavaScriptingClass" + JavaScriptingPR.getNextId();
            StringBuilder sb = new StringBuilder();
            ArrayList<String> imports = new ArrayList<String>();
            this.javaProgramLines = new ArrayList<String>();
            ArrayList<String> scriptLines = new ArrayList<String>();
            LineIterator it = FileUtils.lineIterator((File)this.javaProgramFile, (String)"UTF-8");
            try {
                while (it.hasNext()) {
                    String line = it.nextLine();
                    if (this.importPattern.matcher(line).matches()) {
                        imports.add(line);
                        continue;
                    }
                    scriptLines.add(line);
                }
            }
            finally {
                LineIterator.closeQuietly((LineIterator)it);
            }
            this.javaProgramLines.add(this.fileProlog);
            this.javaProgramLines.add(this.fileImport);
            this.javaProgramLines.addAll(imports);
            this.javaProgramLines.add(this.classProlog.replaceAll("THECLASSNAME", className));
            this.javaProgramLines.addAll(scriptLines);
            this.javaProgramLines.add(this.classEpilog);
            for (String line : this.javaProgramLines) {
                sb.append(line);
                sb.append("\n");
            }
            javaProgramSource = sb.toString();
        }
        catch (IOException ex) {
            this.logger.error((Object)("Problem reading program from " + this.javaProgramUrl), (Throwable)ex);
            return;
        }
        HashMap<String, String> toCompile = new HashMap<String, String>();
        toCompile.put("javascripting." + className, javaProgramSource);
        try {
            Javac.loadClasses(toCompile, (GateClassLoader)this.classloader);
            this.javaProgramClass = (JavaScripting)this.classloader.loadClass("javascripting." + className).newInstance();
            this.javaProgramClass.globalsForPr = this.globalsForPr;
            this.javaProgramClass.lockForPr = this.lockForPr;
            this.javaProgramClass.initializedForPr = this.initializedForPr;
            if (this.registeredEditorVR != null) {
                this.registeredEditorVR.setCompilationOk();
            }
            this.javaProgramClass.resource1 = this.resource1;
            this.javaProgramClass.resource2 = this.resource2;
            this.javaProgramClass.resource3 = this.resource3;
            this.isCompileError = false;
        }
        catch (Exception ex) {
            this.logger.error((Object)"Problem compiling JavaScripting Class", (Throwable)ex);
            if (this.classloader != null) {
                Gate.getClassLoader().forgetClassLoader(this.classloader);
                this.classloader = null;
            }
            this.isCompileError = true;
            this.javaProgramClass = null;
            if (this.registeredEditorVR != null) {
                this.registeredEditorVR.setCompilationError();
            }
            return;
        }
    }

    public void registerEditorVR(JavaEditorVR vr) {
        this.registeredEditorVR = vr;
    }

    private static synchronized String getNextId() {
        return "" + ++idNumber;
    }

    public Resource init() throws ResourceInstantiationException {
        if (this.lockForPr == null) {
            this.lockForPr = new Object();
            this.globalsForPr = new ConcurrentHashMap<String, Object>();
            this.initializedForPr = new Flag(false);
            this.cleanedUpForPr = new Flag(false);
            this.nrDuplicates = new AtomicInteger(0);
        }
        if (this.getJavaProgramUrl() == null) {
            throw new ResourceInstantiationException("The javaProgramUrl must not be empty");
        }
        this.javaProgramFile = Files.fileFromURL((URL)this.getJavaProgramUrl());
        try {
            String string = FileUtils.readFileToString((File)this.javaProgramFile, (String)"UTF-8");
        }
        catch (IOException ex) {
            throw new ResourceInstantiationException("Could not read the java program from " + this.getJavaProgramUrl(), (Exception)ex);
        }
        this.tryCompileScript();
        return this;
    }

    public void reInit() throws ResourceInstantiationException {
        this.initializedForPr.set(false);
        if (this.javaProgramClass != null) {
            this.javaProgramClass.cleanupPr();
            JavaScriptingPR javaScriptingPR = this;
            javaScriptingPR.javaProgramClass.resetInitAll();
            this.javaProgramClass.initializedForPr = this.initializedForPr;
        }
        if (this.registeredEditorVR != null) {
            this.registeredEditorVR.setFile(this.getJavaProgramFile());
        }
        this.init();
    }

    public void cleanup() {
        super.cleanup();
        if (this.javaProgramClass != null) {
            if (!this.cleanedUpForPr.get()) {
                this.javaProgramClass.cleanupPr();
                this.cleanedUpForPr.set(true);
            }
            this.javaProgramClass.cleanup();
            this.javaProgramClass.doc = null;
            this.javaProgramClass.controller = null;
            this.javaProgramClass.corpus = null;
            this.javaProgramClass.inputASName = null;
            this.javaProgramClass.outputASName = null;
            this.javaProgramClass.inputAS = null;
            this.javaProgramClass.outputAS = null;
            this.javaProgramClass.parms = null;
            this.javaProgramClass.globalsForPr = null;
            this.javaProgramClass.lockForPr = null;
        }
        if (this.classloader != null) {
            Gate.getClassLoader().forgetClassLoader(this.classloader);
            this.classloader = null;
        }
    }

    public void execute() {
        long startTime = Benchmark.startPoint();
        if (this.javaProgramClass != null) {
            try {
                this.javaProgramClass.resource1 = this.getResource1();
                this.javaProgramClass.resource2 = this.getResource2();
                this.javaProgramClass.resource3 = this.getResource3();
                this.javaProgramClass.doc = this.document;
                this.javaProgramClass.controller = this.controller;
                this.javaProgramClass.corpus = this.corpus;
                this.javaProgramClass.inputASName = this.getInputAS();
                this.javaProgramClass.outputASName = this.getOutputAS();
                this.javaProgramClass.inputAS = this.document != null && this.getInputAS() != null ? this.document.getAnnotations(this.getInputAS()) : null;
                this.javaProgramClass.outputAS = this.document != null && this.getOutputAS() != null ? this.document.getAnnotations(this.getOutputAS()) : null;
                this.javaProgramClass.parms = this.getScriptParams();
                this.javaProgramClass.callExecute();
                this.javaProgramClass.doc = null;
                this.javaProgramClass.inputASName = null;
                this.javaProgramClass.outputASName = null;
                this.javaProgramClass.inputAS = null;
                this.javaProgramClass.outputAS = null;
                this.javaProgramClass.prName = this.getName();
            }
            catch (Exception ex) {
                this.printGeneratedProgram(System.err);
                throw new GateRuntimeException("Could not run program for script " + this.getName(), (Throwable)ex);
            }
            finally {
                this.benchmarkCheckpoint(startTime, "__execute");
            }
        } else {
            throw new GateRuntimeException("Cannot run script, compilation failed: " + this.getJavaProgramUrl());
        }
    }

    private void printGeneratedProgram(PrintStream stream) {
        int linenr = 0;
        for (String line : this.javaProgramLines) {
            stream.println(++linenr + " " + line);
        }
    }

    public void controllerExecutionStarted(Controller controller) {
        this.controller = controller;
        if (this.javaProgramClass != null) {
            this.javaProgramClass.resource1 = this.getResource1();
            this.javaProgramClass.resource2 = this.getResource2();
            this.javaProgramClass.resource3 = this.getResource3();
            this.javaProgramClass.controller = controller;
            this.javaProgramClass.parms = this.getScriptParams();
            this.javaProgramClass.prName = this.getName();
            try {
                this.javaProgramClass.controllerStarted();
            }
            catch (Exception ex) {
                System.err.println("Could not run controllerStarted method for script " + this.getName());
                this.printGeneratedProgram(System.err);
                ex.printStackTrace(System.err);
            }
        }
    }

    public void controllerExecutionFinished(Controller controller) {
        this.controller = controller;
        if (this.javaProgramClass != null) {
            this.javaProgramClass.controller = controller;
            try {
                this.javaProgramClass.controllerFinished();
            }
            catch (Exception ex) {
                System.err.println("Could not run controlerFinished method for script " + this.getName());
                this.printGeneratedProgram(System.err);
                ex.printStackTrace(System.err);
            }
            this.javaProgramClass.controller = null;
            this.javaProgramClass.corpus = null;
            this.javaProgramClass.parms = null;
        }
    }

    public void controllerExecutionAborted(Controller controller, Throwable throwable) {
        this.controller = controller;
        if (this.javaProgramClass != null) {
            this.javaProgramClass.controller = controller;
            try {
                this.javaProgramClass.controllerAborted(throwable);
            }
            catch (Exception ex) {
                System.err.println("Could not run controlerAborted method for script " + this.getName());
                this.printGeneratedProgram(System.err);
                ex.printStackTrace(System.err);
            }
            this.javaProgramClass.controller = null;
            this.javaProgramClass.corpus = null;
            this.javaProgramClass.parms = null;
        }
    }

    @Sharable
    public void setGlobalsForPr(ConcurrentMap<String, Object> it) {
        this.globalsForPr = it;
    }

    public ConcurrentMap<String, Object> getGlobalsForPr() {
        return this.globalsForPr;
    }

    public Resource duplicate(Factory.DuplicationContext dc) throws ResourceInstantiationException {
        JavaScriptingPR res = (JavaScriptingPR)Factory.defaultDuplicate((Resource)this, (Factory.DuplicationContext)dc);
        int nr = this.nrDuplicates.addAndGet(1);
        if (res.javaProgramClass != null) {
            res.javaProgramClass.duplicationId = nr;
        }
        return res;
    }

    protected void benchmarkCheckpoint(long startTime, String name) {
        if (Benchmark.isBenchmarkingEnabled()) {
            Benchmark.checkPointWithDuration((long)(Benchmark.startPoint() - startTime), (String)Benchmark.createBenchmarkId((String)name, (String)this.getBenchmarkId()), (Object)this, null);
        }
    }

    public String getBenchmarkId() {
        return this.benchmarkId;
    }

    public void setBenchmarkId(String string) {
        this.benchmarkId = string;
    }

    public static interface LrOrPr
    extends LanguageResource,
    ProcessingResource {
    }
}

