/*
 * Decompiled with CFR 0.152.
 */
package gate.plugin.python;

import gate.Gate;
import gate.Resource;
import gate.creole.AbstractLanguageResource;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.plugin.python.PythonSlave;
import gate.util.GateRuntimeException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import org.apache.log4j.Logger;
import py4j.GatewayServer;

@CreoleResource(name="PythonSlaveLr", comment="Language Resource to represent a Python slave process.", helpURL="")
public class PythonSlaveLr
extends AbstractLanguageResource {
    private static final long serialVersionUID = -1392763456343502768L;
    public transient Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    protected Integer port = 25333;
    protected String host = "127.0.0.1";
    protected String authToken = "";
    protected Boolean logActions = false;
    protected Boolean useAuthToken = true;
    protected transient PythonSlave pythonSlave;

    @Optional
    @CreoleParameter(comment="Port number to use.", defaultValue="25333")
    public void setPort(Integer value) {
        this.port = value;
    }

    public Integer getPort() {
        return this.port;
    }

    @Optional
    @CreoleParameter(comment="Binding host name or address", defaultValue="127.0.0.1")
    public void setHost(String value) {
        this.host = value;
    }

    public String getHost() {
        return this.host;
    }

    @Optional
    @CreoleParameter(comment="Auth token to use", defaultValue="")
    public void setAuthToken(String value) {
        this.authToken = value;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    @CreoleParameter(comment="If actions should get logged", defaultValue="false")
    public void setLogActions(Boolean val) {
        this.logActions = val;
    }

    public Boolean getLogActions() {
        return this.logActions;
    }

    @CreoleParameter(comment="Whether to use an auth token", defaultValue="true")
    public void setUseAuthToken(Boolean value) {
        this.useAuthToken = value;
    }

    public Boolean getUseAuthToken() {
        return this.useAuthToken;
    }

    public Resource init() throws ResourceInstantiationException {
        this.logger.info((Object)"Creating PythonSlave instance");
        try {
            this.pythonSlave = new PythonSlave();
            this.pythonSlave.logActions = this.logActions;
        }
        catch (ResourceInstantiationException ex) {
            throw new ResourceInstantiationException("Could not create PythonSlave", (Exception)((Object)ex));
        }
        this.startServer(this.pythonSlave);
        this.logger.info((Object)("Python slave started at port " + this.port));
        return this;
    }

    public void cleanup() {
        this.stopServer(this.pythonSlave);
        super.cleanup();
    }

    public void startServer(PythonSlave pslave) {
        GatewayServer server;
        InetAddress hostAddress;
        try {
            hostAddress = InetAddress.getByName(this.host);
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException("Cannot resolve host address " + this.host, ex);
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)Gate.getClassLoader());
        if (this.useAuthToken.booleanValue()) {
            if (this.authToken == null || this.authToken.trim().isEmpty()) {
                this.authToken = UUID.randomUUID().toString();
                System.out.println("Using auth token: " + this.authToken);
            }
            server = new GatewayServer.GatewayServerBuilder().entryPoint((Object)pslave).javaPort(this.port.intValue()).javaAddress(hostAddress).authToken(this.authToken).build();
        } else {
            server = new GatewayServer.GatewayServerBuilder().entryPoint((Object)pslave).javaPort(this.port.intValue()).javaAddress(hostAddress).build();
        }
        pslave.server = server;
        try {
            server.start();
        }
        catch (Exception ex) {
            pslave.server = null;
            throw new GateRuntimeException("Could not start GatewayServer", (Throwable)ex);
        }
    }

    public void stopServer(PythonSlave pslave) {
        if (pslave.server != null) {
            pslave.server.shutdown();
        }
    }
}

