/*
 * Decompiled with CFR 0.152.
 */
package gate.plugin.python;

import gate.FeatureMap;
import gate.Resource;
import gate.creole.AbstractLanguageResource;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.util.Files;
import gate.util.GateRuntimeException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;

@CreoleResource(name="PythonPrResult", comment="Language Resource to represent a PythonPr over corpus result.", helpURL="")
public class PythonPrResult
extends AbstractLanguageResource {
    private static final long serialVersionUID = -7248763456343502768L;
    public transient Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    protected Boolean logFeatures = false;
    protected URL fileUrl;

    @Optional
    @CreoleParameter(comment="If true, log the current features whenever the result is updated.")
    public void setLogFeatures(Boolean value) {
        this.logFeatures = value;
    }

    public Boolean getLogFeatures() {
        return this.logFeatures;
    }

    @Optional
    @CreoleParameter(comment="File to use for saving/loading the result. Nothing saved/loaded if missing.")
    public void setFileUrl(URL value) {
        this.fileUrl = value;
    }

    public URL getFileUrl() {
        return this.fileUrl;
    }

    public Resource init() {
        this.loadFromFile();
        return this;
    }

    protected void saveToFile() {
        if (this.fileUrl != null) {
            File file = Files.fileFromURL((URL)this.fileUrl);
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));){
                oos.writeObject(this.getFeatures());
            }
            catch (IOException ex) {
                throw new GateRuntimeException("Could not save PythonPrResult to file " + file.getAbsolutePath(), (Throwable)ex);
            }
        }
    }

    protected void loadFromFile() {
        if (this.fileUrl != null) {
            File file = Files.fileFromURL((URL)this.fileUrl);
            try (ObjectInputStream ois = new ObjectInputStream(this.fileUrl.openStream());){
                FeatureMap fm = (FeatureMap)ois.readObject();
                this.getFeatures().putAll((Map)fm);
            }
            catch (IOException | ClassNotFoundException ex) {
                throw new GateRuntimeException("Could not load PythonPrResult from file " + file.getAbsolutePath(), (Throwable)ex);
            }
        }
    }

    public void outputFeaturesToLog() {
        TreeSet<String> keys = new TreeSet<String>();
        FeatureMap fm = this.getFeatures();
        for (Object e : fm.keySet()) {
            keys.add(e.toString());
        }
        System.out.println();
        for (String string : keys) {
            System.out.println(string + ": " + fm.get((Object)string));
        }
    }

    public void setResultData(Map<String, Object> resultData) {
        if (resultData != null) {
            this.getFeatures().clear();
            this.getFeatures().putAll(resultData);
            this.saveToFile();
            if (this.getLogFeatures() != null && this.getLogFeatures().booleanValue()) {
                this.outputFeaturesToLog();
            }
        }
    }

    public Map<String, Object> getResultData() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        FeatureMap fm = this.getFeatures();
        for (Object k : fm.keySet()) {
            ret.put(k.toString(), fm.get(k));
        }
        return ret;
    }
}

