/*
 * Decompiled with CFR 0.152.
 */
package gate.plugin.python.gui;

import gate.creole.AbstractVisualResource;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.GuiType;
import gate.plugin.python.PythonCodeDriven;
import gate.plugin.python.PythonPr;
import gate.plugin.python.gui.PythonEditorPanel;
import java.awt.GridLayout;
import java.io.File;

@CreoleResource(name="Python Code Editor", comment="Editor for Python code", guiType=GuiType.LARGE, mainViewer=true, resourceDisplayed="gate.plugin.python.PythonCodeDriven")
public class PythonEditorVr
extends AbstractVisualResource {
    private static final long serialVersionUID = 2225798440338388811L;
    protected PythonEditorPanel panel;
    protected PythonCodeDriven theTarget;
    protected PythonPr pr = null;

    public void setTarget(Object target) {
        if (target instanceof PythonCodeDriven) {
            this.theTarget = (PythonCodeDriven)target;
            this.pr = (PythonPr)target;
            this.panel = new PythonEditorPanel();
            this.add(this.panel);
            this.setLayout(new GridLayout(1, 1));
            this.pr.registerEditorVR(this);
            this.panel.setPR(this.pr);
            if (this.pr.pythonFileCanBeEdited()) {
                this.pr.tryCompileProgram();
                this.panel.setFile(this.pr.getPythonProgramFile());
                if (!this.pr.isCompileOk) {
                    this.panel.setCompilationError();
                } else {
                    this.panel.setCompilationOk();
                }
            } else {
                this.panel.textArea.setText(this.pr.getPythonProgramString());
                this.panel.disableButtons();
                this.panel.setFileLocation(this.pr.getPythonProgramUrl().toString() + " (Read-Only!)");
                this.panel.textArea.setEditable(false);
            }
        }
    }

    public void setFile(File file) {
        this.panel.setFile(file);
    }

    public void setCompilationError() {
        this.panel.setCompilationError();
    }

    public void setCompilationOk() {
        this.panel.setCompilationOk();
    }
}

