/*
 * Copyright (c) 2019 The University of Sheffield.
 *
 * This file is part of gateplugin-Python 
 * (see https://github.com/GateNLP/gateplugin-Python).
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * PythonEditorPanel.java
 *
 */
package gate.plugin.python.gui;

import gate.plugin.python.PythonCodeDriven;
import gate.plugin.python.PythonPr;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;

// TODO: add search/replace functionality
// probably as another button in the top line "Find/Replace" (or icon?) which 
// could bring up a dialog similar to what jedit has
// Should then also assign Ctrl-F/Ctrl-R etc to do find/replace just from
// the keyboard, no dialog.
// See javadoc here: http://javadoc.fifesoft.com/rsyntaxtextarea/org/fife/ui/rtextarea/SearchEngine.html#find%28javax.swing.JTextArea,%20org.fife.ui.rtextarea.SearchContext%29

// SEE: http://javadoc.fifesoft.com/rsyntaxtextarea/
// http://javadoc.fifesoft.com/rsyntaxtextarea/org/fife/ui/rsyntaxtextarea/TextEditorPane.html
// http://javadoc.fifesoft.com/rsyntaxtextarea/org/fife/ui/rsyntaxtextarea/FileLocation.html
/**
 * Visual Resource for the python PR.
 * 
 * @author Johann Petrak
 */
public class PythonEditorPanel extends javax.swing.JPanel {

  private static final long serialVersionUID = 3527048169263767662L;

  /** 
   * Create new form JavaEditorPanel.
   */
  public PythonEditorPanel() {
    initComponents();
    initEditor();
  }
  
  PythonCodeDriven owner = null;
  protected PythonPr pr = null;
  
  /**
   * Tell the VR which PR it belongs to.
   * 
   * @param pr the PR
   */
  public void setPR(PythonPr pr) {
    this.pr = pr;
  }

  /** 
   * Notify VR that compilation failed. 
   */
  public void setCompilationError() {
    jTextField1.setForeground(Color.red);
  }
  /**
   * Notify the VR that compilation was ok.
   */
  public void setCompilationOk() {
    jTextField1.setForeground(Color.black);
  }
  
  /**
   * Constructor. 
   * @param theOwner owner of the panel
   */
  public PythonEditorPanel(PythonCodeDriven theOwner) {
    owner = theOwner;
    initComponents();
    initEditor();
  }
  
  TextEditorPane textArea;
  
  /**
   * Set/update which file to edit.
   * @param scriptFile  file to edit
   */
  public void setFile(File scriptFile) {
    if(scriptFile != null) {
      try {
        textArea.load(FileLocation.create(scriptFile),"UTF-8");
        jTextField1.setText(scriptFile.getCanonicalPath());
      } catch (IOException ex) {
        jTextField1.setText("Error updating file, see log");
        System.err.println("Could not load file "+scriptFile);
        ex.printStackTrace(System.err);
      }
    }
  }
  
  private void initEditor() {
    // textArea = new RSyntaxTextArea();
    textArea = new TextEditorPane();
    textArea.setSyntaxEditingStyle(SyntaxConstants.SYNTAX_STYLE_PYTHON);
    textArea.setCodeFoldingEnabled(true);
    textArea.setAntiAliasingEnabled(true);
    // The following should be done from somewhere else ... :
    // textArea.setDocument(javax.swing.text.Document)
    textArea.setTabsEmulated(true);
    textArea.setTabSize(2); 
    textArea.setAnimateBracketMatching(true);
    textArea.setAutoIndentEnabled(true);
    textArea.setBracketMatchingEnabled(true);
    textArea.setHighlightCurrentLine(true);
    // or use load/save of a file location
    // load(FileLocation loc, java.lang.String defaultEnc) 
    RTextScrollPane sp = new RTextScrollPane(textArea);
    sp.setMinimumSize(new Dimension(200,200));
    sp.setFoldIndicatorEnabled(true);
    // JTextArea t2 = new JTextArea("// Content of the text area");
    //JScrollPane sp2 = new JScrollPane(t2);
    //JPanel jPanel3 = new JPanel(new GridLayout(1,1));
    //jPanel3.add(sp);
    jPanel2.add(sp) ;
    //jPanel2.add(new JTextField("dsdsdsdsdsd"));
    //jPanel2.setLayout(new GridLayout(1,1));
    jTextField1.setForeground(Color.black);
  }
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    jPanel1 = new javax.swing.JPanel();
    jPanel2 = new javax.swing.JPanel();
    jButton1 = new javax.swing.JButton();
    jTextField1 = new javax.swing.JTextField();
    jButton2 = new javax.swing.JButton();

    jPanel2.setBorder(null);
    jPanel2.setLayout(new java.awt.GridLayout());

    javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
    jPanel1.setLayout(jPanel1Layout);
    jPanel1Layout.setHorizontalGroup(
      jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 770, Short.MAX_VALUE)
    );
    jPanel1Layout.setVerticalGroup(
      jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, 358, Short.MAX_VALUE)
    );

    jButton1.setText("Save");
    jButton1.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButton1ActionPerformed(evt);
      }
    });

    jTextField1.setEditable(false);
    jTextField1.setText("jTextField1");

    jButton2.setText("Save & Use");
    jButton2.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        jButton2ActionPerformed(evt);
      }
    });

    javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
    this.setLayout(layout);
    layout.setHorizontalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
          .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
          .addGroup(layout.createSequentialGroup()
            .addComponent(jButton1)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(jButton2)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(jTextField1, javax.swing.GroupLayout.DEFAULT_SIZE, 600, Short.MAX_VALUE)))
        .addContainerGap())
    );
    layout.setVerticalGroup(
      layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(layout.createSequentialGroup()
        .addContainerGap()
        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
          .addComponent(jButton1)
          .addComponent(jButton2)
          .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
        .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .addContainerGap())
    );
  }// </editor-fold>//GEN-END:initComponents

  private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
    saveFile();
  }//GEN-LAST:event_jButton1ActionPerformed

  private void saveFile() {
    try {
      // At the moment, the following cannot be used because it writes a BOM
      // which will then appear in the middle of the file, so we have to do it
      // ourselves      
      // textArea.save();
      FileUtils.write(new File(textArea.getFileFullPath()), textArea.getText(), "UTF-8");
      //System.out.println("Program saved to "+textArea.getFileName());
    } catch (IOException ex) {
      System.err.println("Error saving the file "+textArea.getFileName());
      ex.printStackTrace(System.err);
      jTextField1.setText("ERROR SAVING THE FILE SEE LOG");
    }    
  }
  
  private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
    saveFile();
    pr.tryCompileProgram();
  }//GEN-LAST:event_jButton2ActionPerformed

  void disableButtons() {
    jButton1.setEnabled(false);
    jButton2.setEnabled(false);
  }
  void setFileLocation(String loc) {
    jTextField1.setText(loc);
  }
  
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JButton jButton1;
  private javax.swing.JButton jButton2;
  private javax.swing.JPanel jPanel1;
  private javax.swing.JPanel jPanel2;
  private javax.swing.JTextField jTextField1;
  // End of variables declaration//GEN-END:variables
}
