/*
 * Decompiled with CFR 0.152.
 */
package gate.plugin.python;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jr.ob.JSON;
import gate.Controller;
import gate.Document;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Resource;
import gate.Utils;
import gate.creole.AbstractLanguageAnalyser;
import gate.creole.ControllerAwarePR;
import gate.creole.ExecutionException;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.ResourceReference;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.HiddenCreoleParameter;
import gate.creole.metadata.Optional;
import gate.creole.metadata.RunTime;
import gate.creole.metadata.Sharable;
import gate.gui.ResourceHelper;
import gate.lib.interaction.process.pipes.Process4StringStream;
import gate.plugin.python.PythonCodeDriven;
import gate.plugin.python.PythonPrResult;
import gate.plugin.python.gui.PythonEditorVr;
import gate.util.GateRuntimeException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CreoleResource(name="PythonPr", helpURL="http://gatenlp.github.io/gateplugin-Python/", comment="Use a Python program as a processing resource")
public class PythonPr
extends AbstractLanguageAnalyser
implements ControllerAwarePR,
PythonCodeDriven {
    private static final long serialVersionUID = -7294555647613502768L;
    protected ResourceReference pythonProgram;
    protected URL configFile;
    protected boolean pythonProgramIsJar;
    protected boolean pythonProgramIsReadonly;
    protected File pythonProgramFile;
    protected String pythonProgramPathInJar;
    protected String pythonProgramModuleInJar;
    protected String pythonProgramFileInJar;
    protected URL pythonProgramUrl;
    protected FeatureMap programParams;
    protected String pythonBinary;
    protected URL pythonBinaryUrl;
    protected String pythonBinaryCommand;
    protected Boolean isConfigured;
    protected LoggingLevel loggingLevel;
    protected Boolean usePluginGatenlpPackage;
    protected PythonPrResult outputResultResource;
    protected Set<String> setsToUse = new HashSet<String>();
    protected transient Process4StringStream process = null;
    public transient Logger logger = LoggerFactory.getLogger(this.getClass());
    protected AtomicInteger nrDuplicates;
    protected List<Object> resultList;
    protected AtomicInteger runningDuplicates;
    protected int duplicateId = 0;
    public boolean isCompileOk;
    private PythonEditorVr registeredEditorVR = null;
    public String usePythonPackagePath;
    static boolean versionInfoShown = false;
    protected ResourceHelper rhBdocApi;

    @Optional
    @CreoleParameter(comment="The (file or jar) URL of the Python program to run", suffixes=".py")
    public void setPythonProgram(ResourceReference value) {
        this.pythonProgram = value;
    }

    public ResourceReference getPythonProgram() {
        return this.pythonProgram;
    }

    @Optional
    @RunTime
    @CreoleParameter(comment="The (file or jar) URL of the Python program to run")
    public void setConfigFile(URL value) {
        this.configFile = value;
    }

    public URL getConfigFile() {
        return this.configFile;
    }

    @Optional
    @RunTime
    @CreoleParameter(comment="Extra parameters to pass on to the Python program")
    public void setProgramParams(FeatureMap parms) {
        this.programParams = parms;
    }

    public FeatureMap getProgramParams() {
        return this.programParams;
    }

    @Optional
    @RunTime
    @CreoleParameter(comment="Python interpreter name (on system PATH)", disjunction="pythonbin", priority=1, defaultValue="python")
    public void setPythonBinary(String value) {
        this.pythonBinary = value;
    }

    public String getPythonBinary() {
        return this.pythonBinary;
    }

    @Optional
    @RunTime
    @CreoleParameter(comment="Python interpreter file URL. If provided overrides pythonBinary.", priority=10, disjunction="pythonbin")
    public void setPythonBinaryUrl(URL value) {
        this.pythonBinaryUrl = value;
    }

    public URL getPythonBinaryUrl() {
        return this.pythonBinaryUrl;
    }

    @CreoleParameter(defaultValue="false")
    @HiddenCreoleParameter
    public void setIsConfigured(Boolean value) {
        this.isConfigured = value;
    }

    public Boolean getIsConfigured() {
        return this.isConfigured;
    }

    @Optional
    @RunTime
    @CreoleParameter(comment="Logging level to use on the python side", defaultValue="INFO")
    public void setLoggingLevel(LoggingLevel value) {
        this.loggingLevel = value;
    }

    public LoggingLevel getLoggingLevel() {
        return this.loggingLevel;
    }

    @Optional
    @RunTime
    @CreoleParameter(comment="Use Python gatenlp package included in the plugin, not the system one.", defaultValue="true")
    public void setUsePluginGatenlpPackage(Boolean value) {
        this.usePluginGatenlpPackage = value;
    }

    public Boolean getUsePluginGatenlpPackage() {
        if (this.usePluginGatenlpPackage == null) {
            return true;
        }
        return this.usePluginGatenlpPackage;
    }

    @Optional
    @RunTime
    @CreoleParameter(comment="Result object.")
    public void setOutputResultResource(PythonPrResult value) {
        this.outputResultResource = value;
    }

    public PythonPrResult getOutputResultResource() {
        return this.outputResultResource;
    }

    @Optional
    @RunTime
    @CreoleParameter(comment="Annotation set names to send and use in Python, *=all, null/space=default set", defaultValue="*")
    public void setSetsToUse(Set<String> val) {
        HashSet<String> tmp = new HashSet<String>();
        for (String n : val) {
            if (n == null || n.trim().isEmpty()) {
                tmp.add(null);
                continue;
            }
            tmp.add(n.trim());
        }
        this.setsToUse = tmp;
    }

    public Set<String> getSetsToUse() {
        return this.setsToUse;
    }

    @Sharable
    public void setNrDuplicates(AtomicInteger value) {
        this.nrDuplicates = value;
    }

    public AtomicInteger getNrDuplicates() {
        return this.nrDuplicates;
    }

    @Sharable
    public void setResultList(List<Object> value) {
        this.resultList = value;
    }

    public List<Object> getResultList() {
        return this.resultList;
    }

    @Sharable
    public void setRunningDuplicates(AtomicInteger value) {
        this.runningDuplicates = value;
    }

    public AtomicInteger getRunningDuplicates() {
        return this.runningDuplicates;
    }

    public int getDuplicateId() {
        return this.duplicateId;
    }

    public void ensurePythonProgramCommand() {
        if ((this.pythonBinary == null || this.pythonBinary.isEmpty()) && this.pythonBinaryUrl == null) {
            throw new GateRuntimeException("Cannot run, pythonBinary or pythonBinaryUrl must be specified");
        }
        this.pythonBinaryCommand = this.pythonBinaryUrl != null ? gate.util.Files.fileFromURL((URL)this.pythonBinaryUrl).getAbsolutePath() : this.pythonBinary;
    }

    public void figureOutPythonFile(URL pythonProgramUrl) {
        if (pythonProgramUrl.getProtocol().equals("file")) {
            this.pythonProgramFile = gate.util.Files.fileFromURL((URL)pythonProgramUrl);
            if (!this.pythonProgramFile.exists()) {
                PythonPr.copyResource("/resources/templates/default.py", this.pythonProgramFile);
            }
            this.pythonProgramIsJar = false;
            this.pythonProgramPathInJar = null;
            this.pythonProgramModuleInJar = null;
            Path pythonProgramPath = FileSystems.getDefault().getPath(this.pythonProgramFile.getAbsolutePath(), new String[0]);
            if (!Files.isReadable(pythonProgramPath)) {
                throw new GateRuntimeException("File is not readable: " + this.pythonProgramFile);
            }
            this.pythonProgramIsReadonly = !Files.isWritable(pythonProgramPath);
        } else {
            this.pythonProgramIsJar = true;
            String[] info = PythonPr.jarUrl2PythonPathAndModule(pythonProgramUrl);
            this.pythonProgramPathInJar = info[0];
            this.pythonProgramModuleInJar = info[1];
            this.pythonProgramFileInJar = info[2];
        }
    }

    public boolean pythonFileCanBeEdited() {
        return !this.pythonProgramIsJar && !this.pythonProgramIsReadonly;
    }

    public URL getPythonProgramUrl() {
        return this.pythonProgramUrl;
    }

    /*
     * Exception decompiling
     */
    public String getPythonProgramString() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public File getPythonProgramFile() {
        return this.pythonProgramFile;
    }

    public boolean tryCompileProgram() {
        this.ensurePythonProgramCommand();
        boolean doQuoting = false;
        CommandLine cmdLine = new CommandLine(this.pythonBinaryCommand);
        String pythonPath = "";
        if (this.getUsePluginGatenlpPackage().booleanValue()) {
            pythonPath = this.usePythonPackagePath;
        }
        if (!this.pythonProgramIsJar) {
            cmdLine.addArgument(this.pythonProgramFile.getAbsolutePath(), doQuoting);
        } else {
            pythonPath = pythonPath.isEmpty() ? this.pythonProgramPathInJar : pythonPath + (PythonPr.isOsWindows() ? ";" : ":") + this.pythonProgramPathInJar;
            cmdLine.addArgument("-m");
            cmdLine.addArgument(this.pythonProgramModuleInJar, doQuoting);
        }
        cmdLine.addArgument("--mode");
        cmdLine.addArgument("check");
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(10000L);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setWatchdog(watchdog);
        executor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        HashMap<String, String> env = new HashMap<String, String>();
        env.putAll(System.getenv());
        env.put("FROMGATEPLUGIN", "1");
        env.put("PYTHONPATH", pythonPath);
        try {
            if (this.loggingLevel == LoggingLevel.DEBUG) {
                this.logger.info("Trying to compile program:");
                this.logger.info("Python path is " + pythonPath);
                this.logger.info("Running: " + cmdLine);
            }
            executor.execute(cmdLine, env, (ExecuteResultHandler)resultHandler);
        }
        catch (IOException ex) {
            throw new GateRuntimeException("Could not check the python file", (Throwable)ex);
        }
        try {
            resultHandler.waitFor();
        }
        catch (InterruptedException ex) {
            throw new GateRuntimeException("Something went wrong when checking the python file", (Throwable)ex);
        }
        int exitCode = resultHandler.getExitValue();
        ExecuteException exc = resultHandler.getException();
        if (exc != null) {
            this.logger.error("Got exception running the compile command: " + exc);
        }
        if (this.loggingLevel == LoggingLevel.DEBUG) {
            this.logger.info("Got return value from compiling: " + exitCode);
        }
        boolean bl = this.isCompileOk = exitCode == 0;
        if (this.registeredEditorVR != null) {
            if (this.isCompileOk) {
                this.registeredEditorVR.setCompilationOk();
            } else {
                this.registeredEditorVR.setCompilationError();
            }
        }
        return this.isCompileOk;
    }

    public void registerEditorVR(PythonEditorVr vr) {
        this.registeredEditorVR = vr;
    }

    public static String[] jarUrl2PythonPathAndModule(URL jarUrl) {
        String urlPath;
        String urlFile;
        if (!"jar".equals(jarUrl.getProtocol())) {
            throw new RuntimeException("Expected JAR url but got: " + jarUrl);
        }
        String urlString = jarUrl.toString();
        int sepIdx = (urlString = PythonPr.removeValidProtocols(urlString)).indexOf("!/");
        if (sepIdx == -1) {
            urlFile = urlString;
            urlPath = "/";
        } else {
            urlFile = urlString.substring(0, sepIdx);
            urlPath = urlString.substring(sepIdx + 1);
        }
        sepIdx = urlPath.lastIndexOf("/");
        String file = urlPath.substring(sepIdx + 1);
        String path = urlPath.substring(0, sepIdx);
        String module = file;
        if (file.endsWith(".py")) {
            module = file.substring(0, file.length() - 3);
        }
        path = urlFile + path;
        String[] ret = new String[]{path, module, file};
        return ret;
    }

    public static String removeValidProtocols(String urlString) {
        if (urlString.startsWith("jar:file:///")) {
            urlString = urlString.substring(11);
        } else if (urlString.startsWith("jar:file:/")) {
            urlString = urlString.substring(9);
        } else if (urlString.startsWith("file:///")) {
            urlString = urlString.substring(7);
        } else if (urlString.startsWith("file:/")) {
            urlString = urlString.substring(5);
        } else {
            throw new GateRuntimeException("Odd JAR URL: " + urlString);
        }
        if (PythonPr.isOsWindows()) {
            urlString = urlString.substring(1);
        }
        return urlString;
    }

    public static String getPythonpathInZip() {
        URL artifactURL = PythonPr.class.getResource("/creole.xml");
        try {
            artifactURL = new URL(artifactURL, ".");
        }
        catch (MalformedURLException ex) {
            throw new GateRuntimeException("Could not get jar URL");
        }
        String urlString = artifactURL.toString();
        urlString = PythonPr.removeValidProtocols(urlString);
        if (urlString.endsWith("!/")) {
            urlString = urlString.substring(0, urlString.length() - 2);
        } else if (urlString.endsWith("/")) {
            urlString = urlString.substring(0, urlString.length() - 1);
        }
        urlString = urlString + "/resources/pythonpath";
        return urlString;
    }

    private Map<String, String> getParms(File parmFile) {
        HashMap map;
        ObjectMapper om = new ObjectMapper();
        try {
            map = (HashMap)om.readValue(parmFile, Map.class);
        }
        catch (IOException ex) {
            this.logger.error("Could not parse the parms file", (Throwable)ex);
            map = new HashMap();
        }
        return map;
    }

    public Resource init() throws ResourceInstantiationException {
        if (this.pythonProgram == null) {
            throw new ResourceInstantiationException("Parameter pythonProgram must be set!");
        }
        String scheme = this.pythonProgram.toURI().getScheme();
        if (!("file".equals(scheme) || "jar".equals(scheme) || "creole".equals(scheme))) {
            throw new ResourceInstantiationException("Parameter pythonProgram is not a file, jar, or creole URL but: " + this.getPythonProgram());
        }
        this.usePythonPackagePath = PythonPr.getPythonpathInZip();
        this.pythonProgramUrl = null;
        try {
            this.pythonProgramUrl = this.pythonProgram.toURL();
        }
        catch (IOException ex) {
            throw new ResourceInstantiationException("Could not convert to URL: " + this.pythonProgram, (Exception)ex);
        }
        this.figureOutPythonFile(this.pythonProgramUrl);
        if (this.nrDuplicates == null) {
            this.nrDuplicates = new AtomicInteger(1);
            this.runningDuplicates = new AtomicInteger(0);
            this.duplicateId = 0;
            ArrayList wrappedList = new ArrayList();
            this.setResultList(Collections.synchronizedList(wrappedList));
        } else {
            this.duplicateId = this.nrDuplicates.getAndAdd(1);
        }
        this.rhBdocApi = (ResourceHelper)((ResourceData)Gate.getCreoleRegister().get((Object)"gate.plugin.format.bdoc.API")).getInstantiations().iterator().next();
        if (this.getIsConfigured() == null || !this.getIsConfigured().booleanValue()) {
            if (this.getProgramParams() == null) {
                if (this.pythonProgramIsJar) {
                    try {
                        ResourceReference check = new ResourceReference(new URI(this.getPythonProgram().toURI().toString() + ".parms"));
                        ObjectMapper om = new ObjectMapper();
                        Map map = (Map)om.readValue(check.openStream(), Map.class);
                        this.setProgramParams(Utils.toFeatureMap((Map)map));
                    }
                    catch (FileNotFoundException ex) {
                        this.logger.debug("Ignoring the FileNotFoundException");
                    }
                    catch (IOException | URISyntaxException ex) {
                        this.logger.error("Got exception trying to find parms file", (Throwable)ex);
                    }
                } else {
                    File parmFile = new File(this.pythonProgramFile.getAbsolutePath() + ".parms");
                    if (parmFile.exists()) {
                        this.setProgramParams(Utils.toFeatureMap(this.getParms(parmFile)));
                    }
                }
            }
            this.setIsConfigured(true);
        }
        return this;
    }

    protected void whenStarting() {
        this.runningDuplicates.getAndIncrement();
        this.ensurePythonProgramCommand();
        this.isCompileOk = this.tryCompileProgram();
        if (!this.isCompileOk) {
            throw new GateRuntimeException("Cannot run the python program, may have a syntax error or other compile-time problem.");
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("FROMGATEPLUGIN", "1");
        String pythonPath = "";
        if (this.getUsePluginGatenlpPackage().booleanValue()) {
            pythonPath = this.usePythonPackagePath;
        }
        if (this.pythonProgramIsJar) {
            pythonPath = pythonPath.isEmpty() ? this.pythonProgramPathInJar : pythonPath + (PythonPr.isOsWindows() ? ";" : ":") + this.pythonProgramPathInJar;
            env.put("PYTHONPATH", pythonPath);
            this.process = Process4StringStream.create((File)new File("."), env, (String[])new String[]{this.pythonBinaryCommand, "-m", this.pythonProgramModuleInJar, "--mode", "pipe", "--log_lvl", this.loggingLevel.toString()});
        } else {
            env.put("PYTHONPATH", pythonPath);
            this.process = Process4StringStream.create((File)new File("."), env, (String[])new String[]{this.pythonBinaryCommand, this.pythonProgramFile.getAbsolutePath(), "--mode", "pipe", "--log_lvl", this.loggingLevel.toString()});
        }
        String responseJson = (String)this.process.process((Object)this.makeStartRequest());
        if (responseJson == null) {
            throw new GateRuntimeException("Invalid null response from Python process, did you run interact()?");
        }
        try {
            Map response = JSON.std.mapFrom((Object)responseJson);
            if (!response.containsKey("status") || !"ok".equals(response.get("status"))) {
                throw new GateRuntimeException("Something went wrong, start response is " + responseJson);
            }
        }
        catch (IOException ex) {
            throw new GateRuntimeException("Could not convert start response", (Throwable)ex);
        }
    }

    protected void whenFinishing() {
        int exitValue;
        FinishResponse response;
        this.runningDuplicates.getAndDecrement();
        this.logger.debug("Finishing duplicate " + this.duplicateId + " running: " + this.runningDuplicates.get());
        String responseJson = (String)this.process.process((Object)this.makeFinishRequest());
        Map<String, Object> result = null;
        try {
            response = (FinishResponse)JSON.std.beanFrom(FinishResponse.class, (Object)responseJson);
            if (!"ok".equals(response.status)) {
                throw new GateRuntimeException("Error Finishing Processing: " + response.error + "\nAdditional info from Python:\n" + response.info);
            }
            Map<String, Object> data = response.data;
            if (this.nrDuplicates.get() == 1) {
                result = data;
            } else if (data != null) {
                this.getResultList().add(data);
            }
        }
        catch (IOException ex) {
            throw new GateRuntimeException("Could not convert execute response JSON: " + responseJson, (Throwable)ex);
        }
        if (this.runningDuplicates.get() == 0) {
            if (!this.getResultList().isEmpty()) {
                this.logger.debug("Calling reduce for number of results: " + this.getResultList().size());
                responseJson = (String)this.process.process((Object)this.makeReduceRequest());
                try {
                    response = (FinishResponse)JSON.std.beanFrom(FinishResponse.class, (Object)responseJson);
                    if (!"ok".equals(response.status)) {
                        throw new GateRuntimeException("Error calling Reduce: " + response.error + "\nAdditional info from Python:\n" + response.info);
                    }
                    result = response.data;
                }
                catch (IOException ex) {
                    throw new GateRuntimeException("Could not convert execute response JSON: " + responseJson, (Throwable)ex);
                }
            } else {
                this.logger.debug("Not calling reduce, result list is empty");
            }
            if (this.getOutputResultResource() != null) {
                this.getOutputResultResource().setResultData(result);
            } else if (result != null) {
                this.getFeatures().putAll(result);
            }
        }
        if ((exitValue = this.process.stop()) != 0) {
            this.logger.info("Warning: python process ended with exit value " + exitValue);
        }
    }

    public void reInit() throws ResourceInstantiationException {
        this.nrDuplicates = null;
        super.reInit();
        this.init();
    }

    public void cleanup() {
        super.cleanup();
    }

    private void ensureProcess() throws ExecutionException {
        if (this.process == null || !this.process.isAlive()) {
            throw new ExecutionException("Python process not alive during execution");
        }
    }

    public void execute() throws ExecutionException {
        if (this.isInterrupted()) {
            throw new ExecutionException("Processing was interrupted");
        }
        this.ensureProcess();
        String responseJson = (String)this.process.process((Object)this.makeExecuteRequest(this.document));
        try {
            ExecuteResponse response = (ExecuteResponse)JSON.std.beanFrom(ExecuteResponse.class, (Object)responseJson);
            if (!"ok".equals(response.status)) {
                this.logger.debug("Python exception, stacktrace we got: " + response.stacktrace);
                throw new GateRuntimeException("Error processing document: " + response.error + "\nAdditional info from Python:\n" + response.info);
            }
            if (response.data == null) {
                throw new GateRuntimeException("Got null changelog back from process");
            }
            this.rhBdocApi.call("update_document_from_logmap", (Resource)this.document, new Object[]{response.data});
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new GateRuntimeException("Could not convert execute response JSON: " + responseJson, (Throwable)ex);
        }
    }

    public void controllerExecutionStarted(Controller controller) {
        this.whenStarting();
    }

    public void controllerExecutionFinished(Controller controller) {
        this.whenFinishing();
    }

    public void controllerExecutionAborted(Controller controller, Throwable throwable) {
        this.whenFinishing();
        throw new GateRuntimeException("Exception when running pipeline", throwable);
    }

    protected String getResponseError(Map<String, Object> response) {
        String error = (String)response.get("error");
        if (error == null) {
            error = "(No error description from process)";
        }
        return error;
    }

    protected String makeExecuteRequest(Document doc) {
        Map mdoc;
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("command", "execute");
        try {
            mdoc = this.setsToUse == null || this.setsToUse.contains("*") ? (Map)this.rhBdocApi.call("bdocmap_from_doc", (Resource)this.document, new Object[0]) : (Map)this.rhBdocApi.call("bdocmap_from_doc", (Resource)this.document, new Object[]{this.setsToUse, true});
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new GateRuntimeException("Error when trying to convert document to map", (Throwable)ex);
        }
        request.put("data", mdoc);
        try {
            return JSON.std.asString(request);
        }
        catch (IOException ex) {
            throw new GateRuntimeException("Error when trying to convert execute request to JSON", (Throwable)ex);
        }
    }

    protected String makeStartRequest() {
        Map params;
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("command", "start");
        FeatureMap programParamsToUse = this.programParams == null ? Factory.newFeatureMap() : this.programParams;
        try {
            params = (Map)this.rhBdocApi.call("fmap_to_map", null, new Object[]{programParamsToUse});
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new GateRuntimeException("Could not create start request map", (Throwable)ex);
        }
        params.put("_duplicateId", this.duplicateId);
        params.put("_nrDuplicates", this.nrDuplicates.get());
        if (this.pythonProgramIsJar) {
            params.put("_pythonPath", this.pythonProgramPathInJar);
            params.put("_pythonModule", this.pythonProgramModuleInJar);
        } else {
            params.put("_pythonFile", this.pythonProgramFile.getAbsolutePath());
        }
        if (this.configFile != null) {
            params.put("_config_file", gate.util.Files.fileFromURL((URL)this.getConfigFile()).getAbsolutePath());
        }
        request.put("data", params);
        try {
            return JSON.std.asString(request);
        }
        catch (IOException ex) {
            throw new GateRuntimeException("Error when trying to convert start request to JSON", (Throwable)ex);
        }
    }

    protected String makeFinishRequest() {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("command", "finish");
        try {
            return JSON.std.asString(request);
        }
        catch (IOException ex) {
            throw new GateRuntimeException("Error when trying to convert finish request to JSON", (Throwable)ex);
        }
    }

    protected String makeReduceRequest() {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("command", "reduce");
        request.put("data", this.getResultList());
        try {
            return JSON.std.asString(request);
        }
        catch (IOException ex) {
            throw new GateRuntimeException("Error when trying to convert reduce request to JSON", (Throwable)ex);
        }
    }

    public static void copyResource(String source, File targetPath) {
        URL artifactURL = PythonPr.class.getResource("/creole.xml");
        try {
            artifactURL = new URL(artifactURL, ".");
        }
        catch (MalformedURLException ex) {
            throw new GateRuntimeException("Could not get jar URL");
        }
        if (artifactURL.toString().startsWith("file:/")) {
            try {
                File containingDir = gate.util.Files.fileFromURL((URL)artifactURL);
                File fromFile = new File(containingDir, source);
                Files.copy(fromFile.toPath(), targetPath.toPath(), new CopyOption[0]);
            }
            catch (IOException ex) {
                throw new GateRuntimeException("Error trying to copy the resources", (Throwable)ex);
            }
        }
        try (FileSystem zipFs = FileSystems.newFileSystem(artifactURL.toURI(), new HashMap());){
            Path target = Paths.get(targetPath.toURI());
            Path pathInZip = zipFs.getPath(source, new String[0]);
            if (Files.isDirectory(pathInZip, new LinkOption[0])) {
                throw new GateRuntimeException("ODD: is a directory " + pathInZip);
            }
            Files.copy(pathInZip, target, new CopyOption[0]);
        }
        catch (IOException | URISyntaxException ex) {
            throw new GateRuntimeException("Error trying to copy the resources", (Throwable)ex);
        }
    }

    public static boolean isOsWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.UK).contains("win");
    }

    protected static class FinishResponse {
        public String status;
        public String error;
        public String info;
        public List<List<String>> stacktrace;
        public Map<String, Object> data;

        protected FinishResponse() {
        }
    }

    protected static class ExecuteResponse {
        public String status;
        public String error;
        public String info;
        public List<List<String>> stacktrace;
        public Map<String, Object> data;

        protected ExecuteResponse() {
        }
    }

    public static enum LoggingLevel {
        DEBUG,
        INFO,
        WARNING,
        ERROR,
        CRITICAL;

    }
}

