/*
 * Decompiled with CFR 0.152.
 */
package gate.plugin.python;

import gate.Resource;
import gate.creole.AbstractResource;
import gate.creole.metadata.AutoInstance;
import gate.creole.metadata.CreoleResource;
import gate.lib.interaction.process.pipes.Process4StringStream;
import gate.plugin.python.PythonPr;
import gate.util.GateRuntimeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

@CreoleResource(name="PythonVersionLogger", comment="Log the version of the Python plugin and the included gatenlp package", tool=true, isPrivate=true, autoinstances={@AutoInstance(hidden=true)})
public class VersionLogger
extends AbstractResource {
    protected boolean versionInfoShown = false;
    private static final long serialVersionUID = 1288492373838L;
    public transient Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    static String pluginVersion = "unknown";
    static String pluginBuild = "unknown";

    public static String getPluginVersion() {
        return pluginVersion;
    }

    public static String getPluginBuild() {
        return pluginBuild;
    }

    public static String readGateNlpVersion() {
        URL artifactURL = PythonPr.class.getResource("/creole.xml");
        List<Object> lines = new ArrayList<String>();
        File fromFile = null;
        Object pathInZip = null;
        try {
            artifactURL = new URL(artifactURL, ".");
        }
        catch (MalformedURLException ex) {
            throw new GateRuntimeException("Could not get jar URL");
        }
        if (artifactURL.toString().startsWith("file:/")) {
            try {
                String pythonProgramPathName = PythonPr.getPythonpathInZip();
                File theFile = new File(new File(pythonProgramPathName, "gatenlp"), "version.py");
                String string = theFile.getAbsolutePath();
                fromFile = new File(string);
                lines = Files.readAllLines(fromFile.toPath(), Charset.forName("UTF-8"));
            }
            catch (IOException ex) {
                throw new GateRuntimeException("Error trying to read the resource " + fromFile, (Throwable)ex);
            }
        }
        URL fileURL = PythonPr.class.getResource("/resources/pythonpath/gatenlp/version.py");
        try (BufferedReader rdr = new BufferedReader(new InputStreamReader(fileURL.openStream()));){
            String string;
            while ((string = rdr.readLine()) != null) {
                lines.add(string);
            }
        }
        catch (IOException ex) {
            throw new GateRuntimeException("Error trying to read the resource " + pathInZip, (Throwable)ex);
        }
        String version = "UNKNOWN";
        for (String string : lines) {
            if (!string.startsWith("__version__")) continue;
            version = string.split("\"")[1];
            break;
        }
        return version;
    }

    public Resource init() {
        if (!this.versionInfoShown) {
            String isDirty;
            String buildVersion;
            InputStream is;
            Properties properties;
            try {
                properties = new Properties();
                is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("gateplugin-Python.git.properties");
                if (is != null) {
                    properties.load(is);
                    buildVersion = properties.getProperty("gitInfo.build.version");
                    isDirty = properties.getProperty("gitInfo.dirty");
                    this.logger.info((Object)("Plugin Python version: " + buildVersion + " commit: " + properties.getProperty("gitInfo.commit.id.abbrev") + " dirty: " + isDirty));
                    pluginVersion = properties.getProperty("gitInfo.build.version");
                    pluginBuild = properties.getProperty("gitInfo.commit.id.abbrev");
                } else {
                    this.logger.error((Object)"Could not obtain plugin Python version info");
                }
            }
            catch (IOException ex) {
                this.logger.error((Object)("Could not obtain plugin Python version info: " + ex.getMessage()), (Throwable)ex);
            }
            try {
                properties = new Properties();
                is = Process4StringStream.class.getClassLoader().getResourceAsStream("gatelib-interaction.git.properties");
                if (is != null) {
                    properties.load(is);
                    buildVersion = properties.getProperty("gitInfo.build.version");
                    isDirty = properties.getProperty("gitInfo.dirty");
                    this.logger.info((Object)("Lib interaction version: " + buildVersion + " commit: " + properties.getProperty("gitInfo.commit.id.abbrev") + " dirty: " + isDirty));
                }
            }
            catch (IOException ex) {
                this.logger.error((Object)("Could not obtain lib interaction version info: " + ex.getMessage()), (Throwable)ex);
            }
            try {
                properties = new Properties();
                is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("python-gatenlp.git.properties");
                if (is != null) {
                    properties.load(is);
                    buildVersion = VersionLogger.readGateNlpVersion();
                    isDirty = properties.getProperty("gitInfo.dirty");
                    this.logger.info((Object)("Python gatenlp version: " + buildVersion + " commit: " + properties.getProperty("gitInfo.commit.id.abbrev") + " dirty: " + isDirty));
                }
            }
            catch (IOException ex) {
                this.logger.error((Object)("Could not obtain lib interaction version info: " + ex.getMessage()), (Throwable)ex);
            }
            this.versionInfoShown = true;
        }
        return this;
    }
}

