/*
 * Decompiled with CFR 0.152.
 */
package gate.plugin.python.gui;

import gate.plugin.python.PythonCodeDriven;
import gate.plugin.python.PythonPr;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.io.FileUtils;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class PythonEditorPanel
extends JPanel {
    private static final long serialVersionUID = 3527048169263767662L;
    PythonCodeDriven owner = null;
    protected PythonPr pr = null;
    TextEditorPane textArea;
    private JButton jButton1;
    private JButton jButton2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField jTextField1;

    public PythonEditorPanel() {
        this.initComponents();
        this.initEditor();
    }

    public void setPR(PythonPr pr) {
        this.pr = pr;
    }

    public void setCompilationError() {
        this.jTextField1.setForeground(Color.red);
    }

    public void setCompilationOk() {
        this.jTextField1.setForeground(Color.black);
    }

    public PythonEditorPanel(PythonCodeDriven theOwner) {
        this.owner = theOwner;
        this.initComponents();
        this.initEditor();
    }

    public void setFile(File scriptFile) {
        if (scriptFile != null) {
            try {
                this.textArea.load(FileLocation.create((File)scriptFile), "UTF-8");
                this.jTextField1.setText(scriptFile.getCanonicalPath());
            }
            catch (IOException ex) {
                this.jTextField1.setText("Error updating file, see log");
                System.err.println("Could not load file " + scriptFile);
                ex.printStackTrace(System.err);
            }
        }
    }

    private void initEditor() {
        this.textArea = new TextEditorPane();
        this.textArea.setSyntaxEditingStyle("text/python");
        this.textArea.setCodeFoldingEnabled(true);
        this.textArea.setAntiAliasingEnabled(true);
        this.textArea.setTabsEmulated(true);
        this.textArea.setTabSize(2);
        this.textArea.setAnimateBracketMatching(true);
        this.textArea.setAutoIndentEnabled(true);
        this.textArea.setBracketMatchingEnabled(true);
        this.textArea.setHighlightCurrentLine(true);
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this.textArea);
        sp.setMinimumSize(new Dimension(200, 200));
        sp.setFoldIndicatorEnabled(true);
        this.jPanel2.add((Component)sp);
        this.jTextField1.setForeground(Color.black);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jTextField1 = new JTextField();
        this.jButton2 = new JButton();
        this.jPanel2.setBorder(null);
        this.jPanel2.setLayout(new GridLayout());
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, 770, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, 358, Short.MAX_VALUE));
        this.jButton1.setText("Save");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonEditorPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jTextField1.setEditable(false);
        this.jTextField1.setText("jTextField1");
        this.jButton2.setText("Save & Use");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PythonEditorPanel.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField1, -1, 600, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2).addComponent(this.jTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.saveFile();
    }

    private void saveFile() {
        try {
            FileUtils.write((File)new File(this.textArea.getFileFullPath()), (CharSequence)this.textArea.getText(), (String)"UTF-8");
        }
        catch (IOException ex) {
            System.err.println("Error saving the file " + this.textArea.getFileName());
            ex.printStackTrace(System.err);
            this.jTextField1.setText("ERROR SAVING THE FILE SEE LOG");
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.saveFile();
        this.pr.tryCompileProgram();
    }

    void disableButtons() {
        this.jButton1.setEnabled(false);
        this.jButton2.setEnabled(false);
    }

    void setFileLocation(String loc) {
        this.jTextField1.setText(loc);
    }
}

