/*
 * Decompiled with CFR 0.152.
 */
package gate.plugin.python;

import gate.AnnotationSet;
import gate.Corpus;
import gate.CorpusController;
import gate.Document;
import gate.DocumentExporter;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.Main;
import gate.ProcessingResource;
import gate.Resource;
import gate.annotation.AnnotationSetImpl;
import gate.corpora.DocumentStaxUtils;
import gate.creole.AbstractController;
import gate.creole.ExecutionException;
import gate.creole.Plugin;
import gate.creole.ResourceData;
import gate.creole.ResourceInstantiationException;
import gate.creole.ResourceReference;
import gate.gui.MainFrame;
import gate.gui.ResourceHelper;
import gate.gui.creole.manager.PluginUpdateManager;
import gate.persist.PersistenceException;
import gate.plugin.python.VersionLogger;
import gate.util.GateException;
import gate.util.GateRuntimeException;
import gate.util.persistence.PersistenceManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.GatewayServer;

public class PythonWorker {
    public final transient Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected GatewayServer server;
    public boolean logActions = true;
    public boolean keepRunning = true;
    private Corpus tmpCorpus;
    protected ResourceHelper rhBdocApi = (ResourceHelper)((ResourceData)Gate.getCreoleRegister().get((Object)"gate.plugin.format.bdoc.API")).getInstantiations().iterator().next();

    public PythonWorker() throws ResourceInstantiationException {
        this.tmpCorpus = Factory.newCorpus((String)"tmpCorpus");
    }

    public void loadMavenPlugin(String group, String artifact, String version) throws GateException {
        if (this.logActions) {
            this.LOGGER.info("Worker run: load Maven plugin " + group + "/" + artifact + "/" + version);
        }
        Gate.getCreoleRegister().registerPlugin((Plugin)new Plugin.Maven(group, artifact, version));
    }

    public CorpusController loadPipelineFromFile(String path) {
        if (this.logActions) {
            this.LOGGER.info("Worker run: load controller from file " + path);
        }
        try {
            return (CorpusController)PersistenceManager.loadObjectFromFile((File)new File(path));
        }
        catch (ResourceInstantiationException | PersistenceException | IOException ex) {
            throw new GateRuntimeException("Could not load pipeline from file " + path, ex);
        }
    }

    public CorpusController loadPipelineFromUri(String uri) throws URISyntaxException {
        if (this.logActions) {
            this.LOGGER.info("Worker run: load controller from URI " + uri);
        }
        try {
            return (CorpusController)PersistenceManager.loadObjectFromUri((URI)new URI(uri));
        }
        catch (ResourceInstantiationException | PersistenceException | IOException ex) {
            throw new GateRuntimeException("Could not load pipeline from URI " + uri, ex);
        }
    }

    public Plugin.Maven findMavenPlugin(String group, String artifact) {
        if (this.logActions) {
            this.LOGGER.info("Worker run: find Maven plugin " + group + "/" + artifact);
        }
        LinkedHashSet allPlugins = new LinkedHashSet(Gate.getCreoleRegister().getPlugins());
        allPlugins.addAll(PluginUpdateManager.getDefaultPlugins());
        for (Plugin plugin : allPlugins) {
            Plugin.Maven mp;
            if (!(plugin instanceof Plugin.Maven) || !(mp = (Plugin.Maven)plugin).getGroup().equals(group) || !mp.getArtifact().equals(artifact)) continue;
            return mp;
        }
        return null;
    }

    public CorpusController loadPipelineFromPlugin(String group, String artifact, String path) throws URISyntaxException {
        ResourceReference rr;
        Plugin.Maven mp;
        if (this.logActions) {
            this.LOGGER.info("Worker run: load pipeline " + path + " from plugin " + group + "/" + artifact);
        }
        if ((mp = this.findMavenPlugin(group, artifact)) == null) {
            throw new GateRuntimeException("Could not find plugin, please load it first!");
        }
        try {
            rr = new ResourceReference((Plugin)mp, path);
        }
        catch (URISyntaxException ex) {
            throw new GateRuntimeException("Could not create ResourceReference for the pipeline");
        }
        if (rr == null) {
            throw new GateRuntimeException("Could not create ResourceReference for the pipeline");
        }
        try {
            return (CorpusController)PersistenceManager.loadObjectFromUri((URI)rr.toURI());
        }
        catch (ResourceInstantiationException | PersistenceException | IOException ex) {
            throw new GateRuntimeException("Could not load pipeline from " + path, ex);
        }
    }

    public Document loadDocumentFromFile(String path) {
        if (this.logActions) {
            this.LOGGER.info("Worker run: load document from " + path);
        }
        return this.loadDocumentFromFile(path, null);
    }

    public Document createDocument(String content) {
        if (this.logActions) {
            this.LOGGER.info("Worker run: createDocument from content");
        }
        try {
            return Factory.newDocument((String)content);
        }
        catch (ResourceInstantiationException ex) {
            throw new GateRuntimeException("Could not create document", (Throwable)ex);
        }
    }

    public Corpus newCorpus() {
        if (this.logActions) {
            this.LOGGER.info("Worker run: create new corpus");
        }
        try {
            return Factory.newCorpus((String)("Corpus_" + Gate.genSym()));
        }
        catch (ResourceInstantiationException ex) {
            throw new GateRuntimeException("Could not create document", (Throwable)ex);
        }
    }

    public void deleteResource(Resource res) {
        if (this.logActions) {
            this.LOGGER.info("Worker run: remove resource" + res.getName());
        }
        Factory.deleteResource((Resource)res);
    }

    public void run4Document(CorpusController pipeline, Document doc) {
        if (this.logActions) {
            this.LOGGER.info("Worker run: run controller " + pipeline.getName() + " for " + doc.getName());
        }
        this.tmpCorpus.clear();
        this.tmpCorpus.add((Object)doc);
        if (pipeline instanceof AbstractController) {
            ((AbstractController)pipeline).setControllerCallbacksEnabled(false);
        }
        pipeline.setCorpus(this.tmpCorpus);
        try {
            pipeline.execute();
        }
        catch (ExecutionException ex) {
            throw new GateRuntimeException("Exception when running the pipeline", (Throwable)ex);
        }
    }

    public void runExecutionStarted(CorpusController pipeline) {
        if (this.logActions) {
            this.LOGGER.info("Worker run: run executionStarted for " + pipeline.getName());
        }
        if (pipeline instanceof AbstractController) {
            try {
                ((AbstractController)pipeline).invokeControllerExecutionStarted();
            }
            catch (ExecutionException ex) {
                throw new GateRuntimeException("Problem running ExecutionStarted", (Throwable)ex);
            }
        }
    }

    public void runExecutionFinished(CorpusController pipeline) {
        if (this.logActions) {
            this.LOGGER.info("Worker run: run executionFinished for " + pipeline.getName());
        }
        if (pipeline instanceof AbstractController) {
            try {
                ((AbstractController)pipeline).invokeControllerExecutionFinished();
            }
            catch (ExecutionException ex) {
                throw new GateRuntimeException("Problem running ExecutionFinished", (Throwable)ex);
            }
        }
    }

    public void run4Corpus(CorpusController pipeline, Corpus corpus) {
        if (this.logActions) {
            this.LOGGER.info("Worker run: run pipline " + pipeline.getName() + " for corpus " + corpus.getName());
        }
        if (pipeline instanceof AbstractController) {
            ((AbstractController)pipeline).setControllerCallbacksEnabled(true);
        }
        pipeline.setCorpus(corpus);
        try {
            pipeline.execute();
        }
        catch (ExecutionException ex) {
            throw new GateRuntimeException("Exception when running the pipeline", (Throwable)ex);
        }
    }

    public Document loadDocumentFromFile(String path, String mimeType) {
        if (this.logActions) {
            this.LOGGER.info("Worker run: load document from " + path + " mimetype:" + mimeType);
        }
        FeatureMap params = Factory.newFeatureMap();
        try {
            params.put((Object)"sourceUrl", (Object)new File(path).toURI().toURL());
            if (mimeType != null) {
                params.put((Object)"mimeType", (Object)mimeType);
            }
            params.put((Object)"encoding", (Object)"utf-8");
            Document doc = (Document)Factory.createResource((String)"gate.corpora.DocumentImpl", (FeatureMap)params);
            return doc;
        }
        catch (ResourceInstantiationException | MalformedURLException ex) {
            throw new GateRuntimeException("Could not load document from " + path, ex);
        }
    }

    public void saveDocumentToFile(Document doc, String path, String mimetype) throws IOException, XMLStreamException {
        this.saveDocumentToFile(doc, path, mimetype, null, "", false);
    }

    public void saveDocumentToFile(Document doc, String path, String mimetype, List<String> inlineAnntypes, String inlineAnnset, Boolean inlineFeatures) throws XMLStreamException, IOException {
        block32: {
            if (this.logActions) {
                this.LOGGER.info("Worker run: save document to " + path + " mimetype:" + mimetype);
            }
            if (mimetype == null || mimetype.isEmpty()) {
                DocumentStaxUtils.writeDocument((Document)doc, (File)new File(path));
            } else if ("application/fastinfoset".equals(mimetype)) {
                DocumentExporter docExporter = (DocumentExporter)((ResourceData)Gate.getCreoleRegister().get((Object)"gate.corpora.FastInfosetExporter")).getInstantiations().iterator().next();
                docExporter.export(doc, new File(path), Factory.newFeatureMap());
            } else if ("text/bdocjs".equals(mimetype) || "bdocjs".equals(mimetype)) {
                DocumentExporter docExporter = (DocumentExporter)((ResourceData)Gate.getCreoleRegister().get((Object)"gate.plugin.format.bdoc.ExporterBdocJson")).getInstantiations().iterator().next();
                docExporter.export(doc, new File(path), Factory.newFeatureMap());
            } else if ("text/bdocjs+gzip".equals(mimetype) || "bdocjs+gzip".equals(mimetype)) {
                DocumentExporter docExporter = (DocumentExporter)((ResourceData)Gate.getCreoleRegister().get((Object)"gate.plugin.format.bdoc.ExporterBdocJsonGzip")).getInstantiations().iterator().next();
                docExporter.export(doc, new File(path), Factory.newFeatureMap());
            } else if ("text/bdocym".equals(mimetype) || "bdocym".equals(mimetype)) {
                DocumentExporter docExporter = (DocumentExporter)((ResourceData)Gate.getCreoleRegister().get((Object)"gate.plugin.format.bdoc.ExporterBdocYaml")).getInstantiations().iterator().next();
                docExporter.export(doc, new File(path), Factory.newFeatureMap());
            } else if ("text/bdocym+gzip".equals(mimetype) || "bdocym+gzip".equals(mimetype)) {
                DocumentExporter docExporter = (DocumentExporter)((ResourceData)Gate.getCreoleRegister().get((Object)"gate.plugin.format.bdoc.ExporterBdocYamlGzip")).getInstantiations().iterator().next();
                docExporter.export(doc, new File(path), Factory.newFeatureMap());
            } else if ("application/bdocmp".equals(mimetype) || "text/bdocmp".equals(mimetype) || "bdocmp".equals(mimetype)) {
                DocumentExporter docExporter = (DocumentExporter)((ResourceData)Gate.getCreoleRegister().get((Object)"gate.plugin.format.bdoc.ExporterBdocMsgPack")).getInstantiations().iterator().next();
                docExporter.export(doc, new File(path), Factory.newFeatureMap());
            } else {
                if ("text/xml".equals(mimetype)) {
                    AnnotationSet withRoot;
                    if (inlineAnnset == null || inlineAnnset.isEmpty()) {
                        inlineAnnset = "";
                    }
                    if (null == inlineFeatures) {
                        inlineFeatures = true;
                    }
                    AnnotationSet allAnnots = doc.getAnnotations(inlineAnnset);
                    if (inlineAnntypes == null) {
                        withRoot = allAnnots;
                    } else if (inlineAnntypes.isEmpty()) {
                        withRoot = new AnnotationSetImpl(doc);
                    } else {
                        withRoot = new AnnotationSetImpl(doc);
                        HashSet<String> types2Export = new HashSet<String>(inlineAnntypes);
                        AnnotationSet annots2Export = allAnnots.get(types2Export);
                        withRoot.addAll((Collection)annots2Export);
                    }
                    try (FileOutputStream outputStream = new FileOutputStream(new File(path));
                         OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, "UTF-8");){
                        writer.write(doc.toXml((Set)withRoot, inlineFeatures.booleanValue()));
                        writer.flush();
                        break block32;
                    }
                }
                throw new IOException("Mime type " + mimetype + " not supported");
            }
        }
    }

    public String getBdocJson(Document doc) {
        if (this.logActions) {
            this.LOGGER.info("Worker run: get bdocjson for " + doc.getName());
        }
        ResourceHelper rh = (ResourceHelper)((ResourceData)Gate.getCreoleRegister().get((Object)"gate.plugin.format.bdoc.API")).getInstantiations().iterator().next();
        try {
            String json = (String)rh.call("json_from_doc", (Resource)doc, new Object[0]);
            return json;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new GateRuntimeException("Could not convert GATE document to json", (Throwable)ex);
        }
    }

    public Document getDocument4BdocJson(String bdocjson) throws ResourceInstantiationException {
        try {
            if (this.logActions) {
                this.LOGGER.info("Worker run: create document from bdocjson");
            }
            ResourceHelper rh = (ResourceHelper)((ResourceData)Gate.getCreoleRegister().get((Object)"gate.plugin.format.bdoc.API")).getInstantiations().iterator().next();
            Document theDoc = (Document)rh.call("doc_from_json", null, new Object[]{bdocjson});
            return theDoc;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new GateRuntimeException("Error invoking Format Bdoc API method doc_from_json", (Throwable)ex);
        }
    }

    public void print2out(String txt) {
        System.out.print(txt);
    }

    public void print2err(String txt) {
        System.err.print(txt);
    }

    public void showGui() {
        if (this.logActions) {
            this.LOGGER.info("Worker run: sho GUI");
        }
        if (MainFrame.getInstance().isVisible()) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Main.applyUserPreferences();
                MainFrame.getInstance().setVisible(true);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    public List<Resource> getResources4Name(String name) throws GateException {
        if (this.logActions) {
            this.LOGGER.info("Worker run: get resource for name " + name);
        }
        return Gate.getCreoleRegister().getAllInstances("gate.Resource");
    }

    public List<Resource> getResources4Name(String name, String clazz) throws GateException {
        if (this.logActions) {
            this.LOGGER.info("Worker run: get resource for name " + name + " and class " + clazz);
        }
        return Gate.getCreoleRegister().getAllInstances(clazz);
    }

    public Document getDocument4Name(String name) throws GateException {
        List<Resource> matching;
        if (this.logActions) {
            this.LOGGER.info("Worker run: get document for name " + name);
        }
        if ((matching = this.getResources4Name(name, "gate.Document")).size() > 0) {
            return (Document)matching.get(0);
        }
        return null;
    }

    public Corpus getCorpus4Name(String name) throws GateException {
        List<Resource> matching;
        if (this.logActions) {
            this.LOGGER.info("Worker run: get corpus with name " + name);
        }
        if ((matching = this.getResources4Name(name, "gate.Corpus")).size() > 0) {
            return (Corpus)matching.get(0);
        }
        return null;
    }

    public CorpusController getPipeline4Name(String name) throws GateException {
        List<Resource> matching;
        if (this.logActions) {
            this.LOGGER.info("Worker run: get pipeline with name " + name);
        }
        if ((matching = this.getResources4Name(name, "gate.CorpusController")).size() > 0) {
            return (CorpusController)matching.get(0);
        }
        return null;
    }

    public ProcessingResource getPr4Name(String name) throws GateException {
        List<Resource> matching;
        if (this.logActions) {
            this.LOGGER.info("Worker run: get processing resource with name " + name);
        }
        if ((matching = this.getResources4Name(name, "gate.ProcessingResource")).size() > 0) {
            return (ProcessingResource)matching.get(0);
        }
        return null;
    }

    public List<String> getDocumentNames() throws GateException {
        if (this.logActions) {
            this.LOGGER.info("Worker run: get known document names");
        }
        List tmp = Gate.getCreoleRegister().getAllInstances("gate.Document");
        ArrayList<String> names = new ArrayList<String>();
        for (Resource r : tmp) {
            names.add(r.getName());
        }
        return names;
    }

    public List<String> getCorpusNames() throws GateException {
        if (this.logActions) {
            this.LOGGER.info("Worker run: get known corpus names");
        }
        List tmp = Gate.getCreoleRegister().getAllInstances("gate.Corpus");
        ArrayList<String> names = new ArrayList<String>();
        for (Resource r : tmp) {
            names.add(r.getName());
        }
        return names;
    }

    public List<String> getPipelineNames() throws GateException {
        if (this.logActions) {
            this.LOGGER.info("Worker run: get known pipeline names");
        }
        List tmp = Gate.getCreoleRegister().getAllInstances("gate.CorpusController");
        ArrayList<String> names = new ArrayList<String>();
        for (Resource r : tmp) {
            names.add(r.getName());
        }
        return names;
    }

    public List<String> getPrNames() throws GateException {
        if (this.logActions) {
            this.LOGGER.info("Worker run: get known resource names");
        }
        List tmp = Gate.getCreoleRegister().getAllInstances("gate.ProcessingResource");
        ArrayList<String> names = new ArrayList<String>();
        for (Resource r : tmp) {
            names.add(r.getName());
        }
        return names;
    }

    public String jsonAnnsets4Doc(Document doc, List<List<String>> annsets) {
        try {
            return (String)this.rhBdocApi.call("jsonannsets_from_docanns", (Resource)doc, new Object[]{annsets});
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException ex) {
            throw new GateRuntimeException("Problem retrieving the annotations", (Throwable)ex);
        }
    }

    public String jsonAnnsets4Doc(Document doc) {
        return this.jsonAnnsets4Doc(doc, null);
    }

    public void logActions(boolean flag) {
        if (this.logActions) {
            this.LOGGER.info("Worker run: set logActions to " + flag);
        }
        this.logActions = flag;
    }

    public void kill() {
        this.server.shutdown();
    }

    public boolean isClosable() {
        return !this.keepRunning;
    }

    public String pluginVersion() {
        return VersionLogger.getPluginVersion();
    }

    public String pluginBuild() {
        return VersionLogger.getPluginBuild();
    }

    public String gate_version() {
        return Main.version;
    }

    public String gate_build() {
        return Main.build;
    }
}

