/*
 * Decompiled with CFR 0.152.
 */
package gate.plugin.python;

import gate.Gate;
import gate.Resource;
import gate.creole.ResourceInstantiationException;
import gate.creole.metadata.CreoleParameter;
import gate.creole.metadata.CreoleResource;
import gate.creole.metadata.Optional;
import gate.gui.NameBearerHandle;
import gate.gui.ResourceHelper;
import gate.plugin.python.PythonWorker;
import gate.util.GateRuntimeException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.apache.log4j.Logger;
import py4j.GatewayServer;

@CreoleResource(name="PythonWorkerRunner", tool=true, comment="Language Resource to represent a Python worker process.", helpURL="")
public class PythonWorkerRunner
extends ResourceHelper {
    private static final long serialVersionUID = -1392982236343502768L;
    public transient Logger LOGGER = Logger.getLogger(((Object)((Object)this)).getClass());
    protected Integer port = 25333;
    protected String host = "127.0.0.1";
    private transient PythonWorker worker = null;
    protected String authToken = "";
    protected Boolean logActions = false;
    protected Boolean keep = false;

    @Optional
    @CreoleParameter(comment="Port number to use.", defaultValue="25333")
    public void setPort(Integer value) {
        this.port = value;
    }

    public Integer getPort() {
        return this.port;
    }

    @Optional
    @CreoleParameter(comment="Host address", defaultValue="127.0.0.1")
    public void setHost(String value) {
        this.host = value;
    }

    public String getHost() {
        return this.host;
    }

    @Optional
    @CreoleParameter(comment="Auth Token", defaultValue="")
    public void setAuthToken(String value) {
        this.authToken = value;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    @CreoleParameter(comment="If actions should get logged", defaultValue="false")
    public void setLogActions(Boolean val) {
        this.logActions = val;
    }

    public Boolean getLogActions() {
        return this.logActions;
    }

    @Optional
    @CreoleParameter(comment="Keep running", defaultValue="false")
    public void setKeep(Boolean val) {
        this.keep = val;
    }

    public Boolean getKeep() {
        return this.keep;
    }

    public Object call(String action, Resource resource, Object ... params) {
        switch (action) {
            case "set_port": {
                this.port = (Integer)params[0];
                break;
            }
            case "set_host": {
                this.host = (String)params[0];
                break;
            }
            case "start": {
                try {
                    this.worker = new PythonWorker();
                }
                catch (ResourceInstantiationException ex) {
                    throw new GateRuntimeException("Could not create PythonWorker", (Throwable)ex);
                }
                this.startServer(this.worker);
                break;
            }
            default: {
                throw new GateRuntimeException("Not a known action: " + action);
            }
        }
        return null;
    }

    public Resource init() {
        return this;
    }

    public void startServer(PythonWorker pworker) {
        InetAddress hostAddress;
        try {
            hostAddress = InetAddress.getByName(this.host);
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException("Cannot resolve host address " + this.host, ex);
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)Gate.getClassLoader());
        if (this.authToken == null || this.authToken.trim().isEmpty()) {
            this.authToken = System.getenv("GATENLP_WORKER_TOKEN_" + this.port);
        }
        System.err.println("PythonWorkerRunner.java: starting server with " + this.port + "/" + this.host + "/" + this.authToken + "/" + this.logActions);
        pworker.logActions = this.logActions;
        pworker.keepRunning = this.keep;
        GatewayServer server = this.authToken == null || this.authToken.trim().isEmpty() ? new GatewayServer.GatewayServerBuilder().entryPoint((Object)pworker).javaPort(this.port.intValue()).javaAddress(hostAddress).build() : new GatewayServer.GatewayServerBuilder().entryPoint((Object)pworker).authToken(this.authToken).javaPort(this.port.intValue()).javaAddress(hostAddress).build();
        pworker.server = server;
        try {
            server.start();
            System.err.println("PythonWorkerRunner.java: server start OK");
            System.err.flush();
        }
        catch (Exception ex) {
            pworker.server = null;
            System.err.println("PythonWorkerRunner.java: server start NOT OK");
            System.err.flush();
            throw new GateRuntimeException("Could not start GatewayServer", (Throwable)ex);
        }
    }

    protected List<Action> buildActions(NameBearerHandle nbh) {
        return new ArrayList<Action>();
    }
}

