/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.api;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import uk.num.numlib.api.NumAPICallbacks;
import uk.num.numlib.api.NumAPIContext;
import uk.num.numlib.api.RequiredUserVariable;
import uk.num.numlib.exc.NumBadModuleConfigDataException;
import uk.num.numlib.exc.NumBadModuleIdException;
import uk.num.numlib.exc.NumBadMultipartRecordException;
import uk.num.numlib.exc.NumBadRecordException;
import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumDNSQueryException;
import uk.num.numlib.exc.NumException;
import uk.num.numlib.exc.NumInvalidDNSHostException;
import uk.num.numlib.exc.NumInvalidDNSQueryException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.exc.NumInvalidPopulatorResponseCodeException;
import uk.num.numlib.exc.NumInvalidRedirectException;
import uk.num.numlib.exc.NumMaximumRedirectsExceededException;
import uk.num.numlib.exc.NumNoRecordAvailableException;
import uk.num.numlib.exc.NumNotImplementedException;
import uk.num.numlib.exc.NumPopoulatorErrorException;
import uk.num.numlib.internal.ctx.NumAPIContextBase;
import uk.num.numlib.internal.dns.DNSServices;
import uk.num.numlib.internal.dns.DNSServicesDefaultImpl;
import uk.num.numlib.internal.dns.PossibleMultiPartRecordException;
import uk.num.numlib.internal.modl.ModlServices;
import uk.num.numlib.internal.modl.NumLookupRedirect;
import uk.num.numlib.internal.modl.NumQueryRedirect;
import uk.num.numlib.internal.modl.PopulatorResponse;
import uk.num.numlib.internal.module.ModuleConfig;
import uk.num.numlib.internal.module.ModuleDNSQueries;
import uk.num.numlib.internal.module.ModuleFactory;
import uk.num.numlib.internal.util.PopulatorRetryConfig;
import uk.num.numlib.internal.util.StringConstants;

public class NumAPI {
    public static final int MAX_NUM_REDIRECTS = 3;
    private static final int MAX_NUMBER_OF_MULTI_PARTS = 30;
    private DNSServices dnsServices;
    private ModlServices modlServices;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public NumAPI() {
        this.dnsServices = new DNSServicesDefaultImpl();
        this.modlServices = new ModlServices();
    }

    public NumAPI(DNSServices dnsServices, ModlServices modlServices) {
        this.dnsServices = dnsServices;
        this.modlServices = modlServices;
    }

    public NumAPI(String dnsHost) throws NumInvalidDNSHostException {
        this();
        try {
            if (!StringUtils.isEmpty((CharSequence)dnsHost)) {
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                Lookup.setDefaultResolver((Resolver)resolver);
            }
        }
        catch (UnknownHostException e) {
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
    }

    public NumAPI(String dnsHost, int port) throws NumInvalidDNSHostException {
        this();
        try {
            if (!StringUtils.isEmpty((CharSequence)dnsHost)) {
                SimpleResolver resolver = new SimpleResolver(dnsHost);
                resolver.setPort(port);
                Lookup.setDefaultResolver((Resolver)resolver);
                resolver.setTCP(true);
            }
        }
        catch (UnknownHostException e) {
            throw new NumInvalidDNSHostException("Invalid DNS host.", e);
        }
    }

    public void setTCPOnly(boolean flag) {
        Lookup.getDefaultResolver().setTCP(flag);
    }

    public void setTopLevelZone(String zone) {
        StringConstants.instance().setTopLevelZone(zone);
    }

    public NumAPIContext begin(String moduleId, String netString, int timeoutMillis) throws NumBadModuleIdException, NumBadModuleConfigDataException, NumBadURLException, NumInvalidParameterException, NumBadRecordException, NumDNSQueryException, NumInvalidDNSQueryException {
        assert (moduleId != null && moduleId.trim().length() > 0);
        assert (netString != null && netString.trim().length() > 0);
        assert (timeoutMillis > 0);
        NumAPIContextBase ctx = new NumAPIContextBase();
        ModuleDNSQueries moduleDNSQueries = ModuleFactory.getInstance(moduleId, netString);
        ctx.setModuleDNSQueries(moduleDNSQueries);
        Record[] records = this.dnsServices.getConfigFileTXTRecords(moduleId, timeoutMillis);
        if (records == null || records.length == 0) {
            throw new NumBadModuleIdException("No configuration moduleDNSQueries file available. Check that the moduleDNSQueries ID is correct.: " + moduleId);
        }
        String configTxt = this.dnsServices.rebuildTXTRecordContent(records).replaceAll("\\\\", "");
        ModuleConfig moduleConfig = this.modlServices.interpretModuleConfig(configTxt);
        if (!moduleConfig.isValid()) {
            throw new NumBadModuleConfigDataException("Invalid module config data: " + configTxt);
        }
        ctx.setModuleConfig(moduleConfig);
        return ctx;
    }

    public Future<String> retrieveNumRecord(NumAPIContext ctx, NumAPICallbacks handler, int timeoutMillis) {
        assert (ctx != null);
        assert (handler != null);
        return this.executor.submit(() -> {
            while (true) {
                NumAPIContextBase context = (NumAPIContextBase)ctx;
                try {
                    ModuleConfig moduleConfig = context.getModuleConfig();
                    String jsonResult = this.getNumRecordFromIndependentLocation(timeoutMillis, context);
                    if (jsonResult == null) {
                        jsonResult = this.getNumRecordFromManagedLocation(timeoutMillis, context);
                        if (jsonResult != null) {
                            handler.setLocation(NumAPICallbacks.Location.MANAGED);
                        }
                        if (context.getModuleDNSQueries().isRootQuery()) {
                            if (jsonResult == null && moduleConfig.getModule().isRprq() && (jsonResult = this.getNumRecordFromPrepopulatedLocation(timeoutMillis, context)) != null) {
                                handler.setLocation(NumAPICallbacks.Location.POPULATED);
                            }
                            if (jsonResult == null && moduleConfig.getModule().isRpsq()) {
                                jsonResult = this.getNumRecordFromPopulator(timeoutMillis, context);
                            }
                        } else {
                            if (jsonResult == null && moduleConfig.getModule().isBprq() && (jsonResult = this.getNumRecordFromPrepopulatedLocation(timeoutMillis, context)) != null) {
                                handler.setLocation(NumAPICallbacks.Location.POPULATED);
                            }
                            if (jsonResult == null && moduleConfig.getModule().isBpsq()) {
                                jsonResult = this.getNumRecordFromPopulator(timeoutMillis, context);
                            }
                        }
                    } else {
                        handler.setLocation(NumAPICallbacks.Location.INDEPENDENT);
                    }
                    if (jsonResult != null && jsonResult.trim().length() > 0) {
                        handler.setResult(jsonResult);
                        return jsonResult;
                    }
                    handler.setErrorResult("Cannot retrieve the NUM record for module: " + moduleConfig.getModule().getName());
                }
                catch (NumException e) {
                    handler.setErrorResult("Cannot retrieve the NUM record for module: " + e.getLocalizedMessage());
                }
                catch (NumLookupRedirect numLookupRedirect) {
                    int redirectCount = context.incrementRedirectCount();
                    if (redirectCount >= 3) {
                        throw new NumMaximumRedirectsExceededException();
                    }
                    context.handleLookupRedirect(numLookupRedirect.getRedirect());
                    continue;
                }
                break;
            }
            return null;
        });
    }

    private String getNumRecordFromPrepopulatedLocation(int timeoutMillis, NumAPIContextBase context) throws NumBadMultipartRecordException, NumNotImplementedException, NumInvalidDNSQueryException, NumLookupRedirect, NumBadRecordException, NumMaximumRedirectsExceededException, NumBadURLException, NumInvalidRedirectException, NumInvalidParameterException {
        String recordLocation;
        String numRecord;
        String json = null;
        while ((numRecord = this.getNumRecord(timeoutMillis, context, recordLocation = context.getModuleDNSQueries().getPrepopulatedRecordLocation())) != null && numRecord.trim().length() > 0) {
            try {
                json = this.interpretNumRecord(numRecord, context);
                break;
            }
            catch (NumQueryRedirect numQueryRedirect) {
                int redirectCount = context.incrementRedirectCount();
                if (redirectCount >= 3) {
                    throw new NumMaximumRedirectsExceededException();
                }
                context.handlePrepopulatedQueryRedirect(numQueryRedirect.getRedirect());
            }
        }
        return json;
    }

    private Record[] getMultiPartRecords(int timeoutMillis, NumAPIContextBase context, String recordLocation) throws NumBadMultipartRecordException, NumInvalidDNSQueryException, NumNotImplementedException {
        Record[] numberOfPartsRecord = this.dnsServices.getRecordFromDns("0." + recordLocation, timeoutMillis, context.getModuleConfig().getModule().isDsr());
        if (numberOfPartsRecord == null || numberOfPartsRecord.length == 0) {
            return null;
        }
        String numberOfPartsStr = this.dnsServices.rebuildTXTRecordContent(numberOfPartsRecord);
        if (!numberOfPartsStr.startsWith("parts=")) {
            throw new NumBadMultipartRecordException("Invalid record 0 for multi-part record: " + numberOfPartsStr);
        }
        int numberOfParts = Integer.parseInt(numberOfPartsStr.substring(6));
        if (numberOfParts > 30) {
            throw new NumBadMultipartRecordException("Too many parts for a multi-part record: " + numberOfPartsStr);
        }
        ArrayList<Record> parts = new ArrayList<Record>();
        for (int i = 1; i <= numberOfParts; ++i) {
            Record[] partNRecords = this.dnsServices.getRecordFromDns("" + i + "." + recordLocation, timeoutMillis, context.getModuleConfig().getModule().isDsr());
            if (partNRecords == null || partNRecords.length <= 0) continue;
            parts.addAll(Arrays.asList(partNRecords));
        }
        Record[] recordFromDns = parts.toArray(new Record[0]);
        return recordFromDns;
    }

    private String getNumRecordFromPopulator(int timeoutMillis, NumAPIContextBase context) throws NumPopoulatorErrorException, NumNoRecordAvailableException, NumInvalidPopulatorResponseCodeException, NumBadMultipartRecordException, NumBadRecordException, NumNotImplementedException, NumInvalidDNSQueryException, NumLookupRedirect, NumMaximumRedirectsExceededException, NumInvalidParameterException, NumBadURLException, NumInvalidRedirectException {
        String recordLocation = context.getModuleDNSQueries().getPopulatorLocation();
        String numRecord = null;
        while (numRecord == null && (numRecord = this.getNumRecord(timeoutMillis, context, recordLocation)) != null) {
            PopulatorResponse response = this.modlServices.interpretPopulatorResponse(numRecord);
            if (!response.isValid()) {
                throw new NumInvalidPopulatorResponseCodeException("Bad response received from the populator service.");
            }
            if (response.getStatus_() != null) {
                numRecord = this.handlePopulatorStatusCodes(timeoutMillis, context, response);
            }
            if (response.getError_() == null) continue;
            if (response.getError_().getCode() == 100) {
                try {
                    for (int i = 0; i < PopulatorRetryConfig.ERROR_RETRIES; ++i) {
                        TimeUnit.SECONDS.sleep(PopulatorRetryConfig.ERROR_RETRY_DELAYS[i]);
                        numRecord = this.getNumRecord(timeoutMillis, context, recordLocation);
                        PopulatorResponse retryResponse = this.modlServices.interpretPopulatorResponse(numRecord);
                        if (retryResponse.getStatus_() == null) continue;
                        return this.handlePopulatorStatusCodes(timeoutMillis, context, retryResponse);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            throw new NumPopoulatorErrorException(response.getError_().getDescription());
        }
        return numRecord;
    }

    private String handlePopulatorStatusCodes(int timeoutMillis, NumAPIContextBase context, PopulatorResponse response) throws NumNoRecordAvailableException, NumInvalidPopulatorResponseCodeException, NumBadMultipartRecordException, NumInvalidDNSQueryException, NumNotImplementedException, NumLookupRedirect, NumBadRecordException, NumMaximumRedirectsExceededException, NumBadURLException, NumInvalidParameterException, NumInvalidRedirectException {
        String numRecord = null;
        switch (response.getStatus_().getCode()) {
            case 1: {
                try {
                    for (int i = 0; i < PopulatorRetryConfig.RETRIES; ++i) {
                        TimeUnit.SECONDS.sleep(PopulatorRetryConfig.RETRY_DELAYS[i]);
                        numRecord = this.getNumRecordFromPrepopulatedLocation(timeoutMillis, context);
                        if (numRecord != null) break;
                    }
                    throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            case 2: {
                numRecord = this.getNumRecordFromIndependentLocation(timeoutMillis, context);
                if (numRecord != null) break;
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            case 3: {
                numRecord = this.getNumRecordFromManagedLocation(timeoutMillis, context);
                if (numRecord != null) break;
                throw new NumNoRecordAvailableException("Cannot retrieve NUM record from any location.");
            }
            default: {
                throw new NumInvalidPopulatorResponseCodeException("Invalid response code from DNS populator service.");
            }
        }
        return numRecord;
    }

    private String getNumRecordFromManagedLocation(int timeoutMillis, NumAPIContextBase context) throws NumBadMultipartRecordException, NumNotImplementedException, NumInvalidDNSQueryException, NumLookupRedirect, NumBadRecordException, NumMaximumRedirectsExceededException, NumBadURLException, NumInvalidRedirectException, NumInvalidParameterException {
        String recordLocation;
        String numRecord;
        String json = null;
        while ((numRecord = this.getNumRecord(timeoutMillis, context, recordLocation = context.getModuleDNSQueries().getManagedRecordLocation())) != null && numRecord.trim().length() > 0) {
            try {
                json = this.interpretNumRecord(numRecord, context);
                break;
            }
            catch (NumQueryRedirect numQueryRedirect) {
                int redirectCount = context.incrementRedirectCount();
                if (redirectCount >= 3) {
                    throw new NumMaximumRedirectsExceededException();
                }
                context.handleManagedQueryRedirect(numQueryRedirect.getRedirect());
            }
        }
        return json;
    }

    private String getInterpretedNumRecordAsJson(String moduleNumber, ModuleConfig moduleConfig, String numRecord) throws NumBadRecordException, NumQueryRedirect, NumLookupRedirect {
        StringBuilder numRecordBuffer = new StringBuilder();
        RequiredUserVariable[] ruv = moduleConfig.getModule().getRuv();
        if (ruv != null) {
            for (RequiredUserVariable v : ruv) {
                numRecordBuffer.append(v.getKey());
                numRecordBuffer.append("=");
                numRecordBuffer.append(v.getValue());
                numRecordBuffer.append(";");
            }
        }
        numRecordBuffer.append("*load=\"http://modules.num.uk/");
        numRecordBuffer.append(moduleNumber);
        numRecordBuffer.append("/rcf.txt!\";");
        numRecordBuffer.append(numRecord);
        return this.modlServices.interpretNumRecord(numRecordBuffer.toString());
    }

    private String getNumRecordFromIndependentLocation(int timeoutMillis, NumAPIContextBase context) throws NumBadMultipartRecordException, NumNotImplementedException, NumInvalidDNSQueryException, NumLookupRedirect, NumBadRecordException, NumMaximumRedirectsExceededException, NumInvalidParameterException, NumBadURLException, NumInvalidRedirectException {
        String recordLocation;
        String numRecord;
        String json = null;
        while ((numRecord = this.getNumRecord(timeoutMillis, context, recordLocation = context.getModuleDNSQueries().getIndependentRecordLocation())) != null && numRecord.trim().length() > 0) {
            try {
                json = this.interpretNumRecord(numRecord, context);
                break;
            }
            catch (NumQueryRedirect numQueryRedirect) {
                int redirectCount = context.incrementRedirectCount();
                if (redirectCount >= 3) {
                    throw new NumMaximumRedirectsExceededException();
                }
                context.handleIndependentQueryRedirect(numQueryRedirect.getRedirect());
            }
        }
        return json;
    }

    private String interpretNumRecord(String numRecord, NumAPIContextBase context) throws NumLookupRedirect, NumBadRecordException, NumQueryRedirect {
        String json = null;
        if (numRecord != null && numRecord.trim().length() > 0) {
            json = this.getInterpretedNumRecordAsJson(context.getModuleDNSQueries().getModuleId(), context.getModuleConfig(), numRecord);
        }
        return json;
    }

    private String getNumRecord(int timeoutMillis, NumAPIContextBase context, String recordLocation) throws NumBadMultipartRecordException, NumInvalidDNSQueryException, NumNotImplementedException {
        Record[] recordFromDns;
        try {
            recordFromDns = this.dnsServices.getRecordFromDns(recordLocation, timeoutMillis, context.getModuleConfig().getModule().isDsr());
        }
        catch (PossibleMultiPartRecordException e) {
            recordFromDns = this.getMultiPartRecords(timeoutMillis, context, recordLocation);
        }
        if (recordFromDns == null || recordFromDns.length == 0) {
            return null;
        }
        return this.dnsServices.rebuildTXTRecordContent(recordFromDns);
    }

    public void shutdown() {
        try {
            this.executor.shutdown();
            this.executor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (!this.executor.isTerminated()) {
                this.executor.shutdownNow();
            }
        }
    }
}

