/*
 * Decompiled with CFR 0.152.
 */
package uk.num.numlib.internal.module;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.num.numlib.exc.NumBadURLException;
import uk.num.numlib.exc.NumInvalidParameterException;
import uk.num.numlib.internal.ctx.AppContext;
import uk.num.numlib.internal.module.ModuleDNSQueries;
import uk.num.numlib.internal.util.SimpleCache;

public class ModuleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ModuleFactory.class);
    private final SimpleCache<String, ModuleDNSQueries> moduleMap = new SimpleCache();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleDNSQueries getInstance(AppContext appContext, String moduleName, String domainName) throws NumInvalidParameterException, NumBadURLException {
        ModuleDNSQueries result;
        if (moduleName == null || moduleName.trim().isEmpty()) {
            LOG.error("Invalid moduleName supplied: null or empty.");
            throw new NumInvalidParameterException("Invalid moduleName supplied: null or empty.");
        }
        if (domainName == null || domainName.trim().isEmpty()) {
            LOG.error("Invalid domainName supplied: null or empty.");
            throw new NumInvalidParameterException("Invalid domainName supplied: null or empty.");
        }
        String key = moduleName + "_" + domainName;
        SimpleCache<String, ModuleDNSQueries> simpleCache = this.moduleMap;
        synchronized (simpleCache) {
            result = this.moduleMap.get(key);
            if (result == null) {
                result = new ModuleDNSQueries(moduleName, domainName);
                result.initialise(appContext);
                this.moduleMap.put(key, result);
                LOG.trace("Cached a new set of ModuleDNSQueries.");
            } else {
                LOG.trace("Using cached ModuleDNSQueries.");
            }
        }
        return result;
    }
}

